/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.CommandLineParser;
import com.intel.ism.core.Resources;
import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.UnexpectedShutdownHandler;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.controllers.ApplicationManager;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Main {
    public static void main(String[] args) throws RemoteException {
        SumLogger.enableLogging();
        ApplicationManager.getInstance().checkPrerequisites();
        final CommandLineParser clp = new CommandLineParser(args);
        clp.parseArguments();
        boolean remoteCall = Main.isArgumentsValid(clp);
        if (remoteCall) {
            if (Settings.defaultSettings.getCheckingForUpdateMode() == Settings.ECFUMode.MANUAL) {
                SumLogger.logger.info("main(): context mode is enabled, skipping remote call and exiting ...");
                System.exit(0);
            }
            boolean firstInstance = true;
            File lockFile = new File(ApplicationManager.getInstance().getLockFileFullPath());
            firstInstance = !lockFile.exists();
            if (firstInstance) {
                SumLogger.logger.info("-- first instance of application --");
                String pathToJar = ApplicationManager.getInstance().getPathToJar();
                String[] cmd = clp.getAction().equals("get_info") ? new String[]{pathToJar + "/ism", "--intray", "yes"} : (clp.getAction().equals("check") ? new String[]{pathToJar + "/ism", "--intray", "yes", "--product_guid", clp.getGuid()} : new String[]{pathToJar + "/ism", "--intray", "no"});
                try {
                    Runtime.getRuntime().exec(cmd);
                }
                catch (IOException ex) {
                    SumLogger.logger.log(Level.INFO, "main(): fail to run jar file as separate instance (cmd = {0}) : {1}", new Object[]{cmd, ex.toString()});
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean needCheckForUpdates = false;
                        boolean needExit = true;
                        ApplicationManager.getInstance().runClient(clp, needCheckForUpdates, needExit);
                    }
                });
            } else {
                SumLogger.logger.info("-- second instance of application --");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean needCheckForUpdates = true;
                        boolean needExit = false;
                        ApplicationManager.getInstance().runClient(clp, needCheckForUpdates, needExit);
                    }
                });
            }
        } else {
            boolean isInternalCallOfServer;
            ApplicationManager.getInstance().setLockFile();
            boolean firstInstance = !ApplicationManager.getInstance().isApplicationRunning();
            boolean bl = isInternalCallOfServer = !clp.getInTray().equals("");
            if (isInternalCallOfServer) {
                if (firstInstance) {
                    SumLogger.logger.info("Registering shutdown hook...");
                    Runtime.getRuntime().addShutdownHook(new Thread(new UnexpectedShutdownHandler()));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            boolean shouldBeVisible = !clp.getInTray().equals("yes");
                            String guid = clp.getGuid().equals("") ? "EMPTY" : clp.getGuid();
                            ApplicationManager.getInstance().runApplication(shouldBeVisible, guid);
                        }
                    });
                } else {
                    SumLogger.logger.warning("Multiple run of servers detected, when previous server is still alive - skipping launch...");
                    System.exit(0);
                }
            } else if (firstInstance) {
                SumLogger.logger.info("-- first instance of application --");
                SumLogger.logger.info("Registering shutdown hook...");
                Runtime.getRuntime().addShutdownHook(new Thread(new UnexpectedShutdownHandler()));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean shouldBeVisible = true;
                        ApplicationManager.getInstance().runApplication(shouldBeVisible);
                    }
                });
            } else {
                SumLogger.logger.info("-- second instance of application --");
                String msg = Resources.getInstance().getBundle().getString("common_error_one_instance");
                System.err.println(msg);
                JOptionPane.showMessageDialog(Gui.getInstance(), msg, Resources.getInstance().getProductName(), 0);
                SumLogger.logger.severe(msg);
                System.exit(0);
            }
        }
    }

    private static boolean isArgumentsValid(CommandLineParser clp) {
        boolean result = true;
        String action = clp.getAction();
        if (!clp.getGuid().equals("") && !action.equals("")) {
            if (!(action.equals("get_info") || action.equals("view") || action.equals("download") || action.equals("check"))) {
                SumLogger.logger.log(Level.WARNING, "isArgumentsValid(): non-valid parameter of --action option: {0}", action);
                result = false;
            } else if (action.equals("get_info") && clp.getResponseFile().equals("")) {
                SumLogger.logger.log(Level.WARNING, "isArgumentsValid(): empty value of response file when action = get_info");
                result = false;
            }
        } else {
            SumLogger.logger.log(Level.WARNING, "isArgumentsValid(): empty values of Guid or Action: guid={0}; action={1}", new Object[]{clp.getGuid(), action});
            result = false;
        }
        return result;
    }
}

