/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.core.Settings;
import com.intel.ism.gui.Common;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.SumImages;
import com.intel.ism.gui.controllers.FontManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class InfoDialog
extends JDialog {
    private static JPanel panel = new JPanel();
    private static InfoDialog dialog;
    public static final int DIALOG_HEIGHT = 380;
    public static final int DIALOG_WIDTH = 200;

    public static synchronized InfoDialog getInstance() {
        if (dialog == null) {
            dialog = new InfoDialog();
        }
        return dialog;
    }

    private InfoDialog() {
        super(Gui.getInstance(), Resources.getInstance().getProductName(), true);
        this.fillPanel();
        this.add((Component)panel, "Center");
        this.setSize(380, 200);
        this.setResizable(false);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static void refresh() {
        dialog.setVisible(false);
        dialog.setLocationRelativeTo(dialog.getParent());
        dialog.setVisible(true);
    }

    private void fillPanel() {
        JButton btnOK = new JButton(Resources.getInstance().getBtnOk());
        btnOK.setFocusPainted(false);
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        JLabel jlbText = new JLabel(Resources.getInstance().getBundle().getString("info_dlg_text"), SumImages.imgInfo, 2);
        JLabel jlbLink = new JLabel(Resources.getInstance().getBundle().getString("info_dlg_lbl_purchase_opts")){

            @Override
            public Font getFont() {
                return FontManager.getUnderlinedFont();
            }

            @Override
            public Color getForeground() {
                return Color.BLUE;
            }
        };
        jlbLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Common.openBrowser(Settings.defaultSettings.getRenewURL());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                InfoDialog.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                InfoDialog.this.setCursor(new Cursor(0));
            }
        });
        GridBagLayout gbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 10, 0, 10);
        gbag.setConstraints(jlbText, gbc);
        gbc.weightx = 0.2;
        gbc.weighty = 0.2;
        ++gbc.gridy;
        gbc.insets = new Insets(0, SumImages.imgInfo.getIconWidth() + 15, 15, 10);
        gbc.fill = 17;
        gbag.setConstraints(jlbLink, gbc);
        GridBagLayout gbagBottomPanel = new GridBagLayout();
        GridBagConstraints gbcBottomPanel = new GridBagConstraints();
        gbcBottomPanel.weightx = 1.0;
        gbcBottomPanel.weighty = 1.0;
        gbcBottomPanel.anchor = 13;
        gbcBottomPanel.insets = new Insets(5, 0, 5, 5);
        gbagBottomPanel.setConstraints(btnOK, gbcBottomPanel);
        JPanel panelBtnClose = new JPanel(gbagBottomPanel);
        panelBtnClose.add(btnOK);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbag.setConstraints(panelBtnClose, gbc);
        panel.setBackground(Color.white);
        panel.setLayout(gbag);
        panel.add(jlbText);
        panel.add(jlbLink);
        panel.add(panelBtnClose);
    }
}

