/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.data.DataManager;
import com.intel.ism.core.data.ErrorNum;
import com.intel.ism.gui.Common;
import com.intel.ism.gui.PanelBottom;
import com.intel.ism.gui.PanelTop;
import com.intel.ism.gui.RemoteInterface;
import com.intel.ism.gui.SumImages;
import com.intel.ism.gui.TabPanel;
import com.intel.ism.gui.TabUpdatesAndDownloads;
import com.intel.ism.gui.controllers.ApplicationManager;
import com.intel.ism.gui.controllers.FontManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public final class Gui
extends JFrame
implements RemoteInterface {
    private static Gui gui;
    private PanelBottom bottomPanel;
    private PanelTop topPanel;
    private JLayeredPane lpane;
    private JLabel jlbOLH;
    private JLabel jlbSupport;
    private JLabel jlbWait;
    private JPanel jpnProgressBarAndButton;
    public static final int PANEL_MIN_WIDTH;
    public static final int PANEL_MIN_HEIGHT = 630;

    public static synchronized Gui getInstance() {
        if (gui == null) {
            gui = new Gui();
        }
        return gui;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private static Insets copyInsets(Insets insets) {
        if (insets != null) {
            return (Insets)insets.clone();
        }
        return null;
    }

    private Gui() {
        Font plainFont = FontManager.getPlainFont();
        UIManager.put("TabbedPane.font", FontManager.getBoldFont());
        UIManager.put("Label.font", plainFont);
        UIManager.put("EditorPane.font", plainFont);
        UIManager.put("MenuItem.font", plainFont);
        UIManager.put("TableHeader.font", plainFont);
        UIManager.put("Table.font", plainFont);
        UIManager.put("RadioButton.font", plainFont);
        UIManager.put("Button.font", plainFont);
        UIManager.put("CheckBox.font", plainFont);
        UIManager.put("ComboBox.font", plainFont);
        UIManager.put("TextField.font", plainFont);
        UIManager.put("TextPane.font", plainFont);
        Color lightGray = new Color(238, 238, 238);
        UIManager.put("TabbedPane.background", lightGray);
        UIManager.put("ToolTip.background", lightGray);
        UIManager.put("TabbedPane.selected", Color.WHITE);
        UIManager.put("Label.background", Color.WHITE);
        UIManager.put("Table.background", Color.WHITE);
        UIManager.put("MenuItem.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        UIManager.put("RadioButton.background", Color.WHITE);
        UIManager.put("CheckBox.background", Color.WHITE);
        UIManager.put("ComboBox.background", Color.WHITE);
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("TextField.background", Color.WHITE);
        this.initFindingUpdatesPanel();
        this.topPanel = new PanelTop();
        this.bottomPanel = PanelBottom.getInstance();
        this.setTitle(Resources.getInstance().getProductName());
        Insets insets = Gui.copyInsets(UIManager.getInsets("TabbedPane.tabInsets"));
        if (insets != null) {
            insets.top += 26;
            UIManager.put("TabbedPane.tabInsets", insets);
        }
        this.setLocationRelativeTo(null);
        if (Common.isMac()) {
            this.setIconImage(SumImages.imgAppIcon64x64.getImage());
            this.setDefaultCloseOperation(0);
        } else {
            this.setIconImage(SumImages.imgAppIcon32x32.getImage());
            this.setDefaultCloseOperation(1);
        }
        this.setResizable(true);
        this.setLocationByPlatform(true);
        this.jlbOLH = new JLabel(Resources.getInstance().getBundle().getString("tabbed_pane_online_help_lbl")){

            @Override
            public Font getFont() {
                return FontManager.getUnderlinedFont();
            }

            @Override
            public Color getForeground() {
                return Color.BLUE;
            }
        };
        this.jlbOLH.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Common.openBrowser(Resources.getInstance().getBundle().getString("tabbed_pane_online_help_url"));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Gui.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Gui.this.setCursor(new Cursor(0));
            }
        });
        this.jlbOLH.setBorder(BorderFactory.createEmptyBorder(0, 10, 2, 0));
        this.jlbSupport = new JLabel(Resources.getInstance().getBundle().getString("tabbed_pane_support_lbl")){

            @Override
            public Font getFont() {
                return FontManager.getUnderlinedFont();
            }

            @Override
            public Color getForeground() {
                return Color.BLUE;
            }
        };
        this.jlbSupport.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Common.openBrowser(Resources.getInstance().getBundle().getString("tabbed_pane_support_url"));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Gui.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Gui.this.setCursor(new Cursor(0));
            }
        });
        this.jlbSupport.setBorder(BorderFactory.createEmptyBorder(0, 10, 2, 0));
        this.lpane = new JLayeredPane();
        Dimension d = new Dimension(PANEL_MIN_WIDTH, 630);
        this.lpane.setPreferredSize(d);
        this.lpane.setLayout(new BorderLayout());
        this.jlbSupport.setBounds(0, this.lpane.getPreferredSize().height - this.bottomPanel.getPreferredSize().height - this.jlbSupport.getPreferredSize().height, this.jlbSupport.getPreferredSize().width, this.jlbSupport.getPreferredSize().height);
        this.jlbOLH.setBounds(0, this.lpane.getPreferredSize().height - this.bottomPanel.getPreferredSize().height - this.jlbSupport.getPreferredSize().height - this.jlbOLH.getPreferredSize().height, this.jlbOLH.getPreferredSize().width, this.jlbOLH.getPreferredSize().height);
        this.lpane.add((Component)this.topPanel, "North");
        this.lpane.add((Component)TabPanel.getInstance(), "Center");
        this.lpane.add((Component)this.jlbOLH, "South");
        this.lpane.add((Component)this.jlbSupport, "South");
        this.lpane.setLayer(this.jlbOLH, 1);
        this.lpane.setLayer(this.jlbSupport, 1);
        this.lpane.add((Component)this.bottomPanel, "South");
        this.setContentPane(this.lpane);
        this.pack();
        this.setMinimumSize(new Dimension(this.getWidth(), this.getHeight()));
        if (Common.isMac()) {
            try {
                Class<?> cls = Class.forName("com.intel.ism.osxgui.OSXGui");
                Object obj = cls.newInstance();
                Class[] noparams = new Class[]{};
                Method mtd = cls.getDeclaredMethod("registerHandlers", noparams);
                mtd.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                SumLogger.logger.log(Level.INFO, "Couldn't invoke OSXGui.RegisterHandlers()");
            }
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    Gui.this.setExtendedState(1);
                }
            });
        }
    }

    private void initFindingUpdatesPanel() {
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        progressBar.setPreferredSize(new Dimension(200, 25));
        JButton btnCancel = new JButton(Resources.getInstance().getBtnCancel());
        btnCancel.setFocusPainted(false);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationManager.getInstance().interruptCheckForUpdates();
            }
        });
        this.jlbWait = new JLabel(Resources.getInstance().getLabelWait(), SumImages.imgInfo, 2);
        this.jpnProgressBarAndButton = new JPanel(){

            @Override
            public Color getBackground() {
                return Color.WHITE;
            }
        };
        this.jpnProgressBarAndButton.add(progressBar);
        this.jpnProgressBarAndButton.add(btnCancel);
    }

    public void showFindingUpdatesPanel(JPanel panel) {
        panel.removeAll();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        panel.add((Component)this.jlbWait, gbc);
        gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        panel.add((Component)this.jpnProgressBarAndButton, gbc);
        panel.updateUI();
    }

    public PanelTop getTopPanel() {
        return this.topPanel;
    }

    public void resized(ComponentEvent e) {
        this.jlbSupport.setLocation(0, this.lpane.getHeight() - this.bottomPanel.getPreferredSize().height - this.jlbSupport.getPreferredSize().height);
        this.jlbOLH.setLocation(0, this.lpane.getHeight() - this.bottomPanel.getPreferredSize().height - this.jlbSupport.getPreferredSize().height - this.jlbOLH.getPreferredSize().height);
    }

    @Override
    public boolean actionGetInfo(String guid, String file, boolean needRunCheckForUpdates) throws RemoteException {
        if (needRunCheckForUpdates) {
            this.bottomPanel.btnCheckForUpdatesClick();
        }
        while (!ApplicationManager.getInstance().getAllTabsRefreshed()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {}
        }
        boolean result = false;
        if (DataManager.defaultDataManager.getStatusofGetAllData() == ErrorNum.EGetDataErrors.SUCCESS) {
            result = true;
        }
        if (!TabUpdatesAndDownloads.getInstance().rmi_serializeUpdateToFile(guid, file, result)) {
            result = false;
        }
        return result;
    }

    @Override
    public void actionCheck(String guid, boolean needRunCheckForUpdates) throws RemoteException {
        SumLogger.logger.info("actionCheck(): trying to run remote check action: ");
        if (needRunCheckForUpdates && !ApplicationManager.getInstance().isCheckForUpdatesRunning()) {
            boolean flagRemote = true;
            this.bottomPanel.btnCheckForUpdatesClick(guid, flagRemote);
        }
    }

    @Override
    public void actionView(String guid, boolean needRunCheckForUpdates) throws RemoteException {
        SumLogger.logger.log(Level.INFO, "actionView(): trying to run remote view action for {0}", guid);
        if (needRunCheckForUpdates && !ApplicationManager.getInstance().isCheckForUpdatesRunning()) {
            this.bottomPanel.btnCheckForUpdatesClick();
        }
        this.setState(0);
        this.setVisible(true);
        this.toFront();
        while (!ApplicationManager.getInstance().getAllTabsRefreshed()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        TabPanel.getInstance().setSelectedIndex(0);
        TabUpdatesAndDownloads.getInstance().rmi_highlightUpdate(guid);
    }

    @Override
    public void actionDownload(String guid, boolean needRunCheckForUpdates) throws RemoteException {
        SumLogger.logger.log(Level.INFO, "actionDownload(): trying to run remote download action for {0}", guid);
        if (needRunCheckForUpdates && !ApplicationManager.getInstance().isCheckForUpdatesRunning()) {
            this.bottomPanel.btnCheckForUpdatesClick();
        }
        this.setState(0);
        this.setVisible(true);
        this.toFront();
        while (!ApplicationManager.getInstance().getAllTabsRefreshed()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        TabPanel.getInstance().setSelectedIndex(0);
        TabUpdatesAndDownloads.getInstance().rmi_startDownload(guid);
    }

    @Override
    public void actionExit() throws RemoteException {
        SumLogger.logger.info("actionExit(): trying to run remote EXIT action");
        ApplicationManager.getInstance().exitAction(0);
    }

    static {
        PANEL_MIN_WIDTH = SumImages.imgLeftTopHeader.getIconWidth() + SumImages.imgTopHeaderBg.getIconWidth();
    }
}

