/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.data.providers.EvalTrustedStorageDataProvider;
import com.intel.ism.core.objects.LicenseMessageData;
import com.intel.ism.gui.Common;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.PanelBottom;
import com.intel.ism.gui.SumImages;
import com.intel.ism.gui.controllers.FontManager;
import isus.USAgent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class ActivationToolDialog
extends JDialog {
    private static ActivationToolDialog dialog;
    private LicenseMessageData lmdItem = null;
    private JPanel panel = new JPanel();
    private final JButton btnActivate = new JButton(Resources.getInstance().getBundle().getString("button_activate"));
    private final JButton btnCancel = new JButton(Resources.getInstance().getBundle().getString("button_cancel"));
    private final JButton btnRetry = new JButton(Resources.getInstance().getBundle().getString("button_retry"));
    private final JButton btnClose = new JButton(Resources.getInstance().getBundle().getString("button_close"));
    private JLimitedTextField editSNLeft;
    private JLimitedTextField editSNRight;
    private String snLeft;
    private String snRight;
    private static final int DIALOG_WIDTH = 450;
    private static final int DIALOG_HEIGHT = 250;

    private ActivationToolDialog() {
        super(Gui.getInstance(), Resources.getInstance().getBundle().getString("activation_tool_dialog_title"), true);
        this.add((Component)this.panel, "Center");
        this.createDialogActivation();
        this.setSize(450, 250);
        this.setResizable(false);
        this.snLeft = "";
        this.snRight = "";
    }

    public static synchronized ActivationToolDialog getInstance() {
        if (dialog == null) {
            dialog = new ActivationToolDialog();
        }
        return dialog;
    }

    public void refresh(LicenseMessageData lmdItem) {
        this.lmdItem = lmdItem;
        this.createDialogActivation();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void removeBtnListeners(JButton button) {
        for (ActionListener i : button.getActionListeners()) {
            button.removeActionListener(i);
        }
    }

    private void createDialogActivation() {
        this.panel.removeAll();
        this.removeBtnListeners(this.btnCancel);
        this.removeBtnListeners(this.btnActivate);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        this.btnCancel.setFocusTraversalKeysEnabled(false);
        this.btnCancel.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    if (e.isShiftDown()) {
                        ActivationToolDialog.this.btnActivate.requestFocusInWindow();
                    } else {
                        ActivationToolDialog.this.editSNLeft.selectAll();
                        ActivationToolDialog.this.editSNLeft.requestFocusInWindow();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.btnActivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivationToolDialog.this.snLeft = ActivationToolDialog.this.editSNLeft.getText();
                ActivationToolDialog.this.snRight = ActivationToolDialog.this.editSNRight.getText();
                final String sn = ActivationToolDialog.this.snLeft + "-" + ActivationToolDialog.this.snRight;
                if (!sn.matches("[a-zA-Z0-9]{4}-[a-zA-Z0-9]{8}")) {
                    String msg = Resources.getInstance().getBundle().getString("activation_tool_dialog_msg_invalid_sn_format");
                    if (sn.trim().equals("-")) {
                        msg = Resources.getInstance().getBundle().getString("activation_tool_dialog_msg_sn_is_empty");
                    }
                    JOptionPane.showMessageDialog(dialog, msg, Resources.getInstance().getProductName(), 0);
                } else {
                    ActivationToolDialog.this.createProgressBarDialog();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            SumLogger.logger.log(Level.INFO, "ActivationToolDialog: calling issalib for SN={0}", sn);
                            int ircResponse = EvalTrustedStorageDataProvider.getDefaultProvider().getLicenseFromIRC(sn);
                            switch (ircResponse) {
                                case 0: {
                                    SumLogger.logger.log(Level.INFO, "ActivationToolDialog: license is received!");
                                    if (ActivationToolDialog.this.lmdItem != null) {
                                        USAgent agent = new USAgent();
                                        agent.setProductBaseDir(ActivationToolDialog.this.lmdItem.getProductDbLocation());
                                        agent.setValue(ActivationToolDialog.this.lmdItem.getGuid(), "SN", sn);
                                    }
                                    ActivationToolDialog.this.createDialogOK();
                                    break;
                                }
                                case -2001: 
                                case -3: {
                                    SumLogger.logger.log(Level.WARNING, "ActivationToolDialog: error - ISSA returned #{0} (connection error)", ircResponse);
                                    ActivationToolDialog.this.createDialogError(Resources.getInstance().getBundle().getString("activation_tool_dialog_lbl_err_no_connection_short_desc"), Resources.getInstance().getBundle().getString("activation_tool_dialog_lbl_err_no_connection_full_desc"));
                                    break;
                                }
                                default: {
                                    SumLogger.logger.log(Level.WARNING, "ActivationToolDialog: error - ISSA returned #{0}", ircResponse);
                                    ActivationToolDialog.this.createDialogError(Resources.getInstance().getBundle().getString("activation_tool_dialog_lbl_invalid_serial_number_short_desc"), Resources.getInstance().getBundle().getString("activation_tool_dialog_lbl_invalid_serial_number_full_desc"));
                                }
                            }
                        }
                    };
                    Thread t = new Thread(r, "ActivationDialog: thread to connect to IRC");
                    t.start();
                }
            }
        });
        this.btnActivate.setFocusTraversalKeysEnabled(false);
        this.btnActivate.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    if (e.isShiftDown()) {
                        ActivationToolDialog.this.editSNRight.selectAll();
                        ActivationToolDialog.this.editSNRight.requestFocusInWindow();
                    } else {
                        ActivationToolDialog.this.btnCancel.requestFocusInWindow();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        JLabel jlbInfo = new JLabel(Resources.getInstance().getBundle().getString("activation_tool_dialog_lbl_info"), SumImages.imgInfo, 2);
        JLabel jlbDash = new JLabel("-", 0);
        JLabel jlbEnterSerialNum = new JLabel(Resources.getInstance().getBundle().getString("activation_tool_dialog_lbl_enter_serial_number"));
        this.editSNLeft = new JLimitedTextField(4);
        this.editSNLeft.setFocusTraversalKeysEnabled(false);
        this.editSNLeft.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    if (e.isShiftDown()) {
                        ActivationToolDialog.this.btnCancel.requestFocusInWindow();
                    } else {
                        ActivationToolDialog.this.editSNRight.selectAll();
                        ActivationToolDialog.this.editSNRight.requestFocusInWindow();
                    }
                    ActivationToolDialog.this.editSNLeft.select(0, 0);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.editSNLeft.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                int insertedStrLen = e.getLength();
                int currentStrLen = e.getDocument().getLength();
                if (insertedStrLen == 4) {
                    ActivationToolDialog.this.editSNRight.setText(ActivationToolDialog.this.editSNLeft.getExtraText());
                    ActivationToolDialog.this.editSNLeft.clearExtraText();
                    ActivationToolDialog.this.editSNRight.requestFocusInWindow();
                }
                if (currentStrLen == 4 && e.getOffset() == 3) {
                    ActivationToolDialog.this.editSNRight.requestFocusInWindow();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.editSNRight = new JLimitedTextField(8);
        this.editSNRight.setFocusTraversalKeysEnabled(false);
        this.editSNRight.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    if (e.isShiftDown()) {
                        ActivationToolDialog.this.editSNLeft.selectAll();
                        ActivationToolDialog.this.editSNLeft.requestFocusInWindow();
                    } else {
                        ActivationToolDialog.this.btnActivate.requestFocusInWindow();
                    }
                    ActivationToolDialog.this.editSNRight.select(0, 0);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        JLabel jlbHowToFind = new JLabel(Resources.getInstance().getBundle().getString("activation_tool_dialog_link_how_to_find")){

            @Override
            public Font getFont() {
                return FontManager.getUnderlinedFont();
            }

            @Override
            public Color getForeground() {
                return Color.BLUE;
            }
        };
        jlbHowToFind.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Common.openBrowser(Resources.getInstance().getBundle().getString("activation_tool_dialog_find_my_serial_number_url_dest"));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ActivationToolDialog.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ActivationToolDialog.this.setCursor(new Cursor(0));
            }
        });
        GridBagLayout gbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 4;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 10, 15, 5);
        gbag.setConstraints(jlbInfo, gbc);
        gbc.gridwidth = 1;
        gbc.weightx = 0.1;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets = new Insets(5, SumImages.imgInfo.getIconWidth() + 10, 0, 5);
        gbag.setConstraints(jlbEnterSerialNum, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.4;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbag.setConstraints(this.editSNLeft, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.1;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbag.setConstraints(jlbDash, gbc);
        gbc.gridx = 3;
        gbc.weightx = 0.8;
        gbc.insets = new Insets(5, 5, 0, 20);
        gbag.setConstraints(this.editSNRight, gbc);
        gbc.gridwidth = 3;
        gbc.anchor = 12;
        gbc.fill = 12;
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbag.setConstraints(jlbHowToFind, gbc);
        GridBagLayout gbagBottomPanel = new GridBagLayout();
        GridBagConstraints gbcBottomPanel = new GridBagConstraints();
        gbcBottomPanel.weightx = 1.0;
        gbcBottomPanel.weighty = 1.0;
        gbcBottomPanel.anchor = 13;
        gbcBottomPanel.fill = 12;
        gbcBottomPanel.insets = new Insets(5, 0, 5, 5);
        gbagBottomPanel.setConstraints(this.btnActivate, gbcBottomPanel);
        gbcBottomPanel.weightx = 0.0;
        gbcBottomPanel.insets = new Insets(5, 5, 5, 5);
        gbagBottomPanel.setConstraints(this.btnCancel, gbcBottomPanel);
        JPanel panelBtnClose = new JPanel(gbagBottomPanel){

            @Override
            public Color getBackground() {
                return Color.LIGHT_GRAY;
            }
        };
        panelBtnClose.add(this.btnActivate);
        panelBtnClose.add(this.btnCancel);
        gbc.gridwidth = 4;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbag.setConstraints(panelBtnClose, gbc);
        this.panel.setLayout(gbag);
        this.panel.add(jlbInfo);
        this.panel.add(jlbEnterSerialNum);
        this.panel.add(this.editSNLeft);
        this.panel.add(jlbDash);
        this.panel.add(this.editSNRight);
        this.panel.add(jlbHowToFind);
        this.panel.add(panelBtnClose);
        this.panel.updateUI();
    }

    private void retryDialogActivation() {
        this.createDialogActivation();
        this.editSNLeft.setText(this.snLeft);
        this.editSNRight.setText(this.snRight);
    }

    private void createDialogError(String errTextShort, String errTextFull) {
        this.panel.removeAll();
        this.removeBtnListeners(this.btnCancel);
        this.removeBtnListeners(this.btnRetry);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        this.btnRetry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivationToolDialog.this.retryDialogActivation();
            }
        });
        JLabel jlbInfo = new JLabel(errTextShort, SumImages.imgWarn, 2);
        JLabel jlbInfoDescr = new JLabel(errTextFull);
        GridBagLayout gbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 10, 15, 5);
        gbag.setConstraints(jlbInfo, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridy;
        gbc.insets = new Insets(5, SumImages.imgInfo.getIconWidth() + 10, 0, 5);
        gbag.setConstraints(jlbInfoDescr, gbc);
        GridBagLayout gbagBottomPanel = new GridBagLayout();
        GridBagConstraints gbcBottomPanel = new GridBagConstraints();
        gbcBottomPanel.weightx = 1.0;
        gbcBottomPanel.weighty = 1.0;
        gbcBottomPanel.anchor = 13;
        gbcBottomPanel.fill = 12;
        gbcBottomPanel.insets = new Insets(5, 0, 5, 5);
        gbagBottomPanel.setConstraints(this.btnRetry, gbcBottomPanel);
        gbcBottomPanel.weightx = 0.0;
        gbcBottomPanel.insets = new Insets(5, 5, 5, 5);
        gbagBottomPanel.setConstraints(this.btnCancel, gbcBottomPanel);
        JPanel panelBtnClose = new JPanel(gbagBottomPanel){

            @Override
            public Color getBackground() {
                return Color.LIGHT_GRAY;
            }
        };
        panelBtnClose.add(this.btnRetry);
        panelBtnClose.add(this.btnCancel);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbag.setConstraints(panelBtnClose, gbc);
        this.panel.setBackground(Color.white);
        this.panel.setLayout(gbag);
        this.panel.add(jlbInfo);
        this.panel.add(jlbInfoDescr);
        this.panel.add(panelBtnClose);
        this.panel.updateUI();
    }

    private void createDialogOK() {
        this.panel.removeAll();
        this.removeBtnListeners(this.btnClose);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                PanelBottom.getInstance().btnCheckForUpdatesClick();
            }
        });
        JLabel jlbInfo = new JLabel(Resources.getInstance().getBundle().getString("activation_tool_dialog_lbl_congratulations_short_desc"), SumImages.imgInfo, 2);
        GridBagLayout gbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(20, 10, 15, 5);
        gbag.setConstraints(jlbInfo, gbc);
        GridBagLayout gbagBottomPanel = new GridBagLayout();
        GridBagConstraints gbcBottomPanel = new GridBagConstraints();
        gbcBottomPanel.weightx = 1.0;
        gbcBottomPanel.weighty = 1.0;
        gbcBottomPanel.anchor = 13;
        gbcBottomPanel.fill = 12;
        gbcBottomPanel.insets = new Insets(5, 5, 5, 5);
        gbagBottomPanel.setConstraints(this.btnClose, gbcBottomPanel);
        JPanel panelBtnClose = new JPanel(gbagBottomPanel){

            @Override
            public Color getBackground() {
                return Color.LIGHT_GRAY;
            }
        };
        panelBtnClose.add(this.btnClose);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbag.setConstraints(panelBtnClose, gbc);
        this.panel.setBackground(Color.white);
        this.panel.setLayout(gbag);
        this.panel.add(jlbInfo);
        this.panel.add(panelBtnClose);
        this.panel.updateUI();
    }

    private void createProgressBarDialog() {
        this.panel.removeAll();
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        this.removeBtnListeners(this.btnCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        JLabel jlbInfo = new JLabel(Resources.getInstance().getBundle().getString("activation_tool_dialog_lbl_pls_wait"), SumImages.imgInfo, 2);
        GridBagLayout gbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 10, 15, 5);
        gbag.setConstraints(jlbInfo, gbc);
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        ++gbc.gridy;
        gbc.insets = new Insets(10, SumImages.imgInfo.getIconWidth() + 10, 0, SumImages.imgInfo.getIconWidth() + 10);
        gbag.setConstraints(progressBar, gbc);
        GridBagLayout gbagBottomPanel = new GridBagLayout();
        GridBagConstraints gbcBottomPanel = new GridBagConstraints();
        gbcBottomPanel.weightx = 1.0;
        gbcBottomPanel.weighty = 1.0;
        gbcBottomPanel.anchor = 13;
        gbcBottomPanel.fill = 12;
        gbcBottomPanel.insets = new Insets(5, 5, 5, 5);
        gbagBottomPanel.setConstraints(this.btnCancel, gbcBottomPanel);
        JPanel panelBtnClose = new JPanel(gbagBottomPanel){

            @Override
            public Color getBackground() {
                return Color.LIGHT_GRAY;
            }
        };
        panelBtnClose.add(this.btnCancel);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbag.setConstraints(panelBtnClose, gbc);
        this.panel.setBackground(Color.white);
        this.panel.setLayout(gbag);
        this.panel.add(jlbInfo);
        this.panel.add(progressBar);
        this.panel.add(panelBtnClose);
        this.panel.updateUI();
    }

    public class JLimitedTextField
    extends JTextField {
        private int limit;
        private String extraText;

        public JLimitedTextField(int limit) {
            this.limit = limit;
            this.extraText = "";
        }

        @Override
        protected Document createDefaultModel() {
            return new LimitDocument();
        }

        public String getExtraText() {
            return this.extraText;
        }

        public void clearExtraText() {
            this.extraText = "";
        }

        class LimitDocument
        extends PlainDocument {
            LimitDocument() {
            }

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str == null) {
                    return;
                }
                boolean validSNStr = true;
                for (int i = 0; i < str.length(); ++i) {
                    if (Character.isLetterOrDigit(str.charAt(i)) || str.charAt(i) == '-') continue;
                    validSNStr = false;
                }
                if (validSNStr) {
                    int insertedStrLen = str.length();
                    int resLen = this.getLength() + insertedStrLen;
                    if (resLen <= JLimitedTextField.this.limit) {
                        super.insertString(offs, str, a);
                    } else if (this.getLength() < JLimitedTextField.this.limit) {
                        JLimitedTextField.this.extraText = str.substring(JLimitedTextField.this.limit - this.getLength() + 1, insertedStrLen);
                        super.insertString(offs, str.substring(0, JLimitedTextField.this.limit - this.getLength()), a);
                    }
                }
            }
        }
    }
}

