/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core.objects;

import com.intel.ism.core.Resources;
import com.intel.ism.core.Tools;
import com.intel.ism.core.data.DataManager;
import com.intel.ism.core.data.LicenseMessage;
import com.intel.ism.core.data.Product;
import com.intel.ism.core.objects.LicenseMessageData;
import com.intel.ism.gui.Common;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class LicenseMessages {
    public List<LicenseMessageData> getMessagesList() {
        ArrayList<LicenseMessageData> listLicenseMessages = new ArrayList<LicenseMessageData>();
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            for (LicenseMessage lm : p.getListLicenseMessages()) {
                if (lm.getIsRemoved()) continue;
                String endDate = Common.getDateFormat().format(lm.getEndDate().getTime());
                int dayLeft = Tools.dateDiff(GregorianCalendar.getInstance(), lm.getEndDate());
                Calendar maxDate = Resources.getInstance().getMAX_DATE();
                switch (lm.getMessageType()) {
                    case Evaluation: {
                        switch (lm.getMessageStatus()) {
                            case Expired: {
                                endDate = !lm.getEndDate().equals(maxDate) ? Resources.getInstance().getBundle().getString("activation_msg_eval_expired_at").replace("<0>", endDate) : Resources.getInstance().getBundle().getString("activation_msg_eval_expired");
                                break;
                            }
                            case Warning: {
                                endDate = !lm.getEndDate().equals(maxDate) ? Resources.getInstance().getBundle().getString("activation_msg_eval_expires_at").replace("<0>", Integer.toString(dayLeft)).replace("<1>", endDate) : Resources.getInstance().getBundle().getString("activation_msg_eval_expires");
                                break;
                            }
                            case OK: {
                                endDate = !lm.getEndDate().equals(maxDate) ? Resources.getInstance().getBundle().getString("activation_msg_eval_valid_till").replace("<0>", endDate) : Resources.getInstance().getBundle().getString("activation_msg_eval_valid");
                            }
                        }
                        break;
                    }
                    case Subscription: {
                        switch (lm.getMessageStatus()) {
                            case Expired: 
                            case ExpiredMoreThanAYearAgo: {
                                endDate = !lm.getEndDate().equals(maxDate) ? Resources.getInstance().getBundle().getString("activation_msg_subscription_expired_at").replace("<0>", endDate) : Resources.getInstance().getBundle().getString("activation_msg_subscription_expired");
                                break;
                            }
                            case Warning: {
                                endDate = !lm.getEndDate().equals(maxDate) ? Resources.getInstance().getBundle().getString("activation_msg_subscription_expires_at").replace("<0>", Integer.toString(dayLeft)).replace("<1>", endDate) : Resources.getInstance().getBundle().getString("activation_msg_subscription_expires");
                                break;
                            }
                            case OK: {
                                endDate = !lm.getEndDate().equals(maxDate) ? Resources.getInstance().getBundle().getString("activation_msg_subscription_valid_till").replace("<0>", endDate) : Resources.getInstance().getBundle().getString("activation_msg_subscription_valid");
                            }
                        }
                        break;
                    }
                    case Unknown: {
                        endDate = Resources.getInstance().getBundle().getString("activation_msg_subscription_unknown");
                    }
                }
                String sType = p.getSupportType();
                if (lm.getMessageType().equals((Object)LicenseMessage.EMessageType.Evaluation)) {
                    sType = Resources.getInstance().getBundle().getString("EVAL");
                }
                String sn = lm.getSerialNumber().equals(Product.UndefinedProperty) ? Resources.getInstance().getBundle().getString("NA") : lm.getSerialNumber();
                LicenseMessageData lmData = new LicenseMessageData();
                lmData.setGuid(p.getGuid());
                lmData.setMessageType(lm.getMessageType());
                lmData.setMessageStatus(lm.getMessageStatus());
                lmData.setTitle(lm.getTitle());
                lmData.setSerialNumber(sn);
                lmData.setSupportType(sType);
                lmData.setEndDate(endDate);
                lmData.setDescription(lm.getDescription());
                lmData.setAdditionalInfoLink(lm.getAdditionalInfoLink());
                lmData.setProductDbLocation(p.getProductDbLocation());
                lmData.setPackageName(lm.getPackageName());
                listLicenseMessages.add(lmData);
            }
        }
        return listLicenseMessages;
    }

    public boolean setRemove(String guid, LicenseMessage.EMessageType type) {
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            if (!p.getGuid().equals(guid)) continue;
            return p.moveLicenseMessageToHistory(type);
        }
        return false;
    }

    public void setAllLicenseMessagesAsShown() {
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            for (LicenseMessage lm : p.getListLicenseMessages()) {
                lm.setShowNotification(false);
            }
        }
    }

    public int getNewLicenseMessagesCount() {
        int count = 0;
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            for (LicenseMessage lm : p.getListLicenseMessages()) {
                if (lm.getIsRemoved() || !lm.getShowNotification() || lm.getMessageStatus() == LicenseMessage.EMessageStatus.OK) continue;
                ++count;
            }
        }
        return count;
    }

    public LicenseMessage getFirstNewLicenseMessage() {
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            for (LicenseMessage lm : p.getListLicenseMessages()) {
                if (lm.getIsRemoved() || !lm.getShowNotification() || lm.getMessageStatus() == LicenseMessage.EMessageStatus.OK) continue;
                return lm;
            }
        }
        return null;
    }
}

