/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core.data.providers;

import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.data.Product;
import isus.Profile;
import isus.ProfileCollection;
import isus.ProfileMgr;
import isus.USAgent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.logging.Level;

public class FNCLocalDataProvider {
    ProfileMgr fncProfileMng;
    USAgent agent = new USAgent();
    public static final String profileGroupPrivate = "Private";
    public static final String profileGroupPublic = "Public";
    public static final String profileItemProductName = "ProductName";
    public static final String profileItemMediaID = "MediaID";
    public static final String profileItemUpdateID = "UpdateID";
    public static final String profileItemProductID = "ProductID";
    public static final String profileItemFulfillmentID = "FulfillmentID";
    public static final String profileItemGUID = "ProductCode";
    public static final String profileItemVERSION = "Version";
    public static final String profileItemSN = "SN";
    public static final String profileItemOSName = "OSName";
    public static final String profileItemOSVersion = "OSVersion";
    public static final String profileItemArch = "Arch";
    public static final String profileItemLocale = "Locale";
    public static final String profileItemCPU = "CPU";
    public static final String profileItemMACAddr = "MACLast4";

    public FNCLocalDataProvider() {
        this.fncProfileMng = new ProfileMgr();
    }

    public boolean getListOfProducts(List<Product> productList) {
        SumLogger.logger.info("getListOfProducts(): getting list of products from a local FNC db");
        try {
            this.agent.setProductBaseDir(Settings.defaultSettings.getPrivateInstallDir() + "/" + Settings.defaultSettings.getFNCLocalDBName());
            this.scanFNCdbDirectory(productList, this.agent.getDatabaseDir());
            this.agent.setProductBaseDir(Settings.defaultSettings.getPublicInstallDir() + "/" + Settings.defaultSettings.getFNCLocalDBName());
            this.scanFNCdbDirectory(productList, this.agent.getDatabaseDir());
        }
        catch (Exception e) {
            SumLogger.logger.log(Level.WARNING, "getListOfProducts(): exception: {0}", e.getMessage());
            return false;
        }
        return true;
    }

    private void scanFNCdbDirectory(List<Product> productList, String fncLocalDbDir) {
        try {
            SumLogger.logger.log(Level.INFO, "scanFNCdbDirectory(): Scanning FNC Local DB dir => {0}", fncLocalDbDir);
            File dir = new File(fncLocalDbDir);
            if (dir.exists()) {
                String[] products;
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".properties");
                    }
                };
                for (String product : products = dir.list(filter)) {
                    String product_db_filename = product.split(".properties")[0];
                    if (!this.isProductAdded(productList, product_db_filename)) {
                        try {
                            Product prd = this.getProductDetails(product_db_filename);
                            prd.setProductDbLocation(fncLocalDbDir);
                            productList.add(prd);
                            SumLogger.logger.log(Level.INFO, "scanFNCdbDirectory(): product added:GUID={0}name={1}version={2}sn={3}media_id={4}update_id={5}product_id={6}fulfillment_id={7}", new Object[]{prd.getGuid(), prd.getName(), prd.getVersion(), prd.getSerialNumber(), prd.getMediaId(), prd.getUpdateId(), prd.getProductId(), prd.getFulfillmentId()});
                        }
                        catch (NoSuchFieldException e) {
                            SumLogger.logger.warning("scanFNCdbDirectory(): bad product, there's no one of the fields in Profile Collection");
                        }
                        continue;
                    }
                    SumLogger.logger.log(Level.WARNING, "scanFNCdbDirectory(): this product already exists in another db");
                }
            }
        }
        catch (Exception e) {
            SumLogger.logger.log(Level.WARNING, "scanFNCdbDirectory(): exception: {0}", e.getMessage());
        }
    }

    private boolean isProductAdded(List<Product> productList, String product_db_filename) {
        for (Product prd : productList) {
            if (!prd.getGuidDbFilename().equals(product_db_filename)) continue;
            return true;
        }
        return false;
    }

    private String convertDbFileNametoGuid(String badGuid) {
        return "{" + badGuid.substring(0, 8) + "-" + badGuid.substring(8, 12) + "-" + badGuid.substring(12, 16) + "-" + badGuid.substring(16, 20) + "-" + badGuid.substring(20) + "}";
    }

    private Product getProductDetails(String productDbFilename) throws NoSuchFieldException {
        String VERSION;
        String GUID;
        Product prd = new Product(productDbFilename);
        int iCorrect = 0;
        ProfileCollection pc = (ProfileCollection)this.fncProfileMng.getCollection(productDbFilename);
        if (pc.getCount() == 0) {
            throw new NoSuchFieldException("No such field in Product details");
        }
        for (int i = 0; i < pc.getCount(); ++i) {
            Profile prf = (Profile)pc.item(i);
            if (!prf.getGroupName().equals(profileGroupPublic)) continue;
            if (prf.getName().equals(profileItemProductName)) {
                prd.setName(prf.getValue());
                prd.setPackageName(prd.getName());
                ++iCorrect;
                continue;
            }
            if (prf.getName().equals(profileItemMediaID)) {
                prd.setMediaId(prf.getValue());
                ++iCorrect;
                continue;
            }
            if (prf.getName().equals(profileItemUpdateID)) {
                prd.setUpdateId(prf.getValue());
                ++iCorrect;
                continue;
            }
            if (prf.getName().equals(profileItemProductID)) {
                prd.setProductId(prf.getValue());
                ++iCorrect;
                continue;
            }
            if (!prf.getName().equals(profileItemFulfillmentID)) continue;
            prd.setFulfillmentId(prf.getValue());
            ++iCorrect;
        }
        String SN = this.agent.getValue(productDbFilename, profileItemSN);
        if (!SN.isEmpty()) {
            prd.setSerialNumber(SN.trim());
            ++iCorrect;
        }
        if (!(GUID = this.agent.getValue(productDbFilename, profileItemGUID)).isEmpty()) {
            prd.setGuid(this.convertDbFileNametoGuid(GUID));
            ++iCorrect;
        }
        if (!(VERSION = this.agent.getValue(productDbFilename, profileItemVERSION)).isEmpty()) {
            prd.setVersion(VERSION);
            ++iCorrect;
        }
        if (prd.getUpdateId().equals(Product.UndefinedProperty)) {
            prd.setIsEmptyUpdateId(true);
        }
        this.addValueToProfile(productDbFilename, profileGroupPublic, profileItemOSName, this.agent.getValue(productDbFilename, profileItemOSName));
        this.addValueToProfile(productDbFilename, profileGroupPublic, profileItemOSVersion, this.agent.getValue(productDbFilename, profileItemOSVersion));
        this.addValueToProfile(productDbFilename, profileGroupPublic, profileItemArch, this.agent.getValue(productDbFilename, profileItemArch));
        this.addValueToProfile(productDbFilename, profileGroupPublic, profileItemLocale, this.agent.getValue(productDbFilename, profileItemLocale));
        this.addValueToProfile(productDbFilename, profileGroupPublic, profileItemCPU, this.agent.getValue(productDbFilename, profileItemCPU));
        this.addValueToProfile(productDbFilename, profileGroupPublic, profileItemMACAddr, this.agent.getValue(productDbFilename, profileItemMACAddr));
        if (Settings.defaultSettings.getAllowCollectingSystemInfo() != 1) {
            this.fncProfileMng.deleteGroup(productDbFilename, profileGroupPrivate);
        }
        return prd;
    }

    private void addValueToProfile(String profileFileName, String profileGroup, String vName, String vValue) {
        if (!vValue.isEmpty()) {
            this.fncProfileMng.setValue(profileFileName, profileGroup, vName, vValue);
        } else {
            this.fncProfileMng.setValue(profileFileName, profileGroup, vName, Product.UndefinedProperty);
        }
    }
}

