/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core.data.providers;

import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.data.ErrorNum;
import com.intel.ism.core.data.MarketingMessage;
import com.intel.ism.core.data.Message;
import com.intel.ism.core.data.Product;
import com.intel.ism.core.data.Update;
import com.intel.ism.core.data.providers.FNCBundleInfo;
import com.intel.ism.gui.Common;
import isus.INotification;
import isus.Notification;
import isus.NotificationProperty;
import isus.USAgent;
import isus.UpdateServiceException;
import isus.shared.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class FNCDataProvider {
    USAgent agent = new USAgent();
    List<MarketingMessage> marketingMessages;
    List<Update> updates;

    /*
     * Unable to fully structure code
     */
    public ErrorNum.EGetDataErrors retrieveMessages(Product product, String guid, String dblocation, String packageName, boolean shouldBeDownloadable, boolean isBundle, String updateId) {
        this.marketingMessages = new ArrayList<MarketingMessage>();
        this.updates = new ArrayList<Update>();
        SumLogger.logger.log(Level.INFO, "retrieveMessages(): scanning for marketing messages/updates for the product = {0}", guid);
        server = Settings.defaultSettings.getFNCServerURL();
        try {
            this.agent.setProductBaseDir(dblocation);
            this.agent.setNotificationServerURL(guid, server);
        }
        catch (Exception ex) {
            SumLogger.logger.log(Level.WARNING, "retrieveMessages(): cannot set Notification Server URL for the product {0} (location = {1})", new Object[]{guid, dblocation});
        }
        if (this.agent.isConnectedToNotificationServer(guid)) {
            try {
                notifications = this.agent.getNotificationCollection(guid);
                for (i = 0; i < notifications.getCount(); ++i) {
                    notification = notifications.item(i);
                    if (notification.isUpdate()) {
                        SumLogger.logger.log(Level.INFO, "retrieveMessages(): update is found");
                        SumLogger.logger.log(Level.INFO, "retrieveMessages(): checking its update_id...");
                        bundleInfo = new FNCBundleInfo();
                        bundleInfo.parseXMLBundleInfo(notification.getProperty(NotificationProperty.NP_INSTALL_INSTRUCTIONS));
                        if (!isBundle && !updateId.equals(bundleInfo.getUpdateId())) {
                            update = new Update();
                            this.FillMessage(notification, update);
                            update.setProductGuid(guid);
                            update.setDownloadLink(notification.getProperty(NotificationProperty.NP_DOWNLOAD_URL));
                            update.setDownloadSizeStr(notification.getProperty(NotificationProperty.NP_DOWNLOAD_SIZE));
                            update.setFNCNotification((Notification)notification);
                            update.setPackageName(packageName);
                            update.setShowNotification(true);
                            update.setAllowToDownload(shouldBeDownloadable);
                            update.setFNCBundleInfo(bundleInfo);
                            SumLogger.logger.log(Level.INFO, "retrieveMessages(): update is passed checks and can be shown (title = {0}; update_id = {1})", new Object[]{notification.getProperty(NotificationProperty.NP_TITLE), updateId});
                            this.updates.add(update);
                            continue;
                        }
                        SumLogger.logger.log(Level.INFO, "FNCDataProvider: retrieveMessages(): update is skipped (title = {0}; update_id = {1})", new Object[]{notification.getProperty(NotificationProperty.NP_TITLE), updateId});
                        continue;
                    }
                    if (!notification.isMessage()) continue;
                    SumLogger.logger.log(Level.INFO, "retrieveMessages(): marketing message is found for the product = {0}", guid);
                    message = new MarketingMessage();
                    this.FillMessage(notification, message);
                    message.setPackageName(packageName);
                    message.setShowNotification(false);
                    this.marketingMessages.add(message);
                }
            }
            catch (UpdateServiceException ex) {
                SumLogger.logger.log(Level.WARNING, "FNCDataProvider: exception for product {0}: {1}", new Object[]{guid, ex.toString()});
                if (!ex.toString().matches(".*13001.*") && !ex.toString().matches(".*13003.*")) ** GOTO lbl66
                product.setIsBadProduct(true);
            }
        } else {
            if (!Common.isMac()) {
                try {
                    pfFile = dblocation + System.getProperty("file.separator") + Util.convert2UID(guid) + ".pf";
                    pFile = dblocation + System.getProperty("file.separator") + Util.convert2UID(guid) + ".properties";
                    Runtime.getRuntime().exec("/bin/chmod 644 " + pfFile);
                    Runtime.getRuntime().exec("/bin/chmod 644 " + pFile);
                }
                catch (Exception ex) {
                    SumLogger.logger.log(Level.WARNING, "retrieveMessages(): exception when fix permission - ", ex.getMessage());
                }
            }
            SumLogger.logger.severe("Cannot connect to notification server");
            return ErrorNum.EGetDataErrors.NO_FNC_SERVER_CONNECTION;
        }
lbl66:
        // 3 sources

        if (!Common.isMac()) {
            try {
                pfFile = dblocation + System.getProperty("file.separator") + Util.convert2UID(guid) + ".pf";
                pFile = dblocation + System.getProperty("file.separator") + Util.convert2UID(guid) + ".properties";
                Runtime.getRuntime().exec("/bin/chmod 644 " + pfFile);
                Runtime.getRuntime().exec("/bin/chmod 644 " + pFile);
            }
            catch (Exception ex) {
                SumLogger.logger.log(Level.WARNING, "retrieveMessages(): exception when fix permission - ", ex.getMessage());
            }
        }
        return ErrorNum.EGetDataErrors.SUCCESS;
    }

    public List<Update> getUpdates() {
        return this.updates;
    }

    public List<MarketingMessage> getMarketingMessages() {
        return this.marketingMessages;
    }

    private void FillMessage(INotification notification, Message message) {
        message.setId(notification.getProperty(NotificationProperty.NP_ID));
        message.setProductName(notification.getProperty(NotificationProperty.NP_PRODUCT_NAME));
        message.setTitle(notification.getProperty(NotificationProperty.NP_TITLE));
        message.setDescription(notification.getProperty(NotificationProperty.NP_DESCRIPTION));
        message.setCategory(notification.getProperty(NotificationProperty.NP_CATEGORY));
        message.setPublishedDateStr(notification.getProperty(NotificationProperty.NP_START_DATE));
        message.setAdditionalInfoLink(notification.getProperty(NotificationProperty.NP_ADDITIONAL_INFO_URL));
    }
}

