/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core.data;

import com.intel.ism.core.Resources;
import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.Tools;
import com.intel.ism.core.data.Message;
import com.intel.ism.core.data.providers.FNCBundleInfo;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.controllers.ApplicationManager;
import isus.IUpdateEvents;
import isus.Notification;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.EventListener;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Update
extends Message
implements Serializable,
IUpdateEvents {
    private String productGuid = "";
    @XmlTransient
    private String downloadSizeStr = "";
    @XmlTransient
    private float downloadSize = 0.0f;
    @XmlTransient
    private String downloadLink = "";
    @XmlTransient
    private Notification fncNtf = null;
    @XmlTransient
    private boolean isDownloadingHasBeenStarted = false;
    private UpdateDownload updateDownloadStatus = UpdateDownload.None;
    private int downloadProgress = 0;
    private String downloadFile = "";
    @XmlTransient
    private boolean allowToDownload = true;
    @XmlTransient
    private FNCBundleInfo bundleInfo;
    @XmlTransient
    private EUpdateType updateType;
    @XmlTransient
    private CopyOnWriteArrayList<CustomDownloadEventListener> customDownloadEventListenerList = new CopyOnWriteArrayList();
    @XmlTransient
    private CopyOnWriteArrayList<CustomInstallEventListener> customInstallEventListenerList = new CopyOnWriteArrayList();

    public Update() {
        this.bundleInfo = new FNCBundleInfo();
        this.updateType = EUpdateType.UNKNOWN;
    }

    public String getProductGuid() {
        return this.productGuid;
    }

    public String getDownloadSizeStr() {
        return this.downloadSizeStr;
    }

    public float getDownloadSize() {
        return this.downloadSize;
    }

    public String getDownloadLink() {
        return this.downloadLink;
    }

    @XmlTransient
    public Notification getFNCNotification() {
        return this.fncNtf;
    }

    public String getDownloadFile() {
        return this.downloadFile;
    }

    public int getDownloadProgress() {
        return this.downloadProgress;
    }

    public UpdateDownload getUpdateDownloadStatus() {
        return this.updateDownloadStatus;
    }

    public String getUpdateDownloadStatusString() {
        if (this.updateDownloadStatus == UpdateDownload.Downloaded) {
            return Resources.getInstance().getBundle().getString("status_downloaded");
        }
        if (this.updateDownloadStatus == UpdateDownload.Downloading) {
            return Resources.getInstance().getBundle().getString("status_downloading");
        }
        if (this.updateDownloadStatus == UpdateDownload.DownloadingBegin) {
            return Resources.getInstance().getBundle().getString("status_download_begin");
        }
        if (this.updateDownloadStatus == UpdateDownload.Error) {
            return Resources.getInstance().getBundle().getString("status_error");
        }
        if (this.updateDownloadStatus == UpdateDownload.Installed) {
            return Resources.getInstance().getBundle().getString("status_installed");
        }
        if (this.updateDownloadStatus == UpdateDownload.Installing) {
            return Resources.getInstance().getBundle().getString("status_installing");
        }
        if (this.updateDownloadStatus == UpdateDownload.None) {
            return Resources.getInstance().getBundle().getString("status_ready_for_download");
        }
        if (this.updateDownloadStatus == UpdateDownload.Paused) {
            return Resources.getInstance().getBundle().getString("status_paused");
        }
        if (this.updateDownloadStatus == UpdateDownload.PausedByApp) {
            return Resources.getInstance().getBundle().getString("status_paused");
        }
        return "";
    }

    private String getDownloadFileFromServer() {
        String fileName = this.getDownloadLink();
        fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        fileName = Settings.defaultSettings.getDefaultDownloadLocation() + "/" + fileName;
        return fileName;
    }

    public boolean getDownloadingHasBeenStarted() {
        return this.isDownloadingHasBeenStarted;
    }

    public boolean getIsAllowToDownload() {
        return this.allowToDownload;
    }

    public FNCBundleInfo getFNCBundleInfo() {
        return this.bundleInfo;
    }

    public EUpdateType getUpdateType() {
        return this.updateType;
    }

    public boolean getIsBundle() {
        return !this.bundleInfo.getComponents().isEmpty();
    }

    public void setProductGuid(String product_guid) {
        this.productGuid = product_guid;
    }

    public void setDownloadSizeStr(String dSize) {
        this.downloadSize = Float.parseFloat(dSize);
        this.downloadSizeStr = Tools.convertKBytesToGMKstring(this.downloadSize);
    }

    public void setDownloadLink(String download_link) {
        this.downloadLink = download_link;
    }

    public void setFNCNotification(Notification fnc_ntf) {
        this.fncNtf = fnc_ntf;
        this.fncNtf.addUpdateListener(this);
    }

    public void setDownloadFile(String fileName) {
        this.downloadFile = fileName;
    }

    public void setDownloadProgress(int download_progress) {
        this.downloadProgress = download_progress;
    }

    public void setUpdateDownloadStatus(UpdateDownload update_download_status) {
        this.updateDownloadStatus = update_download_status;
    }

    public void setAllowToDownload(boolean allowToDownload) {
        this.allowToDownload = allowToDownload;
    }

    public void setFNCBundleInfo(FNCBundleInfo bundleInfo) {
        this.bundleInfo = bundleInfo;
    }

    public void setUpdateType(EUpdateType updateType) {
        this.updateType = updateType;
    }

    @Override
    public boolean OnInstallStart() {
        return true;
    }

    @Override
    public boolean OnInstallEnd(int rc) {
        return true;
    }

    @Override
    public boolean OnDownloadBegin() {
        SumLogger.logger.log(Level.INFO, "OnDownloadBegin() FNC event: guid = {0} ; id = {1}", new Object[]{this.getProductGuid(), this.getId()});
        this.setUpdateDownloadStatus(UpdateDownload.Downloading);
        if (this.customDownloadEventListenerList != null) {
            for (int i = 0; i < this.customDownloadEventListenerList.size(); ++i) {
                this.customDownloadEventListenerList.get(i).OnDownloadBegin(this.getProductGuid(), this.getId());
            }
        } else {
            SumLogger.logger.log(Level.SEVERE, "OnDownloadBegin(): internal error: customListener is not set, but is tried to be used!");
        }
        return true;
    }

    @Override
    public boolean OnDownloadProgress(int percent, int totalsize, int transferRate) {
        this.setDownloadProgress(percent);
        if (this.customDownloadEventListenerList != null) {
            for (int i = 0; i < this.customDownloadEventListenerList.size(); ++i) {
                this.customDownloadEventListenerList.get(i).OnDownloadProgress(this.getProductGuid(), this.getId(), percent, totalsize, Tools.convertTransferSpeedRate(transferRate));
            }
        } else {
            SumLogger.logger.log(Level.SEVERE, "OnDownloadProgress() FNC event: internal error: customListener is not set, but is tried to be used!");
        }
        return true;
    }

    @Override
    public boolean OnDownloadComplete() {
        SumLogger.logger.log(Level.INFO, "OnDownloadComplete() FNC event: guid = {0} ; id = {1}", new Object[]{this.getProductGuid(), this.getId()});
        this.setUpdateDownloadStatus(UpdateDownload.Downloaded);
        this.setDownloadProgress(100);
        if (this.customDownloadEventListenerList != null) {
            for (int i = 0; i < this.customDownloadEventListenerList.size(); ++i) {
                this.customDownloadEventListenerList.get(i).OnDownloadComplete(this.getProductGuid(), this.getId());
            }
        } else {
            SumLogger.logger.log(Level.SEVERE, "OnDownloadComplete() FNC event: internal error: customListener is not set, but is tried to be used!");
        }
        return true;
    }

    @Override
    public boolean OnDownloadError(String errorMessage) {
        SumLogger.logger.log(Level.INFO, "OnDownloadError() FNC event: guid = {0} ; id = {1}; message = {2}", new Object[]{this.getProductGuid(), this.getId(), errorMessage});
        if (errorMessage.equals("Download Cancelled")) {
            this.setUpdateDownloadStatus(UpdateDownload.None);
        } else {
            this.setUpdateDownloadStatus(UpdateDownload.Error);
        }
        if (this.customDownloadEventListenerList != null) {
            for (int i = 0; i < this.customDownloadEventListenerList.size(); ++i) {
                this.customDownloadEventListenerList.get(i).OnDownloadError(this.getProductGuid(), this.getId(), errorMessage);
            }
        } else {
            SumLogger.logger.log(Level.SEVERE, "OnDownloadError() FNC event: internal error: customListener is not set, but is tried to be used!");
        }
        return true;
    }

    public void addCustomDownloadEventListener(CustomDownloadEventListener l) {
        this.customDownloadEventListenerList.add(l);
    }

    public void removeCustomDownloadEventListener(CustomDownloadEventListener l) {
        this.customDownloadEventListenerList.remove(l);
    }

    public void removeAllCustomDownloadEventListeners() {
        if (this.customDownloadEventListenerList != null) {
            this.customDownloadEventListenerList.clear();
        }
    }

    public void addCustomInstallEventListener(CustomInstallEventListener l) {
        this.customInstallEventListenerList.add(l);
    }

    public void removeCustomInstallEventListener(CustomInstallEventListener l) {
        this.customInstallEventListenerList.remove(l);
    }

    public void removeAllCustomInstallEventListeners() {
        if (this.customInstallEventListenerList != null) {
            this.customInstallEventListenerList.clear();
        }
    }

    public boolean download(boolean needResume) {
        if (!this.allowToDownload) {
            SumLogger.logger.log(Level.WARNING, "download(): downloading of update is not allowed: id = {0}; title = {1}; guid = {2}", new Object[]{this.getId(), this.getTitle(), this.getProductGuid()});
            return true;
        }
        if (this.fncNtf != null) {
            SumLogger.logger.log(Level.INFO, "download(): beginning downloading update (resume = {0}): {1} ; Product={2} ; ID={3}", new Object[]{needResume, this.getTitle(), this.getProductGuid(), this.getId()});
            String fileName = this.getDownloadFileFromServer();
            if (needResume && !this.getDownloadFile().equals("")) {
                fileName = this.getDownloadFile();
            }
            this.setDownloadFile(fileName);
            SumLogger.logger.log(Level.INFO, "download(): download target: {0}", fileName);
            this.setDownloadProgress(0);
            if (this.fncNtf.download(fileName, true)) {
                this.setUpdateDownloadStatus(UpdateDownload.DownloadingBegin);
                this.isDownloadingHasBeenStarted = true;
                SumLogger.logger.log(Level.INFO, "download(): download has been successfully started...");
                if (needResume) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        SumLogger.logger.log(Level.SEVERE, "download(): cannot make thread to sleep 1000ms (in case of resume)");
                    }
                }
                return true;
            }
            this.setUpdateDownloadStatus(UpdateDownload.Error);
            SumLogger.logger.log(Level.WARNING, "download(): could not start download...");
        }
        return false;
    }

    public boolean cancelDownload() {
        if (this.fncNtf != null) {
            File file;
            SumLogger.logger.log(Level.INFO, "cancelDownload(): cancelling download: {0} ; Product={1} ; ID={2}", new Object[]{this.getTitle(), this.getProductGuid(), this.getId()});
            this.fncNtf.cancelDownload();
            String fileName = !this.getDownloadFile().equals("") ? this.getDownloadFile() : this.getDownloadFileFromServer();
            for (int i = 0; i < 5000 && (file = new File(fileName)).exists(); i += 500) {
                if (file.delete()) {
                    SumLogger.logger.log(Level.INFO, "cancelDownload(): removed file: {0}", fileName);
                } else {
                    SumLogger.logger.log(Level.WARNING, "cancelDownload(): problems removing file: {0}", fileName);
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ex) {
                    SumLogger.logger.log(Level.SEVERE, "cancelDownload(): cannot make thread to sleep 500ms");
                }
            }
            this.setDownloadProgress(0);
            this.setUpdateDownloadStatus(UpdateDownload.None);
        }
        return true;
    }

    public boolean pauseDownload(boolean resume) {
        if (this.fncNtf != null) {
            if (resume) {
                SumLogger.logger.log(Level.INFO, "pauseDownload(): resuming download...{0} ; Product={1} ; ID={2}", new Object[]{this.getTitle(), this.getProductGuid(), this.getId()});
                this.setUpdateDownloadStatus(UpdateDownload.Downloading);
            } else {
                SumLogger.logger.log(Level.INFO, "pauseDownload(): pausing download...{0} ; Product={1} ; ID={2}", new Object[]{this.getTitle(), this.getProductGuid(), this.getId()});
                this.setUpdateDownloadStatus(UpdateDownload.Paused);
            }
            this.fncNtf.pauseDownload();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                SumLogger.logger.log(Level.SEVERE, "pauseDownload(): cannot make thread to sleep 500ms");
            }
        }
        return true;
    }

    public boolean pauseDownloadByApp() {
        if (this.fncNtf != null) {
            SumLogger.logger.log(Level.INFO, "pauseDownload(): pausing download by app... {0} ; Product={1} ; ID={2}", new Object[]{this.getTitle(), this.getProductGuid(), this.getId()});
            this.fncNtf.pauseDownload();
            this.setUpdateDownloadStatus(UpdateDownload.PausedByApp);
        }
        return true;
    }

    public boolean launchInstall() {
        String tmp_dir_to_extract;
        SumLogger.logger.log(Level.INFO, "launchInstall(): launching installation of {0}", this.getDownloadFile());
        File file = new File(this.getDownloadFile());
        if (file.exists()) {
            float freeSpace;
            tmp_dir_to_extract = Settings.defaultSettings.getTempDirForUnpacking();
            File tmpdir = new File(tmp_dir_to_extract);
            if (!tmpdir.canWrite() || !tmpdir.canExecute()) {
                this.updateDownloadStatus = UpdateDownload.Downloaded;
                String msg = String.format(Resources.getInstance().getBundle().getString("install_progress_tmp_directory_is_not_writable"), tmp_dir_to_extract);
                SumLogger.logger.log(Level.WARNING, "launchInstall(): temp directory ({0}) is not writable", tmp_dir_to_extract);
                JOptionPane.showMessageDialog(Gui.getInstance(), msg, Resources.getInstance().getProductName(), 0);
                return false;
            }
            float neededSpace = this.getDownloadSize();
            if (neededSpace > (freeSpace = (float)tmpdir.getUsableSpace() / 1024.0f)) {
                String msg = String.format(Resources.getInstance().getBundle().getString("install_progress_no_enough_space_to_unpack"), tmp_dir_to_extract, Tools.convertKBytesToGMKstring(neededSpace - freeSpace));
                SumLogger.logger.log(Level.WARNING, "launchInstall(): temp directory ({0}) has lack of disk space (current = {1}, needed = {2})", new Object[]{tmp_dir_to_extract, Float.valueOf(freeSpace), Float.valueOf(neededSpace)});
                JOptionPane.showMessageDialog(Gui.getInstance(), msg, Resources.getInstance().getProductName(), 0);
                return false;
            }
        } else {
            String msg;
            this.updateDownloadStatus = UpdateDownload.None;
            this.downloadProgress = 0;
            for (int i = 0; i < this.customInstallEventListenerList.size(); ++i) {
                this.customInstallEventListenerList.get(i).OnInstallNotComplete("File not found");
            }
            try {
                msg = String.format(Resources.getInstance().getBundle().getString("install_progress_file_does_not_exist"), Resources.getInstance().getProductName(), this.getTitle(), file.getCanonicalPath());
            }
            catch (IOException ex) {
                msg = "File " + this.getDownloadFile() + " does not exist";
            }
            JOptionPane.showMessageDialog(Gui.getInstance(), msg, Resources.getInstance().getProductName(), 0);
            SumLogger.logger.log(Level.INFO, "launchInstall(): file {0} does not exist", this.getDownloadFile());
            return false;
        }
        final JDialog progressDialog = new JDialog((Frame)Gui.getInstance(), Resources.getInstance().getBundle().getString("install_progress_please_wait_text"));
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        progressDialog.setResizable(false);
        progressDialog.add(progressBar);
        progressDialog.setSize(300, 50);
        progressDialog.setLocationRelativeTo(Gui.getInstance());
        final SwingWorker swUnpackAndInstall = new SwingWorker(){

            protected String doInBackground() throws Exception {
                String path_to_install_script = "";
                String[] cmd_unpack = null;
                String[] cmd_get_install_script = null;
                Tools.EFileExtension ext = Tools.getFileExtension(Update.this.getDownloadFile());
                switch (ext) {
                    case GZIP: {
                        cmd_unpack = new String[]{"/bin/bash", "-c", "tar -xzf " + Update.this.getDownloadFile() + " -C " + tmp_dir_to_extract};
                        cmd_get_install_script = new String[]{"/bin/bash", "-c", "tar -tzf " + Update.this.getDownloadFile()};
                        break;
                    }
                    case ZIP: {
                        cmd_unpack = new String[]{"/bin/bash", "-c", "unzip -qq -o " + Update.this.getDownloadFile() + " -d " + tmp_dir_to_extract};
                        cmd_get_install_script = new String[]{"/bin/bash", "-c", "zipinfo -1 " + Update.this.getDownloadFile()};
                        break;
                    }
                    case DMG: {
                        cmd_unpack = new String[]{"/bin/bash", "-c", "hdiutil attach " + Update.this.getDownloadFile() + " -mountroot " + tmp_dir_to_extract};
                        int sepIndex = Update.this.getDownloadFile().lastIndexOf(47);
                        int dotIndex = Update.this.getDownloadFile().lastIndexOf(46);
                        String filename = Update.this.getDownloadFile().substring(sepIndex + 1, dotIndex);
                        path_to_install_script = filename + "/" + filename + ".mpkg";
                        break;
                    }
                    case UNKNOWN: {
                        Update.this.updateDownloadStatus = UpdateDownload.Downloaded;
                        String msg = Resources.getInstance().getBundle().getString("install_progress_unknown_archive_format");
                        SumLogger.logger.log(Level.WARNING, "launchInstall(): @workerUnpackAndInstall: unknown archive format");
                        JOptionPane.showMessageDialog(Gui.getInstance(), msg, Resources.getInstance().getProductName(), 0);
                        return "";
                    }
                }
                SumLogger.logger.log(Level.INFO, "launchInstall(): @workerUnpackAndInstall: archive format = {0}", ext.toString());
                try {
                    Update.this.updateDownloadStatus = UpdateDownload.Installing;
                    for (int i = 0; i < Update.this.customInstallEventListenerList.size(); ++i) {
                        ((CustomInstallEventListener)Update.this.customInstallEventListenerList.get(i)).OnInstallBegin();
                    }
                    progressDialog.setVisible(true);
                    if (cmd_get_install_script != null) {
                        Process procGetInstallScript = Runtime.getRuntime().exec(cmd_get_install_script);
                        path_to_install_script = this.processInputErrorStreams(procGetInstallScript);
                    }
                    SumLogger.logger.log(Level.INFO, "launchInstall(): @workerUnpackAndInstall: install script name = {0}", path_to_install_script);
                    if (path_to_install_script.isEmpty()) {
                        Update.this.updateDownloadStatus = UpdateDownload.Downloaded;
                        String msg = Resources.getInstance().getBundle().getString("install_progress_install_script_not_found");
                        SumLogger.logger.log(Level.INFO, "launchInstall(): @workerUnpackAndInstall: cannot find path to install script... skipping the installation");
                        JOptionPane.showMessageDialog(Gui.getInstance(), msg, Resources.getInstance().getProductName(), 0);
                        return "";
                    }
                    SumLogger.logger.log(Level.INFO, "launchInstall(): @workerUnpackAndInstall: unpacking archive ...");
                    Process procUnpack = Runtime.getRuntime().exec(cmd_unpack);
                    this.processInputErrorStreams(procUnpack);
                    try {
                        int exitCode = procUnpack.waitFor();
                        SumLogger.logger.log(Level.INFO, "launchInstall(): @workerUnpackAndInstall: unpacking done ... (exit code = {0})", exitCode);
                        if (exitCode != 0) {
                            Update.this.updateDownloadStatus = UpdateDownload.Downloaded;
                            String msg = Resources.getInstance().getBundle().getString("install_progress_error_during_unpacking");
                            SumLogger.logger.warning("launchInstall(): @workerUnpackAndInstall: error during extraction");
                            JOptionPane.showMessageDialog(Gui.getInstance(), msg, Resources.getInstance().getProductName(), 0);
                            return "";
                        }
                    }
                    catch (InterruptedException ex) {
                        Update.this.updateDownloadStatus = UpdateDownload.Downloaded;
                        SumLogger.logger.log(Level.WARNING, "launchInstall(): @workerUnpackAndInstall: exception during unpacking: {0}", ex.toString());
                        return "";
                    }
                }
                catch (IOException ex) {
                    Update.this.updateDownloadStatus = UpdateDownload.Downloaded;
                    SumLogger.logger.log(Level.WARNING, "launchInstall(): exception {0}", ex.toString());
                }
                return path_to_install_script;
            }

            @Override
            public void done() {
                try {
                    if (!this.isCancelled()) {
                        progressDialog.setVisible(false);
                        final String path_to_install_script = (String)this.get();
                        SwingWorker swInstall = new SwingWorker(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            protected Object doInBackground() throws Exception {
                                block8: {
                                    if (!path_to_install_script.isEmpty()) {
                                        String[] cmd_run_install = new String[]{ApplicationManager.getInstance().getPathToJar() + "/bin/installwrapper.sh", tmp_dir_to_extract + "/" + path_to_install_script};
                                        try {
                                            SumLogger.logger.log(Level.INFO, "launchInstall(): @workerInstall: launching installation ...");
                                            Process proc = Runtime.getRuntime().exec(cmd_run_install);
                                            try {
                                                int exitCode = proc.waitFor();
                                                SumLogger.logger.log(Level.INFO, "launchInstall(): @workerInstall: installation finished (exit code = {0})", exitCode);
                                                if (exitCode == 0) {
                                                    Update.this.updateDownloadStatus = UpdateDownload.Installed;
                                                    break block8;
                                                }
                                                Update.this.updateDownloadStatus = UpdateDownload.Downloaded;
                                            }
                                            catch (InterruptedException ex) {
                                                Update.this.updateDownloadStatus = UpdateDownload.Downloaded;
                                                SumLogger.logger.log(Level.WARNING, "launchInstall(): @workerInstall: exception during launching install: {0}", ex.toString());
                                            }
                                        }
                                        catch (IOException ex) {
                                            Update.this.updateDownloadStatus = UpdateDownload.Downloaded;
                                            SumLogger.logger.log(Level.WARNING, "launchInstall(): @workerInstall: {0}", ex.toString());
                                        }
                                    }
                                }
                                return true;
                            }

                            @Override
                            public void done() {
                                switch (Update.this.updateDownloadStatus) {
                                    case Installed: {
                                        for (int i = 0; i < Update.this.customInstallEventListenerList.size(); ++i) {
                                            ((CustomInstallEventListener)Update.this.customInstallEventListenerList.get(i)).OnInstallComplete();
                                        }
                                        break;
                                    }
                                    case Downloaded: {
                                        for (int i = 0; i < Update.this.customInstallEventListenerList.size(); ++i) {
                                            ((CustomInstallEventListener)Update.this.customInstallEventListenerList.get(i)).OnInstallNotComplete("");
                                        }
                                        break;
                                    }
                                }
                            }
                        };
                        swInstall.execute();
                    } else {
                        SumLogger.logger.log(Level.WARNING, "launchInstall(): @workerUnpackAndInstall: @done: progress bar dialog has been closed - cancelling the install");
                        Update.this.updateDownloadStatus = UpdateDownload.Downloaded;
                        for (int i = 0; i < Update.this.customInstallEventListenerList.size(); ++i) {
                            ((CustomInstallEventListener)Update.this.customInstallEventListenerList.get(i)).OnInstallNotComplete("");
                        }
                    }
                }
                catch (InterruptedException ex) {
                    SumLogger.logger.log(Level.WARNING, "launchInstall(): @done(): {0}", ex.toString());
                }
                catch (ExecutionException ex) {
                    SumLogger.logger.log(Level.WARNING, "launchInstall(): @done(): {0}", ex.toString());
                }
            }

            private String processInputErrorStreams(Process p) throws IOException {
                String line;
                String ret = "";
                BufferedReader brInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader brError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((line = brInput.readLine()) != null) {
                    if (!line.matches("^[^/]*/install.sh$")) continue;
                    ret = line;
                }
                brInput.close();
                while ((line = brError.readLine()) != null) {
                    SumLogger.logger.log(Level.WARNING, "launchInstall(): processInputErrorStreams: {0}", line);
                }
                brError.close();
                return ret;
            }
        };
        progressDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                swUnpackAndInstall.cancel(true);
            }
        });
        swUnpackAndInstall.execute();
        return true;
    }

    public static interface CustomInstallEventListener
    extends EventListener {
        public void OnInstallBegin();

        public void OnInstallComplete();

        public void OnInstallNotComplete(String var1);
    }

    public static interface CustomDownloadEventListener
    extends EventListener {
        public void OnDownloadBegin(String var1, String var2);

        public void OnDownloadProgress(String var1, String var2, int var3, int var4, String var5);

        public void OnDownloadComplete(String var1, String var2);

        public void OnDownloadError(String var1, String var2, String var3);
    }

    public static enum EUpdateType {
        UNKNOWN,
        BUNDLE,
        PART_OF_BUNDLE;

    }

    public static enum UpdateDownload {
        None,
        DownloadingBegin,
        Downloading,
        Paused,
        PausedByApp,
        Downloaded,
        Error,
        Installing,
        Installed;

    }
}

