/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core.data;

import com.intel.ism.core.Resources;
import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.Tools;
import com.intel.ism.core.data.ErrorNum;
import com.intel.ism.core.data.LicenseMessage;
import com.intel.ism.core.data.LocalStoreDataManager;
import com.intel.ism.core.data.MarketingMessage;
import com.intel.ism.core.data.Update;
import com.intel.ism.core.data.providers.FNCDataProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Product
implements Serializable {
    private String guid;
    @XmlTransient
    private String guid_db_filename;
    @XmlTransient
    private String productDbLocation;
    @XmlTransient
    private String version;
    @XmlTransient
    private String name;
    @XmlTransient
    private String serialNumber;
    @XmlTransient
    private String mediaId;
    @XmlTransient
    private String updateId;
    @XmlTransient
    private String productId;
    @XmlTransient
    private String fulfillmentId;
    @XmlTransient
    private int evalDaysLeft;
    @XmlTransient
    private String packageName;
    @XmlTransient
    private Calendar subscriptionEndDate;
    @XmlTransient
    private String supportType;
    @XmlTransient
    private boolean badSn;
    @XmlTransient
    private boolean emptyUpdateId;
    @XmlTransient
    private boolean badProduct;
    @XmlElement(name="update")
    private List<Update> listUpdates;
    @XmlElement(name="marketing_message")
    private List<MarketingMessage> listMarketingMessages;
    @XmlElement(name="activation_message")
    private List<LicenseMessage> listLicenseMessages;
    public static final String UndefinedProperty = Resources.getInstance().getBundle().getString("serial_number_undefined_property");

    public Product() {
    }

    public Product(String guid_db_filename) {
        this.guid_db_filename = guid_db_filename;
        this.guid = "";
        this.productDbLocation = "";
        this.version = "";
        this.name = "";
        this.serialNumber = UndefinedProperty;
        this.mediaId = "";
        this.updateId = "";
        this.productId = "";
        this.fulfillmentId = "";
        this.evalDaysLeft = -1;
        this.subscriptionEndDate = Resources.getInstance().getMAX_DATE();
        this.supportType = "";
        this.packageName = "";
        this.badSn = false;
        this.emptyUpdateId = false;
        this.badProduct = false;
        this.listUpdates = new ArrayList<Update>();
        this.listMarketingMessages = new ArrayList<MarketingMessage>();
        this.listLicenseMessages = new ArrayList<LicenseMessage>();
    }

    public int getEvalDaysLeft() {
        return this.evalDaysLeft;
    }

    public String getFulfillmentId() {
        return this.fulfillmentId;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getGuidDbFilename() {
        return this.guid_db_filename;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getName() {
        return this.name;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public Calendar getSubscriptionEndDate() {
        return this.subscriptionEndDate;
    }

    public String getSupportType() {
        return this.supportType;
    }

    public String getUpdateId() {
        return this.updateId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getProductDbLocation() {
        return this.productDbLocation;
    }

    public boolean getBadSn() {
        return this.badSn;
    }

    public boolean getIsEmptyUpdateId() {
        return this.emptyUpdateId;
    }

    public boolean getIsBadProduct() {
        return this.badProduct;
    }

    public boolean getIsISM() {
        return this.updateId.matches("^[l|m]_isum_.*");
    }

    public void setEvalDaysLeft(int eval_days_left) {
        this.evalDaysLeft = eval_days_left;
    }

    public void setFulfillmentId(String fulfillment_id) {
        this.fulfillmentId = fulfillment_id;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public void setMediaId(String media_id) {
        this.mediaId = media_id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProductId(String product_id) {
        this.productId = product_id;
    }

    public void setSerialNumber(String serial_number) {
        this.serialNumber = serial_number;
    }

    public void setSubscriptionEndDate(Calendar subscription_end_date) {
        this.subscriptionEndDate = subscription_end_date;
    }

    public void setSupportType(String support_type) {
        this.supportType = support_type;
    }

    public void setUpdateId(String update_id) {
        this.updateId = update_id;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setProductDbLocation(String productDbLocation) {
        this.productDbLocation = productDbLocation;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setIsBadSn(boolean badSn) {
        this.badSn = badSn;
    }

    public void setIsEmptyUpdateId(boolean emptyUpdateId) {
        this.emptyUpdateId = emptyUpdateId;
    }

    public void setIsBadProduct(boolean badProduct) {
        this.badProduct = badProduct;
    }

    public List<LicenseMessage> getListLicenseMessages() {
        return this.listLicenseMessages;
    }

    public List<MarketingMessage> getListMarketingMessages() {
        return this.listMarketingMessages;
    }

    public List<Update> getListUpdates() {
        return this.listUpdates;
    }

    public boolean isEntitle() {
        GregorianCalendar d = new GregorianCalendar();
        return d.before(this.subscriptionEndDate) && this.evalDaysLeft != 0;
    }

    public boolean isAllowToDownloadUpdates() {
        return this.isEntitle() && !this.badSn;
    }

    public boolean moveLicenseMessageToHistory(LicenseMessage.EMessageType type) {
        for (LicenseMessage lm : this.listLicenseMessages) {
            if (lm.getMessageType() != type) continue;
            LocalStoreDataManager.defaultLocalStoreDataManager.getHistory().addItem(lm.getId(), lm.getTitle(), lm.getDescription(), Resources.getInstance().getTodayDateStr(), Resources.getInstance().getHistoryStatusRemoved(), Resources.getInstance().getMessageTypeActivation(), "");
            LocalStoreDataManager.defaultLocalStoreDataManager.saveHistory();
            lm.setIsRemoved(true);
            LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
        }
        return false;
    }

    public boolean moveMarketingMessageToHistory(String id) {
        for (MarketingMessage mm : this.listMarketingMessages) {
            if (!mm.getId().equals(id)) continue;
            LocalStoreDataManager.defaultLocalStoreDataManager.getHistory().addItem(mm.getId(), mm.getTitle(), mm.getDescription(), Resources.getInstance().getTodayDateStr(), Resources.getInstance().getHistoryStatusRemoved(), Resources.getInstance().getMessageTypeMarketing(), "");
            SumLogger.logger.log(Level.INFO, "moveMarketingMessageToHistory(): moving marketing message id={0} to history", mm.getId());
            LocalStoreDataManager.defaultLocalStoreDataManager.saveHistory();
            mm.setIsRemoved(true);
            LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
            return true;
        }
        return false;
    }

    public boolean setUpdateDownloadedInHistory(String id) {
        for (Update u : this.listUpdates) {
            if (!u.getId().equals(id)) continue;
            LocalStoreDataManager.defaultLocalStoreDataManager.getHistory().addItem(u.getId(), u.getTitle(), u.getDescription(), Resources.getInstance().getTodayDateStr(), Resources.getInstance().getHistoryStatusDownloaded(), Resources.getInstance().getMessageTypeUpdate(), "");
            LocalStoreDataManager.defaultLocalStoreDataManager.saveHistory();
            LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
            return true;
        }
        return false;
    }

    public ErrorNum.EGetDataErrors getMessagesFromFNCServer() {
        ErrorNum.EGetDataErrors ret;
        FNCDataProvider provider = new FNCDataProvider();
        if (!this.isAllowToDownloadUpdates()) {
            SumLogger.logger.log(Level.INFO, "getMessagesFromFNCServer(): downloading of updates is not available for this product: guid = {0}", this.getGuid());
        }
        if ((ret = provider.retrieveMessages(this, this.guid, this.productDbLocation, this.packageName, this.isAllowToDownloadUpdates(), this.getIsEmptyUpdateId(), this.getUpdateId())) == ErrorNum.EGetDataErrors.SUCCESS) {
            this.listUpdates = provider.getUpdates();
            this.listMarketingMessages = provider.getMarketingMessages();
        }
        return ret;
    }

    public boolean getLicenseMessage() {
        SumLogger.logger.log(Level.INFO, "getActivationMessages(): getting list of Activation Messages for the product {0}", this.getGuid());
        if (this.getIsEmptyUpdateId()) {
            SumLogger.logger.log(Level.INFO, "getActivationMessages(): product is bundle... skipping");
            return true;
        }
        if (this.getIsISM()) {
            SumLogger.logger.log(Level.INFO, "getActivationMessages(): product is ISM... skipping");
            return true;
        }
        LicenseMessage.EMessageType type = LicenseMessage.EMessageType.Unknown;
        LicenseMessage.EMessageStatus status = LicenseMessage.EMessageStatus.Unknown;
        if (this.badSn) {
            type = LicenseMessage.EMessageType.Unknown;
        } else if (this.getEvalDaysLeft() >= 0 || this.getSupportType().equals(Resources.getInstance().getBundle().getString("EVAL"))) {
            type = LicenseMessage.EMessageType.Evaluation;
            SumLogger.logger.log(Level.INFO, "getActivationMessages(): message type is EVAL");
        } else {
            type = LicenseMessage.EMessageType.Subscription;
            SumLogger.logger.log(Level.INFO, "getActivationMessages(): message type is Subscription");
        }
        status = LicenseMessage.EMessageStatus.OK;
        int dayLeft = Settings.defaultSettings.getNtfFreqExpirationSubscription().get(0) + 1;
        if (!this.getSubscriptionEndDate().equals(Resources.getInstance().getMAX_DATE())) {
            dayLeft = Tools.dateDiff(GregorianCalendar.getInstance(), this.getSubscriptionEndDate());
            SumLogger.logger.log(Level.INFO, "getActivationMessages(): days left till subscription/evaluation expiration is {0}", dayLeft);
        } else {
            SumLogger.logger.log(Level.INFO, "getActivationMessages(): valid subscription/evaluation");
        }
        switch (type) {
            case Subscription: {
                if (dayLeft <= 0) {
                    status = LicenseMessage.EMessageStatus.Expired;
                    if (Math.abs(dayLeft) >= 365) {
                        status = LicenseMessage.EMessageStatus.ExpiredMoreThanAYearAgo;
                    }
                    SumLogger.logger.log(Level.INFO, "getActivationMessages(): product subscription is Expired");
                    break;
                }
                if (dayLeft >= Settings.defaultSettings.getNtfFreqExpirationSubscription().get(0)) break;
                SumLogger.logger.log(Level.INFO, "getActivationMessages(): product subscription is Going to Expire");
                status = LicenseMessage.EMessageStatus.Warning;
                break;
            }
            case Evaluation: {
                status = LicenseMessage.EMessageStatus.Warning;
                if (!this.getSerialNumber().equals(UndefinedProperty)) {
                    SumLogger.logger.log(Level.INFO, "getActivationMessages(): eval SN");
                    this.setEvalDaysLeft(dayLeft);
                }
                if (this.getEvalDaysLeft() > 0) break;
                SumLogger.logger.log(Level.INFO, "getActivationMessages(): product evaluation is expired");
                status = LicenseMessage.EMessageStatus.Expired;
                break;
            }
            case Unknown: {
                status = LicenseMessage.EMessageStatus.Unknown;
            }
            default: {
                SumLogger.logger.log(Level.WARNING, "getActivationMessages(): wrong activation message type: {0}", type.toString());
            }
        }
        LicenseMessage lm = new LicenseMessage();
        this.fillLicenseMessage(lm, type, status);
        this.listLicenseMessages.add(lm);
        SumLogger.logger.log(Level.INFO, "getActivationMessages(): number of Activation messages: {0}", this.listLicenseMessages.size());
        return true;
    }

    private void fillLicenseMessage(LicenseMessage lm, LicenseMessage.EMessageType type, LicenseMessage.EMessageStatus status) {
        lm.setTitle(this.getName());
        lm.setMessageType(type);
        lm.setMessageStatus(status);
        lm.setSerialNumber(this.getSerialNumber());
        lm.setProductName(this.getName());
        lm.setPackageName(this.getPackageName());
        lm.setShowNotification(false);
        block0 : switch (type) {
            case Subscription: {
                lm.setEndDate(this.getSubscriptionEndDate());
                lm.setAdditionalInfoLink(Settings.defaultSettings.getActivationMessageSubscriptionAdditionalInfoURL());
                switch (status) {
                    case OK: {
                        lm.setDescription(Resources.getInstance().getBundle().getString("subscription_ok_desc"));
                        SumLogger.logger.log(Level.INFO, "fillActivationMessage(): Subscription - OK status");
                        break block0;
                    }
                    case Warning: {
                        int dayLeft = Tools.dateDiff(GregorianCalendar.getInstance(), lm.getEndDate());
                        lm.setDescription(Resources.getInstance().getBundle().getString("subscription_expired_warning_desc"));
                        lm.setShowNotification(Settings.defaultSettings.getNtfFreqExpirationSubscription().contains(dayLeft));
                        SumLogger.logger.log(Level.INFO, "fillActivationMessage(): Subscription - Warning status ({0} days left)", dayLeft);
                        break block0;
                    }
                    case Expired: {
                        lm.setDescription(Resources.getInstance().getBundle().getString("subscription_expired_desc"));
                        lm.setShowNotification(true);
                        SumLogger.logger.log(Level.INFO, "fillActivationMessage(): Subscription - Expired status");
                        break block0;
                    }
                    case ExpiredMoreThanAYearAgo: {
                        lm.setDescription(Resources.getInstance().getBundle().getString("subscription_expired_more_than_a_year_ago_desc"));
                        lm.setShowNotification(true);
                        SumLogger.logger.log(Level.INFO, "fillActivationMessage(): Subscription - Expired status (more than a year ago)");
                        break block0;
                    }
                }
                break;
            }
            case Evaluation: {
                lm.setAdditionalInfoLink(Settings.defaultSettings.getActivationMessageEvalAdditionalInfoURL());
                if (!this.getSubscriptionEndDate().equals(Resources.getInstance().getMAX_DATE())) {
                    lm.setEndDate(this.getSubscriptionEndDate());
                } else if (this.getEvalDaysLeft() > 0) {
                    GregorianCalendar endDate = new GregorianCalendar();
                    ((Calendar)endDate).add(5, this.getEvalDaysLeft());
                    lm.setEndDate(endDate);
                }
                SumLogger.logger.log(Level.INFO, "fillActivationMessage(): Eval - end date = {0}", lm.getEndDate());
                switch (status) {
                    case OK: {
                        lm.setDescription(Resources.getInstance().getBundle().getString("eval_ok_desc"));
                        SumLogger.logger.log(Level.INFO, "fillActivationMessage(): Eval - OK status");
                        break block0;
                    }
                    case Warning: {
                        lm.setDescription(Resources.getInstance().getBundle().getString("eval_expired_warning_desc"));
                        lm.setShowNotification(Settings.defaultSettings.getNtfFreqExpirationEval().contains(this.getEvalDaysLeft()));
                        SumLogger.logger.log(Level.INFO, "fillActivationMessage(): Eval - Warning status ({0} days left)", this.getEvalDaysLeft());
                        break block0;
                    }
                    case Expired: {
                        lm.setDescription(Resources.getInstance().getBundle().getString("eval_expired_desc"));
                        lm.setShowNotification(true);
                        SumLogger.logger.log(Level.INFO, "fillActivationMessage(): Eval - Expired status");
                        break block0;
                    }
                }
                break;
            }
            case Unknown: {
                lm.setDescription(Resources.getInstance().getBundle().getString("invalid_serial_number_desc"));
                break;
            }
            default: {
                SumLogger.logger.log(Level.WARNING, "fillActivationMessages(): wrong activation message type: {0}", type.toString());
            }
        }
        SumLogger.logger.log(Level.INFO, "fillActivationMessage(): add activation message: Title={0} ; Type={1}", new Object[]{lm.getTitle(), lm.getMessageType()});
    }

    public Update getUpdateByID(String id) {
        for (Update u : this.listUpdates) {
            if (!u.getId().equals(id)) continue;
            return u;
        }
        return null;
    }

    public LicenseMessage getActivationMessageByID(String id) {
        for (LicenseMessage am : this.listLicenseMessages) {
            if (!am.getId().equals(id)) continue;
            return am;
        }
        return null;
    }

    public MarketingMessage getMarketingMessageByID(String id) {
        for (MarketingMessage mm : this.listMarketingMessages) {
            if (!mm.getId().equals(id)) continue;
            return mm;
        }
        return null;
    }
}

