/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core;

import com.intel.ism.core.SumLogger;
import com.intel.ism.core.objects.UpdatesAndDownloads;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.controllers.ApplicationManager;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Level;

public class UnexpectedShutdownHandler
implements Runnable {
    @Override
    public void run() {
        SumLogger.logger.info("UnexpectedShutdownHandler(): Shutting down... trying to save status");
        new UpdatesAndDownloads().pauseAllDownloadsByApp();
        Registry reg = ApplicationManager.getInstance().getRegistry();
        if (reg != null) {
            try {
                reg.unbind("sumremote_" + System.getProperty("user.name"));
                UnicastRemoteObject.unexportObject(Gui.getInstance(), true);
            }
            catch (RemoteException ex) {
                SumLogger.logger.log(Level.INFO, "UnexpectedShutdownHandler(): exception when trying unbind stub from registry: {0}", ex.getMessage());
            }
            catch (NotBoundException ex) {
                SumLogger.logger.log(Level.INFO, "UnexpectedShutdownHandler(): exception when trying unbind stub from registry: {0}", ex.getMessage());
            }
        }
        ApplicationManager.getInstance().closeLock();
        ApplicationManager.getInstance().deleteLockFile();
        SumLogger.logger.info("UnexpectedShutdownHandler(): Shutting down... status saved");
    }
}

