/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core;

import com.intel.ism.core.Resources;
import java.io.File;
import java.util.Calendar;

public class Tools {
    public static String convertKBytesToGMKstring(float b) {
        String s = "";
        if (b < 1024.0f) {
            s = String.format(Resources.getInstance().getBundle().getString("size_kb"), Float.valueOf(b));
        } else if ((b = (float)((double)b / 1024.0)) < 1024.0f) {
            s = String.format(Resources.getInstance().getBundle().getString("size_mb"), Float.valueOf(b));
        } else if ((b = (float)((double)b / 1024.0)) < 1024.0f) {
            s = String.format(Resources.getInstance().getBundle().getString("size_gb"), Float.valueOf(b));
        } else {
            b = (float)((double)b / 1024.0);
            s = String.format(Resources.getInstance().getBundle().getString("size_tb"), Float.valueOf(b));
        }
        return s;
    }

    public static String convertTransferSpeedRate(float r) {
        String s = "";
        if (r < 1024.0f) {
            s = String.format(Resources.getInstance().getBundle().getString("speed_b"), Float.valueOf(r));
        } else if ((r = (float)((double)r / 1024.0)) < 1024.0f) {
            s = String.format(Resources.getInstance().getBundle().getString("speed_kb"), Float.valueOf(r));
        } else if ((r = (float)((double)r / 1024.0)) < 1024.0f) {
            s = String.format(Resources.getInstance().getBundle().getString("speed_mb"), Float.valueOf(r));
        } else if ((r = (float)((double)r / 1024.0)) < 1024.0f) {
            s = String.format(Resources.getInstance().getBundle().getString("speed_gb"), Float.valueOf(r));
        }
        return s;
    }

    public static int dateDiff(Calendar startDate, Calendar endDate) {
        long d1 = startDate.getTimeInMillis();
        long d2 = endDate.getTimeInMillis();
        return (int)Math.ceil((double)(d2 - d1) / 8.64E7);
    }

    public static EArch getArch() {
        String arch = System.getProperty("os.arch");
        if (arch.contains("amd64") || arch.contains("x86_64")) {
            return EArch.INTEL64;
        }
        return EArch.IA32;
    }

    public static EFileExtension getFileExtension(String filepath) {
        String filename = new File(filepath).getName().toLowerCase();
        EFileExtension ext = EFileExtension.UNKNOWN;
        if (filename.matches("^.*.tar.gz$") || filename.matches("^.*.tgz$")) {
            ext = EFileExtension.GZIP;
        } else if (filename.matches("^.*.zip$")) {
            ext = EFileExtension.ZIP;
        } else if (filename.matches("^.*.dmg$")) {
            ext = EFileExtension.DMG;
        }
        return ext;
    }

    public static enum EFileExtension {
        ZIP,
        GZIP,
        DMG,
        UNKNOWN;

    }

    public static enum EArch {
        IA32,
        INTEL64,
        UNKNOWN;

    }
}

