/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core;

import com.intel.ism.core.Resources;
import com.intel.ism.core.SumLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public class Settings {
    public static final Settings defaultSettings = new Settings();
    private Properties userProperties;
    private Properties appProperties;
    private String fncLocalDBName;
    private String fncServerURL;
    private String ircWebServiceURL;
    private String activationMessageEvalAdditionalInfoURL;
    private String activationMessageSubscriptionAdditionalInfoURL;
    private int maxHistoryRecordsNumber;
    private String defaultInstallLocation;
    private String defaultDownloadLocation;
    private String renewURL;
    private String lastCheckForUpdateDate;
    private int checkingForUpdateAutoMode;
    private int checkingForUpdateMode;
    private int allowCollectingSystemInfo;
    private int disableUpdatePopupNotifications;
    private int disableLicensePopupNotifications;
    private int remotePort;
    private String ntfFreqExpirationSubscription;
    private List<Integer> arr_ntfFreqExpirationSubscription;
    private String ntfFreqExpirationEval;
    private List<Integer> arr_ntfFreqExpirationEval;
    private String lastRMALaunchDate;
    private String tempDirForUnpacking;
    private String installDirPostfix = "ism";
    private String publicInstallDir = "/opt/intel/" + this.installDirPostfix;
    private String privateInstallDir;
    private String propItemFNCLocalDBName = "FNCLocalDBName";
    private String propItemFNCServerURL = "FNCServerURL";
    private String propItemIRCWebServiceURL = "IRCWebServiceURL";
    private String propItemRenewURL = "RenewURL";
    private String propItemActivationMessageEvalAdditionalInfoURL = "ActivationMessageEvalAdditionalInfoURL";
    private String propItemActivationMessageSubscriptionAdditionalInfoURL = "ActivationMessageSubscriptionAdditionalInfoURL";
    private String propItemAllowCollectingSystemInfo = "AllowCollectingSystemInfo";
    private String propItemRemotePort = "RemotePort";
    private String propItemMaxHistoryRecordsNumber = "MaxHistoryRecordsNumber";
    private String propItemDefaultDownloadLocation = "DefaultDownloadLocation";
    private String propItemLastCheckForUpdateDate = "LastCheckForUpdateDate";
    private String propItemCheckingForUpdateAutoMode = "CheckingForUpdateAutoMode";
    private String propItemCheckingForUpdateMode = "CheckingForUpdateMode";
    private String propItemDisableUpdatePopupNotifications = "DisableUpdatePopupNotifications";
    private String propItemDisableLicensePopupNotifications = "DisableLicensePopupNotifications";
    private String propItemNtfFreqExpirationSubscription = "SubscriptionExpirationFrequency";
    private String propItemNtfFreqExpirationEval = "EvalExpirationFrequency";
    private String propItemLastRMALaunchDate = "LastRMALaunchDate";
    private String propItemTempDirForUnpacking = "TempDirForUnpacking";
    private String localUserSettingsFile;
    private String localAppSettingsFile;

    public Settings() {
        this.defaultInstallLocation = this.privateInstallDir = System.getProperty("user.home") + "/intel/" + this.installDirPostfix;
        SumLogger.logger.log(Level.INFO, "Settings(): defaultInstallLocation = {0}", this.defaultInstallLocation);
        File dir = new File(this.defaultInstallLocation);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                System.err.println("ERROR: cannot create directory for settings file " + dir.getAbsolutePath());
            }
        } else if (!dir.canWrite()) {
            String msg = String.format(Resources.getInstance().getBundle().getString("message_ism_directory_is_not_writable"), dir.getAbsolutePath());
            System.err.println(msg);
        }
        this.localUserSettingsFile = this.defaultInstallLocation + "/Settings.properties";
        this.localAppSettingsFile = this.defaultInstallLocation + "/Application.properties";
        this.arr_ntfFreqExpirationSubscription = new ArrayList<Integer>();
        this.arr_ntfFreqExpirationEval = new ArrayList<Integer>();
        this.appProperties = new Properties();
        this.loadPropertiesFromFile(this.localAppSettingsFile, this.appProperties, false);
        if (!this.setAppProperties()) {
            SumLogger.logger.warning("Settings(): the existing app property file is absent or corrupted... loading the default properties");
            this.loadPropertiesFromFile(this.localAppSettingsFile, this.appProperties, true);
            if (!this.setAppProperties()) {
                SumLogger.logger.warning("Settings(): cannot load the default app properties from file... loading them directly from jar-stream");
                this.appProperties.clear();
                try {
                    this.appProperties.load(this.getClass().getResourceAsStream("/com/intel/ism/core/properties/Application.properties"));
                }
                catch (IOException ex) {
                    SumLogger.logger.log(Level.WARNING, "Settings(): Cannot load file: {0}", ex.toString());
                }
                if (!this.setAppProperties()) {
                    SumLogger.logger.warning("Settings(): fatal error - cannot load the default app properties...");
                    System.err.println("ERROR: cannot load the default application settings");
                    System.exit(1);
                }
            }
        }
        this.userProperties = new Properties();
        this.loadPropertiesFromFile(this.localUserSettingsFile, this.userProperties, false);
        if (!this.setUserProperties()) {
            SumLogger.logger.warning("Settings(): the existing user property file is absent or corrupted... loading the default properties");
            this.loadPropertiesFromFile(this.localUserSettingsFile, this.userProperties, true);
            if (!this.setUserProperties()) {
                SumLogger.logger.warning("Settings(): cannot load the default user properties from file... loading them directly from jar-stream");
                this.userProperties.clear();
                try {
                    this.userProperties.load(this.getClass().getResourceAsStream("/com/intel/ism/core/properties/Settings.properties"));
                }
                catch (IOException ex) {
                    SumLogger.logger.log(Level.WARNING, "Settings(): Cannot load file: {0}", ex.toString());
                }
                if (!this.setUserProperties()) {
                    SumLogger.logger.warning("Settings(): fatal error - cannot load the default user properties...");
                    System.err.println("ERROR: cannot load the default user settings");
                    System.exit(1);
                }
            }
        }
    }

    private void loadPropertiesFromFile(String fullFileName, Properties propBundle, boolean useDefaultSettings) {
        this.initLocalSettingsFile(fullFileName, useDefaultSettings);
        propBundle.clear();
        try {
            propBundle.load(new FileInputStream(fullFileName));
        }
        catch (IOException ex) {
            SumLogger.logger.log(Level.WARNING, "loadPropertiesFromFile(): Cannot load properties from file: {0}", ex.toString());
        }
    }

    private void initLocalSettingsFile(String fullFileName, boolean useDefaultSettings) {
        File fileSettings = new File(fullFileName);
        if (!fileSettings.exists() || useDefaultSettings) {
            InputStream jarUserSettings = this.getClass().getResourceAsStream("/com/intel/ism/core/properties/" + fileSettings.getName());
            this.extractResourceFromJar(jarUserSettings, fileSettings);
        }
    }

    private void extractResourceFromJar(InputStream fromStream, File toFile) {
        BufferedReader br = new BufferedReader(new InputStreamReader(fromStream));
        try {
            String line;
            BufferedWriter out = new BufferedWriter(new FileWriter(toFile.getCanonicalPath()));
            while ((line = br.readLine()) != null) {
                out.write(line + "\n");
            }
            out.close();
        }
        catch (IOException ex) {
            SumLogger.logger.log(Level.WARNING, "extractFileFromJar(): Error during extraction of settings file from jar-archive: {0}", ex.getMessage());
        }
    }

    private void setProperty(String property, String value, String propertiesFile) {
        try {
            FileOutputStream fos = new FileOutputStream(propertiesFile);
            this.userProperties.setProperty(property, value);
            this.userProperties.store(fos, null);
        }
        catch (IOException ex) {
            SumLogger.logger.log(Level.WARNING, "_setProperty({0}, {1}): error during writing into Settings.properties", new Object[]{property, value});
        }
    }

    public String getActivationMessageEvalAdditionalInfoURL() {
        return this.activationMessageEvalAdditionalInfoURL;
    }

    public String getActivationMessageSubscriptionAdditionalInfoURL() {
        return this.activationMessageSubscriptionAdditionalInfoURL;
    }

    public String getDefaultInstallLocation() {
        return this.defaultInstallLocation;
    }

    public String getDefaultDownloadLocation() {
        return this.defaultDownloadLocation.replace("{home}", System.getProperty("user.home"));
    }

    public String getFNCLocalDBName() {
        return this.fncLocalDBName;
    }

    public String getFNCServerURL() {
        return this.fncServerURL;
    }

    public String getIRCWebServiceURL() {
        return this.ircWebServiceURL;
    }

    public int getMaxHistoryRecordsNumber() {
        return this.maxHistoryRecordsNumber;
    }

    public int getCheckingForUpdateAutoModeInt() {
        return this.checkingForUpdateAutoMode;
    }

    public ECFUAutoMode getCheckingForUpdateAutoMode() {
        ECFUAutoMode mode = ECFUAutoMode.EVERYDAY;
        switch (this.checkingForUpdateAutoMode) {
            case 0: {
                mode = ECFUAutoMode.EVERYDAY;
                break;
            }
            case 1: {
                mode = ECFUAutoMode.EVERYWEEK;
                break;
            }
            case 2: {
                mode = ECFUAutoMode.EVERYMONTH;
            }
        }
        return mode;
    }

    public int getCheckingForUpdateModeInt() {
        return this.checkingForUpdateMode;
    }

    public ECFUMode getCheckingForUpdateMode() {
        ECFUMode mode = ECFUMode.AUTO;
        switch (this.checkingForUpdateMode) {
            case 0: {
                mode = ECFUMode.MANUAL;
                break;
            }
            case 1: {
                mode = ECFUMode.AUTO;
                break;
            }
            case 2: {
                mode = ECFUMode.CONTEXT;
            }
        }
        return mode;
    }

    public String getLastCheckForUpdateDate() {
        if (this.lastCheckForUpdateDate.isEmpty()) {
            return Resources.getInstance().getBundle().getString("panel_bottom_last_update_date_never");
        }
        return this.lastCheckForUpdateDate;
    }

    public String getLastRMALaunchDate() {
        if (this.lastRMALaunchDate.isEmpty()) {
            return Resources.getInstance().getBundle().getString("panel_bottom_last_update_date_never");
        }
        return this.lastRMALaunchDate;
    }

    public String getTempDirForUnpacking() {
        return this.tempDirForUnpacking;
    }

    public String getRenewURL() {
        return this.renewURL;
    }

    public int getAllowCollectingSystemInfo() {
        return this.allowCollectingSystemInfo;
    }

    public int getDisableUpdatePopupNotifications() {
        return this.disableUpdatePopupNotifications;
    }

    public int getDisableLicensePopupNotifications() {
        return this.disableLicensePopupNotifications;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getPublicInstallDir() {
        return this.publicInstallDir;
    }

    public String getPrivateInstallDir() {
        return this.privateInstallDir;
    }

    public List<Integer> getNtfFreqExpirationEval() {
        this.arr_ntfFreqExpirationEval.clear();
        String[] strList = this.ntfFreqExpirationEval.split(";");
        try {
            for (String str : strList) {
                this.arr_ntfFreqExpirationEval.add(Integer.parseInt(str));
            }
        }
        catch (NumberFormatException ex) {
            SumLogger.logger.log(Level.WARNING, "Settings: getNtfFreqExpirationEval(): exception when parsing property, using the default value: {0}", ex.toString());
            this.arr_ntfFreqExpirationEval.clear();
            this.arr_ntfFreqExpirationEval.add(30);
        }
        return this.arr_ntfFreqExpirationEval;
    }

    public List<Integer> getNtfFreqExpirationSubscription() {
        this.arr_ntfFreqExpirationSubscription.clear();
        String[] strList = this.ntfFreqExpirationSubscription.split(";");
        try {
            for (String str : strList) {
                this.arr_ntfFreqExpirationSubscription.add(Integer.parseInt(str));
            }
        }
        catch (NumberFormatException ex) {
            SumLogger.logger.log(Level.WARNING, "Settings: getNtfFreqExpirationSubscription(): exception when parsing property, using the default value: {0}", ex.toString());
            this.arr_ntfFreqExpirationSubscription.clear();
            this.arr_ntfFreqExpirationSubscription.add(30);
        }
        return this.arr_ntfFreqExpirationSubscription;
    }

    public void setActivationMessageEvalAdditionalInfoURL(String url) {
        this.activationMessageEvalAdditionalInfoURL = url;
        this.setProperty(this.propItemActivationMessageEvalAdditionalInfoURL, url, this.localAppSettingsFile);
    }

    public void setActivationMessageSubscriptionAdditionalInfoURL(String url) {
        this.activationMessageSubscriptionAdditionalInfoURL = url;
        this.setProperty(this.propItemActivationMessageSubscriptionAdditionalInfoURL, url, this.localAppSettingsFile);
    }

    public void setDefaultDownloadLocation(String loc) {
        this.defaultDownloadLocation = loc;
        this.setProperty(this.propItemDefaultDownloadLocation, loc, this.localUserSettingsFile);
    }

    public void setFNCLocalDBName(String db_name) {
        this.fncLocalDBName = db_name;
        this.setProperty(this.propItemFNCLocalDBName, db_name, this.localAppSettingsFile);
    }

    public void setFNCServerURL(String fncUrl) {
        this.fncServerURL = fncUrl;
        this.setProperty(this.propItemFNCServerURL, fncUrl, this.localAppSettingsFile);
    }

    public void setIRCWebServiceURL(String ircURL) {
        this.ircWebServiceURL = ircURL;
        this.setProperty(this.propItemIRCWebServiceURL, ircURL, this.localAppSettingsFile);
    }

    public void setMaxHistoryRecordsNumber(int num) {
        this.maxHistoryRecordsNumber = num;
        this.setProperty(this.propItemMaxHistoryRecordsNumber, Integer.toString(num), this.localUserSettingsFile);
    }

    public void setCheckingForUpdateAutoMode(ECFUAutoMode mode) {
        int i_mode = 0;
        switch (mode) {
            case EVERYDAY: {
                i_mode = 0;
                break;
            }
            case EVERYWEEK: {
                i_mode = 1;
                break;
            }
            case EVERYMONTH: {
                i_mode = 2;
            }
        }
        this.checkingForUpdateAutoMode = i_mode;
        this.setProperty(this.propItemCheckingForUpdateAutoMode, Integer.toString(i_mode), this.localUserSettingsFile);
    }

    public void setCheckingForUpdateMode(ECFUMode mode) {
        int i_mode = 1;
        switch (mode) {
            case MANUAL: {
                i_mode = 0;
                break;
            }
            case AUTO: {
                i_mode = 1;
                break;
            }
            case CONTEXT: {
                i_mode = 2;
            }
        }
        this.checkingForUpdateMode = i_mode;
        this.setProperty(this.propItemCheckingForUpdateMode, Integer.toString(i_mode), this.localUserSettingsFile);
    }

    public void setLastCheckForUpdateDate(String date) {
        this.lastCheckForUpdateDate = date;
        this.setProperty(this.propItemLastCheckForUpdateDate, date, this.localUserSettingsFile);
    }

    public void setLastRMALaunchDate(String date) {
        this.lastRMALaunchDate = date;
        this.setProperty(this.propItemLastRMALaunchDate, date, this.localUserSettingsFile);
    }

    public void setTempDirForUnpacking(String directory) {
        this.tempDirForUnpacking = directory;
        this.setProperty(this.propItemTempDirForUnpacking, directory, this.localUserSettingsFile);
    }

    public void setRenewURL(String url) {
        this.renewURL = url;
        this.setProperty(this.propItemRenewURL, url, this.localAppSettingsFile);
    }

    public void setAllowCollectingSystemInfo(int mode) {
        this.allowCollectingSystemInfo = mode;
        this.setProperty(this.propItemAllowCollectingSystemInfo, Integer.toBinaryString(mode), this.localAppSettingsFile);
    }

    public void setDisableUpdatePopupNotifications(int mode) {
        this.disableUpdatePopupNotifications = mode;
        this.setProperty(this.propItemDisableUpdatePopupNotifications, Integer.toBinaryString(mode), this.localUserSettingsFile);
    }

    public void setDisableLicensePopupNotifications(int mode) {
        this.disableLicensePopupNotifications = mode;
        this.setProperty(this.propItemDisableLicensePopupNotifications, Integer.toBinaryString(mode), this.localUserSettingsFile);
    }

    public void setRemotePort(int port) {
        this.remotePort = port;
        this.setProperty(this.propItemRemotePort, Integer.toString(port), this.localAppSettingsFile);
    }

    public void setNtfFreqExpirationEval(String ntfFreqExpirationEval) {
        this.ntfFreqExpirationEval = ntfFreqExpirationEval;
    }

    public void setNtfFreqExpirationSubscription(String ntfFreqExpirationSubscription) {
        this.ntfFreqExpirationSubscription = ntfFreqExpirationSubscription;
    }

    private boolean setUserProperties() {
        boolean isUserPropertiesValid = true;
        this.defaultDownloadLocation = this.userProperties.getProperty(this.propItemDefaultDownloadLocation);
        this.lastCheckForUpdateDate = this.userProperties.getProperty(this.propItemLastCheckForUpdateDate);
        this.ntfFreqExpirationSubscription = this.userProperties.getProperty(this.propItemNtfFreqExpirationSubscription);
        this.ntfFreqExpirationEval = this.userProperties.getProperty(this.propItemNtfFreqExpirationEval);
        this.lastRMALaunchDate = this.userProperties.getProperty(this.propItemLastRMALaunchDate);
        this.tempDirForUnpacking = this.userProperties.getProperty(this.propItemTempDirForUnpacking);
        if (this.defaultDownloadLocation == null || this.lastCheckForUpdateDate == null || this.ntfFreqExpirationSubscription == null || this.ntfFreqExpirationEval == null || this.lastRMALaunchDate == null || this.tempDirForUnpacking == null) {
            isUserPropertiesValid = false;
        }
        try {
            this.maxHistoryRecordsNumber = Integer.parseInt(this.userProperties.getProperty(this.propItemMaxHistoryRecordsNumber));
            this.checkingForUpdateAutoMode = Integer.parseInt(this.userProperties.getProperty(this.propItemCheckingForUpdateAutoMode));
            this.checkingForUpdateMode = Integer.parseInt(this.userProperties.getProperty(this.propItemCheckingForUpdateMode));
            this.disableUpdatePopupNotifications = Integer.parseInt(this.userProperties.getProperty(this.propItemDisableUpdatePopupNotifications));
            this.disableLicensePopupNotifications = Integer.parseInt(this.userProperties.getProperty(this.propItemDisableLicensePopupNotifications));
        }
        catch (NumberFormatException ex) {
            isUserPropertiesValid = false;
        }
        return isUserPropertiesValid;
    }

    private boolean setAppProperties() {
        boolean isAppPropertiesValid = true;
        this.fncLocalDBName = this.appProperties.getProperty(this.propItemFNCLocalDBName);
        this.fncServerURL = this.appProperties.getProperty(this.propItemFNCServerURL);
        this.ircWebServiceURL = this.appProperties.getProperty(this.propItemIRCWebServiceURL);
        this.activationMessageEvalAdditionalInfoURL = this.appProperties.getProperty(this.propItemActivationMessageEvalAdditionalInfoURL);
        this.activationMessageSubscriptionAdditionalInfoURL = this.appProperties.getProperty(this.propItemActivationMessageSubscriptionAdditionalInfoURL);
        this.renewURL = this.appProperties.getProperty(this.propItemRenewURL);
        if (this.fncLocalDBName == null || this.fncServerURL == null || this.ircWebServiceURL == null || this.activationMessageEvalAdditionalInfoURL == null || this.activationMessageSubscriptionAdditionalInfoURL == null || this.renewURL == null) {
            isAppPropertiesValid = false;
        }
        try {
            this.remotePort = Integer.parseInt(this.appProperties.getProperty(this.propItemRemotePort));
            this.allowCollectingSystemInfo = Integer.parseInt(this.appProperties.getProperty(this.propItemAllowCollectingSystemInfo));
        }
        catch (NumberFormatException ex) {
            isAppPropertiesValid = false;
        }
        return isAppPropertiesValid;
    }

    public static enum ECFUAutoMode {
        EVERYDAY,
        EVERYWEEK,
        EVERYMONTH;

    }

    public static enum ECFUMode {
        MANUAL,
        AUTO,
        CONTEXT;

    }
}

