/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core;

import com.intel.ism.gui.Common;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;

public class Resources {
    private static final Resources defaultResources = new Resources();
    private final ResourceBundle bundle = ResourceBundle.getBundle("com.intel.ism.core.properties.Resources", Locale.getDefault());
    private final Calendar maxDate = new GregorianCalendar(Calendar.getInstance().getMaximum(1) - 1, Calendar.getInstance().getMaximum(2), Calendar.getInstance().getMaximum(5));
    private final Calendar minDate = new GregorianCalendar(Calendar.getInstance().getMinimum(1) + 1, Calendar.getInstance().getMinimum(2), Calendar.getInstance().getMinimum(5));

    private Resources() {
    }

    public static Resources getInstance() {
        return defaultResources;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public Calendar getMAX_DATE() {
        return (Calendar)this.maxDate.clone();
    }

    public Calendar getMIN_DATE() {
        return (Calendar)this.minDate.clone();
    }

    public String getTabNameSettings() {
        return this.bundle.getString("left_tab_settings");
    }

    public String getTabNameMessages() {
        return this.bundle.getString("left_tab_messages");
    }

    public String getTabNameHistory() {
        return this.bundle.getString("left_tab_history");
    }

    public String getTabNameDownloads() {
        return this.bundle.getString("left_tab_downloads");
    }

    public String getTabNameActivations() {
        return this.bundle.getString("left_tab_activations");
    }

    public String getBtnCheckForUpdates() {
        return this.bundle.getString("button_check_for_updates");
    }

    public String getLabelTabUpdatesAndDownloads() {
        return this.bundle.getString("label_tab_updates_and_downloads");
    }

    public String getLabelTabActivations() {
        return this.bundle.getString("label_tab_activations");
    }

    public String getLabelTabMessages() {
        return this.bundle.getString("label_tab_messages");
    }

    public String getLabelTabHistory() {
        return this.bundle.getString("label_tab_history");
    }

    public String getLabelTabSettings() {
        return this.bundle.getString("label_tab_settings");
    }

    public String getLabelWait() {
        return this.bundle.getString("label_wait");
    }

    public String getBtnCancel() {
        return this.bundle.getString("button_cancel");
    }

    public String getLinkRenew() {
        return this.bundle.getString("link_renew");
    }

    public String getLinkRenewDest() {
        return this.bundle.getString("link_renew_dest");
    }

    public String getLinkRenewbySNDest() {
        return this.bundle.getString("link_renew_by_sn_dest");
    }

    public String getHistoryStatusDownloaded() {
        return this.bundle.getString("history_status_downloaded");
    }

    public String getHistoryStatusInstalled() {
        return this.bundle.getString("history_status_installed");
    }

    public String getHistoryStatusRemoved() {
        return this.bundle.getString("history_status_remove");
    }

    public String getMessageTypeUpdate() {
        return this.bundle.getString("message_type_update");
    }

    public String getMessageTypeMarketing() {
        return this.bundle.getString("message_type_marketing");
    }

    public String getMessageTypeActivation() {
        return this.bundle.getString("message_type_activation");
    }

    public String getNoEnoughSpaceMessage() {
        return this.bundle.getString("message_no_enough_space");
    }

    public String getTodayDateStr() {
        Date date = GregorianCalendar.getInstance().getTime();
        return Common.getDateFormat().format(date);
    }

    public String getProductName() {
        return this.bundle.getString("product_name");
    }

    public String getBtnOk() {
        return this.bundle.getString("button_ok");
    }
}

