/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core;

import com.intel.ism.core.SumLogger;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class CommandLineParser {
    private String args = "";
    private String guid;
    private String action;
    private String responseFile;
    private String inTray;

    public CommandLineParser(String[] args) {
        for (String arg : args) {
            this.args = this.args + arg + " ";
        }
        this.guid = "";
        this.action = "";
        this.responseFile = "";
        this.inTray = "";
    }

    public void parseArguments() {
        SumLogger.logger.log(Level.INFO, "parseArguments(): command line: {0}", this.args);
        Scanner s = new Scanner(this.args);
        s.useDelimiter(Pattern.compile("\\s*--[a-zA-Z-_]*\\s*"));
        String cmdopt = "";
        try {
            String arg = s.next();
            int pos1 = 0;
            int pos2 = s.match().start();
            cmdopt = this.args.substring(pos1, pos2);
            this.setArgValue(arg, cmdopt.trim());
            pos1 = s.match().end();
            while (s.hasNext()) {
                arg = s.next();
                pos2 = s.match().start();
                cmdopt = this.args.substring(pos1, pos2);
                this.setArgValue(arg, cmdopt.trim());
                pos1 = s.match().end();
            }
        }
        catch (NoSuchElementException e) {
            SumLogger.logger.log(Level.WARNING, "parseArguments(): no such option");
        }
        s.close();
    }

    private void setArgValue(String arg, String cmdopt) {
        if (cmdopt.equals("--product_guid")) {
            this.guid = arg.trim();
        } else if (cmdopt.equals("--action")) {
            this.action = arg.trim();
        } else if (cmdopt.equals("--response")) {
            this.responseFile = arg.trim();
        } else if (cmdopt.equals("--intray")) {
            this.inTray = arg.trim();
        } else {
            SumLogger.logger.log(Level.WARNING, "setArgValue(): invalid option: {0}", cmdopt);
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public String getAction() {
        return this.action;
    }

    public String getResponseFile() {
        return this.responseFile;
    }

    public String getInTray() {
        return this.inTray;
    }
}

