/*
 * Decompiled with CFR 0.152.
 */
package com.intel.lde;

import com.intel.ism.gui.Common;
import isus.IProfile;
import isus.IProfileCollection;
import isus.ProfileMgr;
import isus.USAgent;
import isus.shared.Util;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class Gui
extends JPanel {
    private JPanel jpnLeft;
    private JPanel jpnRight;
    private JPanel jpnInstallData;
    private JPanel jpnCore;
    private JPanel jpnActivation;
    private JPanel jpnSettings;
    private JPanel jpnButtons;
    private JPanel jpnList;
    private JTextField jtfGuid;
    private JTextField jtfVersion;
    private JTextField jtfProductName;
    private JTextField jtfSN;
    private JTextField jtfMediaID;
    private JTextField jtfUpdateID;
    private JTextField jtfProductID;
    private JTextField jtfFulfillmentID;
    private JTextField jtfFNCServerURL;
    private JList list;
    private static final String profileGroupPublic = "Public";
    private static final String undefinedProperty = "NONE";
    private final USAgent agt = new USAgent();
    private String databaseDir;

    public Gui() {
        this.setDataBaseDir();
        this.jpnLeft = new JPanel();
        this.jpnRight = new JPanel();
        this.jpnInstallData = new JPanel();
        this.createJpnCore();
        this.createJpnActivation();
        this.createJpnSettings();
        this.createJpnButtons();
        this.createJpnList();
        this.jpnInstallData.setBorder(BorderFactory.createTitledBorder("Install Data"));
        this.jpnInstallData.setLayout(new BorderLayout());
        this.jpnInstallData.add("North", this.jpnCore);
        this.jpnInstallData.add("Center", this.jpnActivation);
        this.jpnLeft.setLayout(new BorderLayout());
        this.jpnLeft.add("North", this.jpnInstallData);
        this.jpnLeft.add("Center", this.jpnSettings);
        this.jpnRight.setLayout(new BorderLayout());
        this.jpnRight.add("South", this.jpnButtons);
        this.jpnRight.add("Center", this.jpnList);
        this.setLayout(new BorderLayout());
        this.add("West", this.jpnLeft);
        this.add("East", this.jpnRight);
    }

    private void createJpnCore() {
        this.jpnCore = new JPanel();
        this.jpnCore.setBorder(BorderFactory.createTitledBorder("Core"));
        this.jtfGuid = new JTextField(20);
        this.jtfProductName = new JTextField(20);
        this.jtfVersion = new JTextField(20);
        JLabel jlbGuid = new JLabel("GUID *");
        JLabel jlbProductName = new JLabel("Product Name");
        JLabel jlbVersion = new JLabel("Version *");
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 4, 0, 0);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbl.setConstraints(jlbGuid, gbc);
        ++gbc.gridx;
        gbl.setConstraints(this.jtfGuid, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbl.setConstraints(jlbVersion, gbc);
        ++gbc.gridx;
        gbl.setConstraints(this.jtfVersion, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbl.setConstraints(jlbProductName, gbc);
        ++gbc.gridx;
        gbl.setConstraints(this.jtfProductName, gbc);
        this.jpnCore.setLayout(gbl);
        this.jpnCore.add(jlbGuid);
        this.jpnCore.add(this.jtfGuid);
        this.jpnCore.add(jlbVersion);
        this.jpnCore.add(this.jtfVersion);
        this.jpnCore.add(jlbProductName);
        this.jpnCore.add(this.jtfProductName);
    }

    private void createJpnActivation() {
        this.jpnActivation = new JPanel();
        this.jpnActivation.setBorder(BorderFactory.createTitledBorder("Activation"));
        this.jtfFulfillmentID = new JTextField(20);
        this.jtfMediaID = new JTextField(20);
        this.jtfProductID = new JTextField(20);
        this.jtfSN = new JTextField(20);
        this.jtfUpdateID = new JTextField(20);
        JLabel jlbFulfillmentID = new JLabel("Fulfillment ID");
        JLabel jlbMediaID = new JLabel("Media ID");
        JLabel jlbProductID = new JLabel("Product ID");
        JLabel jlbSN = new JLabel("SN");
        JLabel jlbUpdateID = new JLabel("Update ID");
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 4, 0, 0);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbl.setConstraints(jlbSN, gbc);
        ++gbc.gridx;
        gbl.setConstraints(this.jtfSN, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbl.setConstraints(jlbMediaID, gbc);
        ++gbc.gridx;
        gbl.setConstraints(this.jtfMediaID, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbl.setConstraints(jlbUpdateID, gbc);
        ++gbc.gridx;
        gbl.setConstraints(this.jtfUpdateID, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbl.setConstraints(jlbProductID, gbc);
        ++gbc.gridx;
        gbl.setConstraints(this.jtfProductID, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbl.setConstraints(jlbFulfillmentID, gbc);
        ++gbc.gridx;
        gbl.setConstraints(this.jtfFulfillmentID, gbc);
        this.jpnActivation.setLayout(gbl);
        this.jpnActivation.add(jlbSN);
        this.jpnActivation.add(this.jtfSN);
        this.jpnActivation.add(jlbMediaID);
        this.jpnActivation.add(this.jtfMediaID);
        this.jpnActivation.add(jlbUpdateID);
        this.jpnActivation.add(this.jtfUpdateID);
        this.jpnActivation.add(jlbProductID);
        this.jpnActivation.add(this.jtfProductID);
        this.jpnActivation.add(jlbFulfillmentID);
        this.jpnActivation.add(this.jtfFulfillmentID);
    }

    private void createJpnSettings() {
        this.jpnSettings = new JPanel();
        this.jpnSettings.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.jtfFNCServerURL = new JTextField(30);
        this.jtfFNCServerURL.setText("http://dev-registrationcenter03.cps.intel.com:8080/");
        JLabel jlbFNCServerURL = new JLabel("FNC Server URL");
        JLabel jlbCurrentFNCServer = new JLabel("Current FNC Server");
        JLabel jlbCurrentServerURL = new JLabel(this.jtfFNCServerURL.getText());
        JButton btnSet = new JButton("Set");
        btnSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.btnSetClick();
            }
        });
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 4, 0, 0);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbl.setConstraints(jlbFNCServerURL, gbc);
        ++gbc.gridy;
        gbl.setConstraints(this.jtfFNCServerURL, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbl.setConstraints(btnSet, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbl.setConstraints(jlbCurrentFNCServer, gbc);
        ++gbc.gridy;
        gbl.setConstraints(jlbCurrentServerURL, gbc);
        this.jpnSettings.setLayout(gbl);
        this.jpnSettings.add(jlbFNCServerURL);
        this.jpnSettings.add(this.jtfFNCServerURL);
        this.jpnSettings.add(btnSet);
        this.jpnSettings.add(jlbCurrentFNCServer);
        this.jpnSettings.add(jlbCurrentServerURL);
    }

    private void createJpnButtons() {
        this.jpnButtons = new JPanel();
        JButton btnUploadProfile = new JButton("Upload Profile");
        Dimension dim = btnUploadProfile.getPreferredSize();
        JButton btnRefresh = new JButton("Refresh");
        btnRefresh.setPreferredSize(dim);
        JButton btnInstall = new JButton("Install");
        btnInstall.setPreferredSize(dim);
        JButton btnUninstall = new JButton("Uninstall");
        btnUninstall.setPreferredSize(dim);
        btnInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.btnInstallClick();
            }
        });
        btnUninstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.btnUninstallClick();
            }
        });
        btnUploadProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.btnUploadProfileClick();
            }
        });
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Gui.this.fillInstalledProductList();
            }
        });
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(4, 4, 0, 0);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbl.setConstraints(btnUploadProfile, gbc);
        ++gbc.gridx;
        gbl.setConstraints(btnRefresh, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbl.setConstraints(btnInstall, gbc);
        ++gbc.gridx;
        gbl.setConstraints(btnUninstall, gbc);
        this.jpnButtons.setLayout(gbl);
        this.jpnButtons.add(btnUploadProfile);
        this.jpnButtons.add(btnRefresh);
        this.jpnButtons.add(btnInstall);
        this.jpnButtons.add(btnUninstall);
    }

    private void createJpnList() {
        this.jpnList = new JPanel();
        JLabel lbl = new JLabel("Installed Products (double click for details)");
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Gui.this.listMouseDblClicked();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.fillInstalledProductList();
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.jpnList.setLayout(new BorderLayout());
        this.jpnList.add("North", lbl);
        this.jpnList.add("Center", scrollPane);
    }

    private void listMouseDblClicked() {
        if (this.list.getSelectedValues().length == 0) {
            return;
        }
        StringBuffer productInfo = new StringBuffer();
        String product = (String)this.list.getSelectedValue();
        ProfileMgr prf = new ProfileMgr();
        IProfileCollection prc = prf.getCollection(product);
        for (int i = 0; i < prc.getCount(); ++i) {
            IProfile p = prc.item(i);
            productInfo.append(p.getGroupName()).append(": ").append(p.getName()).append("=").append(p.getValue()).append("\n");
        }
        JOptionPane.showMessageDialog(this, productInfo, "Info", 1);
    }

    private void btnInstallClick() {
        Process proc;
        String guid = this.jtfGuid.getText();
        if (guid.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Please input product GUID", "Error", 0);
            return;
        }
        if (this.jtfVersion.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Please input product version", "Error", 0);
            return;
        }
        if (this.jtfFNCServerURL.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Please input FNC server URL", "Error", 0);
            return;
        }
        this.agt.register(guid, this.jtfVersion.getText(), "1033", this.jtfFNCServerURL.getText(), "Default");
        ProfileMgr prf = new ProfileMgr();
        prf.addGroup(guid, profileGroupPublic);
        prf.setValue(guid, profileGroupPublic, "Version", this.jtfVersion.getText().trim());
        if (this.jtfProductName.getText().isEmpty()) {
            prf.setValue(guid, profileGroupPublic, "ProductName", undefinedProperty);
        } else {
            prf.setValue(guid, profileGroupPublic, "ProductName", this.jtfProductName.getText());
            this.agt.setValue(guid, "SN", undefinedProperty);
        }
        if (this.jtfSN.getText().isEmpty()) {
            this.agt.setValue(guid, "SN", undefinedProperty);
        } else {
            this.agt.setValue(guid, "SN", this.jtfSN.getText());
        }
        String[] cmd_get_cpu_info = new String[]{"/bin/bash", "-c", Common.isMac() ? "echo $(/usr/sbin/sysctl -n machdep.cpu.brand_string) Family:$(/usr/sbin/sysctl -n machdep.cpu.family) Model:$(/usr/sbin/sysctl -n machdep.cpu.model)" : "echo $(cat /proc/cpuinfo | grep 'model name' | tail -1 | cut -d':' -f2) Family:$(cat /proc/cpuinfo | grep family | tail -1 | cut -d':' -f2) Model:$(cat /proc/cpuinfo | grep '^model[[:space:]]*:' | tail -1 | cut -d':' -f2)"};
        String proc_info_str = "";
        try {
            proc = Runtime.getRuntime().exec(cmd_get_cpu_info);
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            StringBuilder strbuf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                strbuf.append(line).append(" ");
            }
            proc_info_str = strbuf.toString().trim();
        }
        catch (Throwable t) {
            System.out.println("regtool(): cannot obtain CPU info");
        }
        if (proc_info_str.isEmpty()) {
            proc_info_str = "Unknown";
        }
        String[] cmd_get_mac_addr = new String[]{"/bin/bash", "-c", Common.isMac() ? "/sbin/ifconfig | grep ether | head -1 | sed 's/^.*ether[[:space:]]*\\(.*\\)/\\1/g' | cut -d':' -f5-6" : "/sbin/ifconfig | grep HWaddr | head -1 | sed 's/^.*HWaddr[[:space:]]*\\(.*\\)/\\1/g' | cut -d':' -f5-6"};
        String mac_addr = "";
        try {
            proc = Runtime.getRuntime().exec(cmd_get_mac_addr);
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            StringBuilder strbuf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                strbuf.append(line).append(" ");
            }
            mac_addr = strbuf.toString().trim();
        }
        catch (Throwable t) {
            System.out.println("regtool(): cannot obtain MAC address");
        }
        if (mac_addr.isEmpty()) {
            mac_addr = "Unknown";
        }
        this.agt.setValue(guid, "CPU", proc_info_str);
        this.agt.setValue(guid, "MACLast4", mac_addr);
        this.agt.setValue(guid, "OSName", System.getProperty("os.name"));
        this.agt.setValue(guid, "OSVersion", System.getProperty("os.version"));
        this.agt.setValue(guid, "Arch", System.getProperty("os.arch"));
        this.agt.setValue(guid, "Locale", System.getProperty("user.language"));
        this.agt.setValue(guid, "RecordDemographics", "false");
        if (this.jtfMediaID.getText().isEmpty()) {
            prf.setValue(guid, profileGroupPublic, "MediaID", undefinedProperty);
        } else {
            prf.setValue(guid, profileGroupPublic, "MediaID", this.jtfMediaID.getText());
        }
        if (this.jtfUpdateID.getText().isEmpty()) {
            prf.setValue(guid, profileGroupPublic, "UpdateID", undefinedProperty);
        } else {
            prf.setValue(guid, profileGroupPublic, "UpdateID", this.jtfUpdateID.getText());
        }
        if (this.jtfProductID.getText().isEmpty()) {
            prf.setValue(guid, profileGroupPublic, "ProductID", undefinedProperty);
        } else {
            prf.setValue(guid, profileGroupPublic, "ProductID", this.jtfProductID.getText());
        }
        if (this.jtfFulfillmentID.getText().isEmpty()) {
            prf.setValue(guid, profileGroupPublic, "FulfillmentID", undefinedProperty);
        } else {
            prf.setValue(guid, profileGroupPublic, "FulfillmentID", this.jtfFulfillmentID.getText());
        }
        this.agt.setNotificationServerURL(guid, this.jtfFNCServerURL.getText());
        this.fillInstalledProductList();
        if (!Common.isMac()) {
            try {
                String pfFile = Util.getHome() + System.getProperty("file.separator") + Util.convert2UID(guid) + ".pf";
                String pFile = Util.getHome() + System.getProperty("file.separator") + Util.convert2UID(guid) + ".properties";
                Runtime.getRuntime().exec("/bin/chmod 644 " + pfFile);
                Runtime.getRuntime().exec("/bin/chmod 644 " + pFile);
            }
            catch (Exception ex) {
                System.out.println("regtool(): exception " + ex.getMessage());
            }
        }
        JOptionPane.showMessageDialog(this, "Product " + guid + " version " + this.jtfVersion.getText() + " successfully installed", "Info", 1);
    }

    private void btnUninstallClick() {
        if (this.list.getSelectedValues().length == 0) {
            JOptionPane.showMessageDialog(this, "Please select product to uninstall", "Error", 0);
            return;
        }
        String product = (String)this.list.getSelectedValue();
        this.agt.setValue(product, "IncludeDefault", "0");
        this.agt.unRegister(product, "Default");
        this.list.clearSelection();
        this.fillInstalledProductList();
        JOptionPane.showMessageDialog(this, "Product " + product + " successfully " + "uninstalled", "Info", 1);
    }

    private void btnSetClick() {
        if (this.list.getSelectedValues().length == 0) {
            JOptionPane.showMessageDialog(this, "Please select product for which FNC server URL should be updated", "Error", 0);
            return;
        }
        if (this.jtfFNCServerURL.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Please input FNC server URL first", "Error", 0);
            return;
        }
        String product = (String)this.list.getSelectedValue();
        this.agt.setNotificationServerURL(product, this.jtfFNCServerURL.getText());
        if (!this.agt.isConnectedToNotificationServer(product)) {
            JOptionPane.showMessageDialog(this, "Unable to connect to FNC server", "Error", 0);
            return;
        }
        JOptionPane.showMessageDialog(this, "FNC server URL set successfully", "Info", 1);
    }

    private void btnUploadProfileClick() {
        if (this.list.getSelectedValues().length == 0) {
            JOptionPane.showMessageDialog(this, "Please select product which profile should be uploaded", "Error", 0);
            return;
        }
        String product = (String)this.list.getSelectedValue();
        if (!this.agt.isConnectedToNotificationServer(product)) {
            JOptionPane.showMessageDialog(this, "Unable to connect to FNC server", "Error", 0);
            return;
        }
        ProfileMgr prf = new ProfileMgr();
        prf.uploadCollection(product);
        JOptionPane.showMessageDialog(this, "Profile for product " + product + " successfully uploaded", "Info", 1);
    }

    private void fillInstalledProductList() {
        this.list.removeAll();
        String[] files = new File(this.databaseDir).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        ArrayList<String> guides = new ArrayList<String>();
        for (String file : files) {
            guides.add(file.replace(".properties", ""));
        }
        this.list.setListData(guides.toArray());
    }

    private void setDataBaseDir() {
        this.databaseDir = System.getProperty("user.home") + "/intel/ism/db";
        if (!new File(this.databaseDir).exists() && !new File(this.databaseDir).mkdirs()) {
            System.err.println("ERROR: Cannot create dir " + this.databaseDir);
            System.exit(1);
        }
        this.agt.setProductBaseDir(this.databaseDir);
    }
}

