/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui.treetable;

import com.intel.ism.gui.TableCellRendererLabel;
import com.intel.ism.gui.treetable.DataTree;
import com.intel.ism.gui.treetable.TreeTableInterface;
import com.intel.ism.gui.treetable.TreeToTableLinkerModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.concurrent.Callable;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class TreeTable
extends JTable {
    private TreeTableCellRenderer tree;
    private Callable selectionHandlerFunc;

    public TreeTable(TreeTableInterface treeTableDataModel, Callable<Void> selectionHandlerFunc) {
        this.selectionHandlerFunc = selectionHandlerFunc;
        this.tree = new TreeTableCellRenderer(treeTableDataModel);
        this.tree.setCellRenderer(new TreeTableCellRendererLabel(treeTableDataModel));
        this.setDefaultRenderer(TreeTableInterface.class, this.tree);
        this.setDefaultRenderer(JLabel.class, new TableCellRendererLabel());
        super.setModel(new TreeToTableLinkerModel(treeTableDataModel, this.tree));
        TreeTableSelectionModelLinker selectionLinker = new TreeTableSelectionModelLinker();
        this.tree.setSelectionModel(selectionLinker);
        this.setSelectionModel(selectionLinker.getListSelectionModel());
        this.tree.putClientProperty("JTree.lineStyle", "None");
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 1));
        this.tree.setRootVisible(false);
        this.syncTreeTableRowHeight();
        this.setColumnSelectionAllowed(false);
        this.setFillsViewportHeight(true);
        this.setAutoResizeMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(1);
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    private void syncTreeTableRowHeight() {
        int tableRowHeight = super.getRowHeight();
        if (this.tree != null && this.tree.getRowHeight() != tableRowHeight) {
            this.tree.setRowHeight(tableRowHeight);
        }
    }

    public class TreeTableSelectionModelLinker
    extends DefaultTreeSelectionModel {
        protected boolean listSelectionModelUpdated;

        public TreeTableSelectionModelLinker() {
            this.listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    TreeTableSelectionModelLinker.this.updateSelectedPathsFromSelectedRows();
                    try {
                        TreeTable.this.selectionHandlerFunc.call();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetRowSelection() {
            if (!this.listSelectionModelUpdated) {
                this.listSelectionModelUpdated = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.listSelectionModelUpdated = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.listSelectionModelUpdated) {
                this.listSelectionModelUpdated = true;
                try {
                    int minIdx = this.listSelectionModel.getMinSelectionIndex();
                    int maxIdx = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (minIdx != -1 && maxIdx != -1) {
                        for (int i = minIdx; i <= maxIdx; ++i) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(i) || (selPath = TreeTable.this.tree.getPathForRow(i)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.listSelectionModelUpdated = false;
                }
            }
        }

        private ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }
    }

    public class TreeTableCellRendererLabel
    extends JLabel
    implements TreeCellRenderer {
        TreeTableInterface model;
        DefaultTreeCellRenderer defRenderer;

        public TreeTableCellRendererLabel(TreeTableInterface model) {
            this.model = model;
            this.defRenderer = new DefaultTreeCellRenderer();
            this.defRenderer.setOpenIcon(null);
            this.defRenderer.setClosedIcon(null);
            this.defRenderer.setLeafIcon(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component rendererComponent = this.defRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf) {
                if (tree.getPathForRow(row) != null) {
                    int treeColumnIdx = this.model.getIndexOfTreeColumn();
                    Object node = tree.getPathForRow(row).getLastPathComponent();
                    Object valueTree = this.model.getValueAt(node, treeColumnIdx);
                    if (valueTree instanceof JLabel) {
                        this.setText(((JLabel)valueTree).getText());
                        this.setFont(((JLabel)valueTree).getFont());
                        this.setForeground(((JLabel)valueTree).getForeground());
                        this.setIcon(((JLabel)valueTree).getIcon());
                        rendererComponent = this;
                    }
                }
            } else if (value instanceof DataTree.Group) {
                this.setText(((DataTree.Group)value).getJlbTitle().getText());
                this.setFont(((DataTree.Group)value).getJlbTitle().getFont());
                this.setForeground(((DataTree.Group)value).getJlbTitle().getForeground());
                this.setIcon(null);
                rendererComponent = this;
            }
            return rendererComponent;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private int rowToShow;

        public TreeTableCellRenderer(TreeTableInterface treeTableDataModel) {
            super(treeTableDataModel);
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, TreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.rowToShow * this.getRowHeight());
            super.paint(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color background = isSelected ? table.getSelectionBackground() : table.getBackground();
            this.rowToShow = row;
            this.setBackground(background);
            return this;
        }
    }
}

