/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui.controllers;

import com.intel.ism.core.Resources;
import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.data.LicenseMessage;
import com.intel.ism.core.data.LocalStoreDataManager;
import com.intel.ism.core.data.Update;
import com.intel.ism.core.objects.LicenseMessages;
import com.intel.ism.core.objects.UpdatesAndDownloads;
import com.intel.ism.gui.SumTrayIcon;
import com.intel.ism.gui.controllers.ApplicationManager;
import java.util.logging.Level;

public class TrayNotificationManager {
    private int tabToShowIndx = 0;

    public int getTabToShowIndx() {
        return this.tabToShowIndx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TrayNotification getNewMessagesTrayNotification(String guid, boolean flagRemote) {
        boolean callForParticularGuid;
        TrayNotification ntf = new TrayNotification();
        boolean bl = callForParticularGuid = !guid.equals("EMPTY");
        if (callForParticularGuid) {
            SumLogger.logger.log(Level.INFO, "getNewMessagesTrayNotification(): call from product for particular guid = {0}", guid);
            Update u = new UpdatesAndDownloads().getFirstNewUpdate(guid);
            if (u != null) {
                SumLogger.logger.log(Level.INFO, "getNewMessagesTrayNotification(): update IS found");
                u.setShowNotification(false);
                LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
                ntf.title = u.getProductName();
                ntf.description = Resources.getInstance().getBundle().getString("notification_description_new_update");
                ntf.type = ENotificationType.OTHER;
                SumTrayIcon.getInstance().createTrayIcon();
                return ntf;
            } else {
                SumLogger.logger.log(Level.INFO, "getNewMessagesTrayNotification(): NO any new update is found for this guid");
                if (flagRemote) return null;
                ApplicationManager.getInstance().exitAction(0);
            }
            return ntf;
        } else {
            int undCount = new UpdatesAndDownloads().getNewUpdatesAndDownloadsCount();
            int amCount = new LicenseMessages().getNewLicenseMessagesCount();
            SumLogger.logger.log(Level.INFO, "getNewMessagesTrayNotification(): new updates = {0}", undCount);
            SumLogger.logger.log(Level.INFO, "getNewMessagesTrayNotification(): new activation messages = {0}", amCount);
            if (undCount > 0 || amCount > 0) {
                if (undCount > 0 && amCount == 0) {
                    if (undCount == 1) {
                        ntf.title = new UpdatesAndDownloads().getFirstNewUpdate().getProductName();
                        ntf.description = Resources.getInstance().getBundle().getString("notification_description_new_update");
                    } else {
                        ntf.title = Resources.getInstance().getBundle().getString("notification_title_new_updates");
                        ntf.description = Resources.getInstance().getBundle().getString("notification_description_default");
                    }
                    ntf.type = ENotificationType.UPDATE;
                    this.tabToShowIndx = 0;
                } else if (undCount == 0 && amCount > 0) {
                    if (amCount == 1) {
                        LicenseMessage am = new LicenseMessages().getFirstNewLicenseMessage();
                        if (am != null) {
                            ntf.title = am.getProductName();
                            block0 : switch (am.getMessageType()) {
                                case Evaluation: {
                                    switch (am.getMessageStatus()) {
                                        case Expired: {
                                            ntf.description = Resources.getInstance().getBundle().getString("notification_title_activation_eval_expired");
                                            break block0;
                                        }
                                        case Warning: {
                                            ntf.description = Resources.getInstance().getBundle().getString("notification_title_activation_eval_expired_warning");
                                        }
                                    }
                                    break;
                                }
                                case Subscription: {
                                    switch (am.getMessageStatus()) {
                                        case Expired: 
                                        case ExpiredMoreThanAYearAgo: {
                                            ntf.description = Resources.getInstance().getBundle().getString("notification_title_activation_subsc_expired");
                                            break block0;
                                        }
                                        case Warning: {
                                            ntf.description = Resources.getInstance().getBundle().getString("notification_title_activation_subsc_expired_warning");
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        ntf.title = Resources.getInstance().getBundle().getString("notification_title_new_messages");
                        ntf.description = Resources.getInstance().getBundle().getString("notification_description_default");
                    }
                    ntf.type = ENotificationType.LICENSE;
                    this.tabToShowIndx = 1;
                } else {
                    ntf.title = Resources.getInstance().getBundle().getString("notification_title_some_messages");
                    ntf.description = Resources.getInstance().getBundle().getString("notification_description_default");
                    ntf.type = ENotificationType.MIX;
                    this.tabToShowIndx = 0;
                }
                new UpdatesAndDownloads().setAllUpdatesAsShown();
                new LicenseMessages().setAllLicenseMessagesAsShown();
                LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
                return ntf;
            } else {
                SumLogger.logger.log(Level.INFO, "getNewMessagesTrayNotification(): no any new messages found");
                return null;
            }
        }
    }

    public boolean isSkipNotification(TrayNotification ntf) {
        if (ntf == null) {
            return true;
        }
        boolean ret = false;
        if (ntf.type.equals((Object)ENotificationType.UPDATE) && Settings.defaultSettings.getDisableUpdatePopupNotifications() == 1) {
            ret = true;
        }
        if (ntf.type.equals((Object)ENotificationType.LICENSE) && Settings.defaultSettings.getDisableLicensePopupNotifications() == 1) {
            ret = true;
        }
        if (ntf.type.equals((Object)ENotificationType.MIX) && Settings.defaultSettings.getDisableLicensePopupNotifications() == 1 && Settings.defaultSettings.getDisableUpdatePopupNotifications() == 1) {
            ret = true;
        }
        return ret;
    }

    public static enum ENotificationType {
        UPDATE,
        LICENSE,
        MIX,
        OTHER;

    }

    public class TrayNotification {
        public String title = "";
        public String description = "";
        public ENotificationType type = ENotificationType.MIX;
    }
}

