/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui.controllers;

import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.gui.RemoteInterface;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.logging.Level;

public class SumController {
    private String guid;
    private String action;
    private String responseFile;

    public SumController(String guid, String action, String responseFile) {
        this.guid = guid;
        this.action = action;
        this.responseFile = responseFile;
    }

    public void runClient(boolean shouldRunCheckForUpdates, boolean needExit) {
        SumLogger.logger.info("-- running an application agent (call from product) --");
        SumLogger.logger.info("client - looking for specific class in rmiregistry");
        int rc = 0;
        Registry registry = null;
        RemoteInterface server = null;
        for (int i = 0; i < 10; ++i) {
            SumLogger.logger.log(Level.INFO, "client - attempt to invoke remote method #{0}/10", i + 1);
            try {
                registry = LocateRegistry.getRegistry(Settings.defaultSettings.getRemotePort());
                String objLabel = "sumremote_" + System.getProperty("user.name");
                server = (RemoteInterface)registry.lookup(objLabel);
            }
            catch (NotBoundException ex) {
                SumLogger.logger.log(Level.INFO, "client - cannot lookup bound object in registry: {0}", ex.getMessage());
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ex1) {
                    SumLogger.logger.log(Level.INFO, "client - cannot make thread to sleep for 1s before next attempt to get registry");
                }
            }
            catch (RemoteException ex) {
                SumLogger.logger.log(Level.INFO, "client - remote exception: {0} ", ex.getMessage());
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ex1) {
                    SumLogger.logger.log(Level.INFO, "client - cannot make thread to sleep for 1s before next attempt to get registry");
                }
            }
            if (server == null) break;
            try {
                SumLogger.logger.info("client - found object");
                if (this.action.equals("get_info")) {
                    SumLogger.logger.info("client - run get_info action");
                    if (!server.actionGetInfo(this.guid, this.responseFile, shouldRunCheckForUpdates)) {
                        rc = 1;
                    }
                    if (!needExit) break;
                    SumLogger.logger.info("client - run remote Exit action");
                    server.actionExit();
                    break;
                }
                if (this.action.equals("view")) {
                    SumLogger.logger.info("client - run view action");
                    server.actionView(this.guid, shouldRunCheckForUpdates);
                    break;
                }
                if (this.action.equals("download")) {
                    SumLogger.logger.info("client - run download action");
                    server.actionDownload(this.guid, shouldRunCheckForUpdates);
                    break;
                }
                if (!this.action.equals("check")) break;
                SumLogger.logger.info("client - run check action");
                server.actionCheck(this.guid, shouldRunCheckForUpdates);
            }
            catch (RemoteException ex) {
                SumLogger.logger.log(Level.INFO, "client - remote exception when running remote method: {0} ", ex.getMessage());
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ex1) {
                    SumLogger.logger.log(Level.INFO, "client - cannot make thread to sleep for 1s before next attempt to get registry");
                }
            }
            break;
        }
        System.exit(rc);
    }
}

