/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui.controllers;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.UIManager;

public final class FontManager {
    private static Font plainFont;

    private FontManager() {
        throw new AssertionError();
    }

    public static Font getPlainFont() {
        return plainFont;
    }

    public static Font getBoldFont() {
        return plainFont.deriveFont(1);
    }

    public static Font getUnderlinedFont() {
        HashMap<TextAttribute, Integer> attr = new HashMap<TextAttribute, Integer>();
        attr.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        return plainFont.deriveFont(attr);
    }

    static {
        Font font = UIManager.getFont("TabbedPane.font");
        int size = font.getSize();
        if (Locale.getDefault().equals(Locale.JAPAN)) {
            Font[] allfonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            String jpSampleSymbol = "\u5e7412";
            for (int i = 0; i < allfonts.length; ++i) {
                if (allfonts[i].canDisplayUpTo(jpSampleSymbol) != -1) continue;
                try {
                    font = allfonts[i].deriveFont((float)size);
                    break;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        plainFont = font.deriveFont(0);
    }
}

