/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.UsageStatisticsManager;
import com.intel.ism.core.data.LocalStoreDataManager;
import com.intel.ism.core.data.Update;
import com.intel.ism.core.objects.UpdatesAndDownloads;
import com.intel.ism.gui.Common;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.InfoDialog;
import com.intel.ism.gui.OutputPane;
import com.intel.ism.gui.PanelBottom;
import com.intel.ism.gui.SumImages;
import com.intel.ism.gui.TabHistory;
import com.intel.ism.gui.TabPanel;
import com.intel.ism.gui.TableCellRendererButtons;
import com.intel.ism.gui.TableCellRendererProgressBar;
import com.intel.ism.gui.controllers.ApplicationManager;
import com.intel.ism.gui.controllers.FontManager;
import com.intel.ism.gui.treetable.DataTree;
import com.intel.ism.gui.treetable.TreeTable;
import com.intel.ism.gui.treetable.TreeTableUpdates;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EventListener;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TabUpdatesAndDownloads
extends JPanel {
    private static TabUpdatesAndDownloads tabUpdatesAndDownloads;
    private TreeTable treeTable;
    private DataTree dataModel;
    private JLabel jlbSelect = new JLabel(Resources.getInstance().getLabelTabUpdatesAndDownloads(), SumImages.imgInfo, 2);
    private final OutputPane pane = new OutputPane();
    private StringBuilder url = new StringBuilder();
    private final JLabel jlbProductName = new JLabel();
    private JPanel jpnMoreInfo;
    private final JLabel jlbMoreInfo = new JLabel(Resources.getInstance().getBundle().getString("tab_downloads_lbl_more_info"));
    private JLabel jlbDownloadStatic = new JLabel(Resources.getInstance().getBundle().getString("tab_downloads_lbl_download_to"));
    private JTextField jtfDownloadDynamic;
    private String statusCFU = Resources.getInstance().getBundle().getString("tab_downloads_lbl_no_updates");
    private JPopupMenu popupMenu;
    private JMenuItem itemStart;
    private JMenuItem itemResume;
    private JMenuItem itemPause;
    private JMenuItem itemCancel;
    private JMenuItem itemInstall;
    private JMenuItem itemInfo;
    private static final int TABLE_BUTTONS_COLUMN_INDEX = 0;
    private static final int TABLE_TITLE_COLUMN_INDEX = 1;
    private static final int TABLE_RELEASE_DATE_COLUMN_INDEX = 2;
    private static final int TABLE_SIZE_COLUMN_INDEX = 3;
    private static final int TABLE_STATUS_COLUMN_INDEX = 4;
    private static final int TABLE_PROGRESS_COLUMN_INDEX = 5;
    private static final int TABLE_SPEED_COLUMN_INDEX = 6;

    public static synchronized TabUpdatesAndDownloads getInstance() {
        if (tabUpdatesAndDownloads == null) {
            tabUpdatesAndDownloads = new TabUpdatesAndDownloads();
        }
        return tabUpdatesAndDownloads;
    }

    private TabUpdatesAndDownloads() {
        this.jtfDownloadDynamic = new JTextField(Settings.defaultSettings.getDefaultDownloadLocation()){

            @Override
            public Font getFont() {
                return FontManager.getUnderlinedFont();
            }

            @Override
            public Color getForeground() {
                return Color.BLUE;
            }

            @Override
            public boolean isEditable() {
                return false;
            }
        };
        this.jtfDownloadDynamic.setBorder(null);
        this.jtfDownloadDynamic.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        File dir = new File(TabUpdatesAndDownloads.this.jtfDownloadDynamic.getText().trim());
                        if (dir.exists() && dir.canExecute()) {
                            desktop.open(dir);
                        }
                    }
                    catch (IOException ex) {
                        SumLogger.logger.log(Level.WARNING, "tabUpdatesAndDownloads(): jtfDownloadDynamic: {0}", ex.toString());
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TabUpdatesAndDownloads.this.setCursor(new Cursor(12));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String fieldText = TabUpdatesAndDownloads.this.jtfDownloadDynamic.getText();
                        FontMetrics fm = TabUpdatesAndDownloads.this.jtfDownloadDynamic.getFontMetrics(TabUpdatesAndDownloads.this.jtfDownloadDynamic.getFont());
                        int fieldTextWidth = fm.stringWidth(fieldText);
                        if (fieldTextWidth >= TabUpdatesAndDownloads.this.getWidth() - ((TabUpdatesAndDownloads)TabUpdatesAndDownloads.this).jlbDownloadStatic.getPreferredSize().width) {
                            TabUpdatesAndDownloads.this.jtfDownloadDynamic.setToolTipText(fieldText);
                        } else {
                            TabUpdatesAndDownloads.this.jtfDownloadDynamic.setToolTipText(null);
                        }
                    }
                });
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TabUpdatesAndDownloads.this.setCursor(new Cursor(0));
            }
        });
        this.jlbMoreInfo.setVisible(false);
        this.jlbMoreInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Common.openBrowser(TabUpdatesAndDownloads.this.url.toString());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TabUpdatesAndDownloads.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TabUpdatesAndDownloads.this.setCursor(new Cursor(0));
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setBackground(Color.WHITE);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void setCFUStatusStr(String status) {
        this.statusCFU = status;
    }

    public void refresh() {
        this.dataModel = new DataTree(Update.class);
        int msgCount = this.dataModel.getLeafCount();
        TabPanel.getInstance().setUpdatesAndDownloadsTabTitle(String.valueOf(msgCount));
        if (msgCount > 0) {
            this.tabFoundUpdatesAndDownloads();
        } else {
            this.tabNoUpdatesAndDownloads();
        }
        this.updateUI();
    }

    private void tabNoUpdatesAndDownloads() {
        this.removeAll();
        JLabel jlbImg = new JLabel(SumImages.imgInfo, 2);
        JEditorPane jepNoUpdates = new JEditorPane("text/html", this.statusCFU);
        jepNoUpdates.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jepNoUpdates.setEditable(false);
        jepNoUpdates.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent he) {
                if (Desktop.isDesktopSupported()) {
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(he.getEventType())) {
                        try {
                            Desktop.getDesktop().browse(he.getURL().toURI());
                        }
                        catch (Exception ex) {
                            SumLogger.logger.log(Level.WARNING, "tabNoUpdatesAndDownloads(): exception during open default browser {0}", ex.getMessage());
                        }
                    }
                } else if (HyperlinkEvent.EventType.ACTIVATED.equals(he.getEventType())) {
                    Common.openBrowser(he.getURL().toString());
                }
            }
        });
        GridBagLayout gbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbag.setConstraints(jlbImg, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbag.setConstraints(jepNoUpdates, gbc);
        this.setLayout(gbag);
        this.add(jlbImg);
        this.add(jepNoUpdates);
    }

    private void tabFoundUpdatesAndDownloads() {
        for (Update u : this.dataModel.getListOfUpdates()) {
            switch (u.getUpdateDownloadStatus()) {
                case PausedByApp: {
                    u.download(true);
                    break;
                }
                case Installing: {
                    u.setUpdateDownloadStatus(Update.UpdateDownload.Downloaded);
                }
            }
        }
        TreeTableUpdates treeTableUpdatesData = new TreeTableUpdates(this.dataModel.getRoot());
        this.treeTable = new TreeTable(treeTableUpdatesData, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TabUpdatesAndDownloads.this.selectionHandler();
                return null;
            }
        });
        this.treeTable.setDefaultRenderer(JPanel.class, new TableCellRendererButtons());
        this.treeTable.setDefaultEditor(JPanel.class, new TableCellRendererButtons());
        this.treeTable.setDefaultRenderer(JProgressBar.class, new TableCellRendererProgressBar());
        this.treeTable.setRowHeight(SumImages.imgResumeButton.getIconHeight() + 4);
        this.setItemButtonsListeners();
        this.setTreeTableMouseListeners();
        this.popupMenu = new JPopupMenu();
        this.setupPopupMenu(this.popupMenu);
        this.treeTable.getColumnModel().getColumn(0).setMaxWidth(2 * SumImages.imgResumeButton.getIconWidth() + 4);
        this.treeTable.getColumnModel().getColumn(0).setResizable(false);
        this.treeTable.getColumnModel().getColumn(5).setPreferredWidth(100);
        int[] columnsToFit = new int[]{1, 2, 3, 4};
        Common.fitColumnsWidth(this.treeTable, columnsToFit);
        this.removeAll();
        this.jlbSelect.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JScrollPane scrollTable = new JScrollPane(this.treeTable, 20, 30);
        scrollTable.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        scrollTable.getViewport().setBackground(Color.WHITE);
        this.jlbProductName.setFont(FontManager.getBoldFont());
        JPanel jpnProductName = new JPanel(new BorderLayout());
        jpnProductName.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 0));
        jpnProductName.add((Component)this.jlbProductName, "West");
        JScrollPane scrollOutput = new JScrollPane(this.pane.getOutput()){

            @Override
            public Color getBackground() {
                return Color.WHITE;
            }
        };
        scrollOutput.setBorder(BorderFactory.createEmptyBorder(0, 12, 5, 5));
        this.jpnMoreInfo = new JPanel(new BorderLayout());
        this.jpnMoreInfo.add((Component)this.jlbMoreInfo, "East");
        this.jpnMoreInfo.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 5));
        JPanel jpnOutput = new JPanel(new BorderLayout());
        jpnOutput.add((Component)jpnProductName, "North");
        jpnOutput.add((Component)scrollOutput, "Center");
        jpnOutput.add((Component)this.jpnMoreInfo, "South");
        jpnOutput.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        JSplitPane splitPane = new JSplitPane(0, (Component)scrollTable, (Component)jpnOutput){

            @Override
            public double getResizeWeight() {
                return 0.3;
            }

            @Override
            public Border getBorder() {
                return BorderFactory.createEmptyBorder();
            }
        };
        this.updateDownloadToLabel();
        JPanel jpnJlbDownload = new JPanel();
        jpnJlbDownload.setLayout(new BoxLayout(jpnJlbDownload, 2));
        jpnJlbDownload.add(this.jlbDownloadStatic);
        jpnJlbDownload.add(this.jtfDownloadDynamic);
        jpnJlbDownload.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.jlbSelect, "North");
        this.add((Component)splitPane, "Center");
        this.add((Component)jpnJlbDownload, "South");
    }

    private void setTreeTableMouseListeners() {
        for (MouseListener mouseListener : this.treeTable.getMouseListeners()) {
            this.treeTable.removeMouseListener(mouseListener);
        }
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = TabUpdatesAndDownloads.this.treeTable.rowAtPoint(e.getPoint());
                if (row < TabUpdatesAndDownloads.this.treeTable.getTree().getRowCount() && row != -1) {
                    TabUpdatesAndDownloads.this.treeTable.changeSelection(row, 0, false, false);
                    Object tn = TabUpdatesAndDownloads.this.treeTable.getTree().getLastSelectedPathComponent();
                    if (tn instanceof DataTree.ItemUpdate) {
                        this.showPopup(e);
                    }
                } else {
                    TabUpdatesAndDownloads.this.treeTable.getSelectionModel().clearSelection();
                    TabUpdatesAndDownloads.this.pane.clean();
                    TabUpdatesAndDownloads.this.jlbProductName.setText("");
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Object tn;
                int row = TabUpdatesAndDownloads.this.treeTable.rowAtPoint(e.getPoint());
                if (row < TabUpdatesAndDownloads.this.treeTable.getTree().getRowCount() && row != -1 && (tn = TabUpdatesAndDownloads.this.treeTable.getTree().getLastSelectedPathComponent()) instanceof DataTree.ItemUpdate) {
                    this.showPopup(e);
                }
            }

            public void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TabUpdatesAndDownloads.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        for (EventListener eventListener : this.treeTable.getMouseMotionListeners()) {
            this.treeTable.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        this.treeTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int column = TabUpdatesAndDownloads.this.treeTable.columnAtPoint(e.getPoint());
                if (column == 0) {
                    int row = TabUpdatesAndDownloads.this.treeTable.rowAtPoint(e.getPoint());
                    TabUpdatesAndDownloads.this.treeTable.editCellAt(row, column);
                }
            }
        });
    }

    private void removePopupMenuItemListeners(JMenuItem item) {
        for (ActionListener i : item.getActionListeners()) {
            item.removeActionListener(i);
        }
    }

    private void setupPopupMenu(final JPopupMenu popupMenu) {
        this.itemStart = new JMenuItem(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_start"), SumImages.imgStartButton);
        this.itemResume = new JMenuItem(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_resume"), SumImages.imgResumeButton);
        this.itemPause = new JMenuItem(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_pause"), SumImages.imgPauseButton);
        this.itemCancel = new JMenuItem(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_stop"), SumImages.imgCancelButton);
        this.itemInstall = new JMenuItem(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_install"), SumImages.imgInstallButton);
        this.itemInfo = new JMenuItem(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_info"), SumImages.imgInfoButton);
        this.removePopupMenuItemListeners(this.itemStart);
        this.removePopupMenuItemListeners(this.itemResume);
        this.removePopupMenuItemListeners(this.itemPause);
        this.removePopupMenuItemListeners(this.itemCancel);
        this.removePopupMenuItemListeners(this.itemInstall);
        this.removePopupMenuItemListeners(this.itemInfo);
        this.itemStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object tn = TabUpdatesAndDownloads.this.treeTable.getTree().getSelectionPath().getLastPathComponent();
                if (tn instanceof DataTree.ItemUpdate) {
                    ((DataTree.ItemUpdate)tn).getBtnStartResume().doClick();
                }
            }
        });
        this.itemResume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object tn = TabUpdatesAndDownloads.this.treeTable.getTree().getSelectionPath().getLastPathComponent();
                if (tn instanceof DataTree.ItemUpdate) {
                    ((DataTree.ItemUpdate)tn).getBtnStartResume().doClick();
                }
            }
        });
        this.itemPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object tn = TabUpdatesAndDownloads.this.treeTable.getTree().getSelectionPath().getLastPathComponent();
                if (tn instanceof DataTree.ItemUpdate) {
                    ((DataTree.ItemUpdate)tn).getBtnPause().doClick();
                }
            }
        });
        this.itemCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object tn = TabUpdatesAndDownloads.this.treeTable.getTree().getSelectionPath().getLastPathComponent();
                if (tn instanceof DataTree.ItemUpdate) {
                    ((DataTree.ItemUpdate)tn).getBtnCancel().doClick();
                }
            }
        });
        this.itemInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object tn = TabUpdatesAndDownloads.this.treeTable.getTree().getSelectionPath().getLastPathComponent();
                if (tn instanceof DataTree.ItemUpdate) {
                    ((DataTree.ItemUpdate)tn).getBtnInstall().doClick();
                }
            }
        });
        this.itemInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object tn = TabUpdatesAndDownloads.this.treeTable.getTree().getSelectionPath().getLastPathComponent();
                if (tn instanceof DataTree.ItemUpdate) {
                    ((DataTree.ItemUpdate)tn).getBtnInfo().doClick();
                }
            }
        });
        popupMenu.add(this.itemStart);
        popupMenu.add(this.itemResume);
        popupMenu.add(this.itemPause);
        popupMenu.add(this.itemCancel);
        popupMenu.addSeparator();
        popupMenu.add(this.itemInstall);
        popupMenu.addSeparator();
        popupMenu.add(this.itemInfo);
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Object tn = TabUpdatesAndDownloads.this.treeTable.getTree().getSelectionPath().getLastPathComponent();
                if (tn instanceof DataTree.ItemUpdate) {
                    Update.UpdateDownload status = ((DataTree.ItemUpdate)tn).getUpdate().getUpdateDownloadStatus();
                    boolean allowToDownload = ((DataTree.ItemUpdate)tn).getUpdate().getIsAllowToDownload();
                    if (allowToDownload) {
                        switch (status) {
                            case Downloading: 
                            case DownloadingBegin: {
                                TabUpdatesAndDownloads.this.itemStart.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemResume.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemPause.setEnabled(true);
                                TabUpdatesAndDownloads.this.itemCancel.setEnabled(true);
                                TabUpdatesAndDownloads.this.itemInstall.setEnabled(false);
                                popupMenu.getComponent(6).setVisible(false);
                                popupMenu.getComponent(7).setVisible(false);
                                break;
                            }
                            case Paused: {
                                TabUpdatesAndDownloads.this.itemStart.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemResume.setEnabled(true);
                                TabUpdatesAndDownloads.this.itemPause.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemCancel.setEnabled(true);
                                TabUpdatesAndDownloads.this.itemInstall.setEnabled(false);
                                popupMenu.getComponent(6).setVisible(false);
                                popupMenu.getComponent(7).setVisible(false);
                                break;
                            }
                            case Downloaded: {
                                TabUpdatesAndDownloads.this.itemStart.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemResume.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemPause.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemCancel.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemInstall.setEnabled(true);
                                popupMenu.getComponent(6).setVisible(false);
                                popupMenu.getComponent(7).setVisible(false);
                                break;
                            }
                            case Installing: 
                            case Installed: {
                                TabUpdatesAndDownloads.this.itemStart.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemResume.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemPause.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemCancel.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemInstall.setEnabled(false);
                                popupMenu.getComponent(6).setVisible(false);
                                popupMenu.getComponent(7).setVisible(false);
                                break;
                            }
                            case Error: {
                                TabUpdatesAndDownloads.this.itemStart.setEnabled(true);
                                TabUpdatesAndDownloads.this.itemResume.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemPause.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemCancel.setEnabled(true);
                                TabUpdatesAndDownloads.this.itemInstall.setEnabled(false);
                                popupMenu.getComponent(6).setVisible(false);
                                popupMenu.getComponent(7).setVisible(false);
                                break;
                            }
                            default: {
                                TabUpdatesAndDownloads.this.itemStart.setEnabled(true);
                                TabUpdatesAndDownloads.this.itemResume.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemPause.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemCancel.setEnabled(false);
                                TabUpdatesAndDownloads.this.itemInstall.setEnabled(false);
                                popupMenu.getComponent(6).setVisible(false);
                                popupMenu.getComponent(7).setVisible(false);
                            }
                        }
                        if (ApplicationManager.getInstance().getIsSomethingIsInstalling()) {
                            TabUpdatesAndDownloads.this.itemInstall.setEnabled(false);
                        }
                    } else {
                        TabUpdatesAndDownloads.this.itemStart.setEnabled(false);
                        TabUpdatesAndDownloads.this.itemResume.setEnabled(false);
                        TabUpdatesAndDownloads.this.itemPause.setEnabled(false);
                        TabUpdatesAndDownloads.this.itemCancel.setEnabled(false);
                        TabUpdatesAndDownloads.this.itemInstall.setEnabled(false);
                        popupMenu.getComponent(6).setVisible(true);
                        popupMenu.getComponent(7).setVisible(true);
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private void setItemButtonsListeners() {
        for (int i = 0; i < this.treeTable.getTree().getRowCount(); ++i) {
            Object node = this.treeTable.getTree().getPathForRow(i).getLastPathComponent();
            final int row = i;
            if (!(node instanceof DataTree.ItemUpdate)) continue;
            final DataTree.ItemUpdate item = (DataTree.ItemUpdate)node;
            this.removeBtnListeners(item.getBtnPause());
            this.removeBtnListeners(item.getBtnCancel());
            this.removeBtnListeners(item.getBtnStartResume());
            this.removeBtnListeners(item.getBtnInstall());
            this.removeBtnListeners(item.getBtnInfo());
            item.getBtnPause().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (row != -1) {
                        TabUpdatesAndDownloads.this.treeTable.changeSelection(row, 0, false, false);
                        UsageStatisticsManager.getInstance().increaseActionPause();
                        item.getUpdate().pauseDownload(false);
                        item.setDownloadStatusText(item.getUpdate().getUpdateDownloadStatusString());
                        item.setDownloadSpeedText("");
                        LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
                        TabUpdatesAndDownloads.this.updateBtnPanelButtons(item, row);
                    }
                }
            });
            item.getBtnCancel().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (row != -1) {
                        TabUpdatesAndDownloads.this.treeTable.changeSelection(row, 0, false, false);
                        UsageStatisticsManager.getInstance().increaseActionCancelDownload();
                        item.getUpdate().cancelDownload();
                        item.setDownloadStatusText(item.getUpdate().getUpdateDownloadStatusString());
                        item.getProgressBar().setValue(item.getUpdate().getDownloadProgress());
                        item.setDownloadSpeedText("");
                        LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
                        TabUpdatesAndDownloads.this.updateBtnPanelButtons(item, row);
                    }
                }
            });
            item.getBtnStartResume().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (row != -1) {
                        TabUpdatesAndDownloads.this.treeTable.changeSelection(row, 0, false, false);
                        if (Common.checkDownloadDirectory(item.getUpdate().getDownloadSize()) == Common.EFileSystemError.ERR_OK) {
                            if (item.getUpdate().getUpdateDownloadStatus() == Update.UpdateDownload.None) {
                                UsageStatisticsManager.getInstance().increaseActionDownload();
                                item.getUpdate().download(false);
                            } else {
                                UsageStatisticsManager.getInstance().increaseActionResume();
                                if (item.getUpdate().getDownloadingHasBeenStarted()) {
                                    item.getUpdate().pauseDownload(true);
                                } else {
                                    item.getUpdate().download(true);
                                }
                            }
                            item.setDownloadStatusText(item.getUpdate().getUpdateDownloadStatusString());
                            TabUpdatesAndDownloads.this.updateBtnPanelButtons(item, row);
                        }
                    }
                }
            });
            item.getBtnInstall().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (row != -1) {
                        TabUpdatesAndDownloads.this.treeTable.changeSelection(row, 0, false, false);
                        UsageStatisticsManager.getInstance().increaseActionInstall();
                        final Update u = item.getUpdate();
                        u.removeAllCustomInstallEventListeners();
                        u.addCustomInstallEventListener(new Update.CustomInstallEventListener(){

                            @Override
                            public void OnInstallBegin() {
                                ApplicationManager.getInstance().setIsSomethingIsInstalling(true, u.getTitle());
                                PanelBottom.getInstance().disableRefreshButton();
                                TabUpdatesAndDownloads.this.updateAllBtnPanels();
                                item.setDownloadStatusText(u.getUpdateDownloadStatusString());
                                ((AbstractTableModel)TabUpdatesAndDownloads.this.treeTable.getModel()).fireTableCellUpdated(row, 4);
                                LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
                            }

                            @Override
                            public void OnInstallComplete() {
                                ApplicationManager.getInstance().setIsSomethingIsInstalling(false);
                                PanelBottom.getInstance().enableRefreshButton();
                                item.setDownloadStatusText(u.getUpdateDownloadStatusString());
                                LocalStoreDataManager.defaultLocalStoreDataManager.getHistory().addItem(u.getId(), u.getTitle(), u.getDescription(), Resources.getInstance().getTodayDateStr(), Resources.getInstance().getHistoryStatusInstalled(), Resources.getInstance().getMessageTypeUpdate(), "");
                                LocalStoreDataManager.defaultLocalStoreDataManager.saveHistory();
                                u.setIsRemoved(true);
                                LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
                                TabUpdatesAndDownloads.getInstance().refresh();
                                TabHistory.getInstance().refresh();
                            }

                            @Override
                            public void OnInstallNotComplete(String errorMessage) {
                                ApplicationManager.getInstance().setIsSomethingIsInstalling(false);
                                PanelBottom.getInstance().enableRefreshButton();
                                TabUpdatesAndDownloads.this.updateAllBtnPanels();
                                item.setDownloadStatusText(u.getUpdateDownloadStatusString());
                                ((AbstractTableModel)TabUpdatesAndDownloads.this.treeTable.getModel()).fireTableCellUpdated(row, 4);
                                if (u.getUpdateDownloadStatus() == Update.UpdateDownload.None) {
                                    item.getProgressBar().setValue(0);
                                    ((AbstractTableModel)TabUpdatesAndDownloads.this.treeTable.getModel()).fireTableCellUpdated(row, 5);
                                }
                                LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
                            }
                        });
                        u.launchInstall();
                    }
                }
            });
            item.getBtnInfo().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (row != -1) {
                        int y;
                        int x;
                        TabUpdatesAndDownloads.this.treeTable.changeSelection(row, 0, false, false);
                        InfoDialog dialog = InfoDialog.getInstance();
                        if (Gui.getInstance().isVisible()) {
                            Point p = Gui.getInstance().getLocationOnScreen();
                            x = p.x + Gui.getInstance().getWidth() / 2 - dialog.getWidth() / 2;
                            y = p.y + Gui.getInstance().getHeight() / 2 - dialog.getHeight() / 2;
                        } else {
                            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                            x = d.width / 2 - dialog.getWidth() / 2;
                            y = d.height / 2 - dialog.getHeight() / 2;
                        }
                        dialog.setLocation(x, y);
                        dialog.setVisible(true);
                    }
                }
            });
            this.updateBtnPanelButtons(item, row);
            item.getUpdate().removeAllCustomDownloadEventListeners();
            item.getUpdate().addCustomDownloadEventListener(new Update.CustomDownloadEventListener(){

                @Override
                public void OnDownloadBegin(String guid, String id) {
                    item.setDownloadStatusText(item.getUpdate().getUpdateDownloadStatusString());
                    ((AbstractTableModel)TabUpdatesAndDownloads.this.treeTable.getModel()).fireTableCellUpdated(row, 4);
                    TabUpdatesAndDownloads.this.updateBtnPanelButtons(item, row);
                }

                @Override
                public void OnDownloadProgress(String guid, String id, int percent, int totalSize, String transferRate) {
                    item.getProgressBar().setValue(percent);
                    item.setDownloadSpeedText(String.valueOf(transferRate));
                    ((AbstractTableModel)TabUpdatesAndDownloads.this.treeTable.getModel()).fireTableCellUpdated(row, 5);
                    ((AbstractTableModel)TabUpdatesAndDownloads.this.treeTable.getModel()).fireTableCellUpdated(row, 6);
                }

                @Override
                public void OnDownloadComplete(String guid, String id) {
                    item.setDownloadStatusText(item.getUpdate().getUpdateDownloadStatusString());
                    item.setDownloadSpeedText("");
                    ((AbstractTableModel)TabUpdatesAndDownloads.this.treeTable.getModel()).fireTableCellUpdated(row, 4);
                    ((AbstractTableModel)TabUpdatesAndDownloads.this.treeTable.getModel()).fireTableCellUpdated(row, 6);
                    TabUpdatesAndDownloads.this.updateBtnPanelButtons(item, row);
                    new UpdatesAndDownloads().setDownloadCompleteInHistory(item.getUpdate().getProductGuid(), item.getUpdate().getId());
                    LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
                    TabHistory.getInstance().refresh();
                }

                @Override
                public void OnDownloadError(String guid, String id, String errorMessage) {
                    item.setDownloadStatusText(item.getUpdate().getUpdateDownloadStatusString());
                    ((AbstractTableModel)TabUpdatesAndDownloads.this.treeTable.getModel()).fireTableCellUpdated(row, 4);
                    TabUpdatesAndDownloads.this.updateBtnPanelButtons(item, row);
                }
            });
        }
    }

    private void updateAllBtnPanels() {
        int tableSize = this.treeTable.getTree().getRowCount();
        for (int row = 0; row < tableSize; ++row) {
            Object node = this.treeTable.getTree().getPathForRow(row).getLastPathComponent();
            if (!(node instanceof DataTree.ItemUpdate)) continue;
            this.updateBtnPanelButtons((DataTree.ItemUpdate)node, row);
        }
    }

    private void updateBtnPanelButtons(DataTree.ItemUpdate item, int row) {
        JPanel panel = item.getBtnPanel();
        JButton btnPause = item.getBtnPause();
        JButton btnResume = item.getBtnStartResume();
        JButton btnCancel = item.getBtnCancel();
        JButton btnInstall = item.getBtnInstall();
        JButton btnInfo = item.getBtnInfo();
        panel.removeAll();
        panel.setOpaque(true);
        Update.UpdateDownload status = item.getUpdate().getUpdateDownloadStatus();
        boolean isAllowToDownload = item.getUpdate().getIsAllowToDownload();
        if (isAllowToDownload) {
            switch (status) {
                case DownloadingBegin: {
                    break;
                }
                case Downloading: {
                    panel.add(btnPause);
                    panel.add(btnCancel);
                    break;
                }
                case Paused: {
                    btnResume.setIcon(SumImages.imgResumeButton);
                    btnResume.setToolTipText(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_resume"));
                    panel.add(btnResume);
                    panel.add(btnCancel);
                    break;
                }
                case Downloaded: {
                    if (!ApplicationManager.getInstance().getIsSomethingIsInstalling()) {
                        btnInstall.setEnabled(true);
                    } else {
                        btnInstall.setEnabled(false);
                    }
                    panel.add(btnInstall);
                    break;
                }
                case Installing: {
                    btnInstall.setEnabled(false);
                    panel.add(btnInstall);
                    break;
                }
                case Error: {
                    btnResume.setIcon(SumImages.imgResumeButton);
                    btnResume.setToolTipText(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_resume"));
                    panel.add(btnResume);
                    panel.add(btnCancel);
                    break;
                }
                default: {
                    btnResume.setIcon(SumImages.imgStartButton);
                    btnResume.setToolTipText(Resources.getInstance().getBundle().getString("tab_downloads_popup_item_start"));
                    panel.add(btnResume);
                    break;
                }
            }
        } else {
            panel.add(btnInfo);
        }
        ((AbstractTableModel)this.treeTable.getModel()).fireTableCellUpdated(row, 0);
    }

    private void removeBtnListeners(JButton button) {
        for (ActionListener i : button.getActionListeners()) {
            button.removeActionListener(i);
        }
    }

    private void setTextFieldMaximumWidthByTextWidth(JTextField field) {
        FontMetrics fm = field.getFontMetrics(field.getFont());
        int fieldWidth = fm.stringWidth(field.getText());
        field.setMaximumSize(new Dimension(fieldWidth, field.getPreferredSize().height));
    }

    public void updateDownloadToLabel() {
        this.jtfDownloadDynamic.setText(Settings.defaultSettings.getDefaultDownloadLocation());
        this.setTextFieldMaximumWidthByTextWidth(this.jtfDownloadDynamic);
        this.jtfDownloadDynamic.setCaretPosition(0);
    }

    public void rmi_highlightUpdate(final String guid) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath path = TabUpdatesAndDownloads.this.dataModel.getTreePathForUpdateByGuid(guid);
                if (path != null) {
                    TabUpdatesAndDownloads.this.treeTable.getTree().scrollPathToVisible(path);
                    TabUpdatesAndDownloads.this.treeTable.getTree().setSelectionPath(path);
                    SumLogger.logger.log(Level.INFO, "rmi_highlightUpdate(): highlighted path = {0}", path.toString());
                } else {
                    SumLogger.logger.log(Level.INFO, "rmi_highlightUpdate(): no such guid found in the data tree");
                }
            }
        });
    }

    public void rmi_startDownload(final String guid) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean isUpdateCanBeDownloaded = true;
                Update.UpdateDownload status = Update.UpdateDownload.None;
                TreePath path = TabUpdatesAndDownloads.this.dataModel.getTreePathForUpdateByGuid(guid);
                if (path != null) {
                    Object path_obj = path.getLastPathComponent();
                    if (path_obj instanceof DataTree.ItemUpdate) {
                        status = ((DataTree.ItemUpdate)path_obj).getUpdate().getUpdateDownloadStatus();
                        switch (status) {
                            case Downloading: {
                                isUpdateCanBeDownloaded = false;
                            }
                        }
                        TabUpdatesAndDownloads.this.treeTable.getTree().scrollPathToVisible(path);
                        TabUpdatesAndDownloads.this.treeTable.getTree().setSelectionPath(path);
                        SumLogger.logger.log(Level.INFO, "rmi_startDownload(): highlighted path = {0}", path.toString());
                    }
                    if (TabUpdatesAndDownloads.this.treeTable.getSelectedRow() != -1) {
                        if (isUpdateCanBeDownloaded) {
                            TabUpdatesAndDownloads.this.itemStart.doClick();
                            SumLogger.logger.log(Level.INFO, "rmi_startDownload(): download for the highlighted row is started");
                        } else {
                            SumLogger.logger.log(Level.INFO, "rmi_startDownload(): downloading of such update cannot be started due to it''s status: {0}", (Object)status);
                        }
                    } else {
                        SumLogger.logger.log(Level.INFO, "rmi_startDownload(): internal error: no any row is selected... do nothing");
                    }
                } else {
                    SumLogger.logger.log(Level.INFO, "rmi_startDownload(): no such guid found in the data tree");
                }
            }
        });
    }

    public boolean rmi_serializeUpdateToFile(String guid, String file, boolean retValue) {
        boolean ret = true;
        SumLogger.logger.log(Level.WARNING, "rmi_serializeUpdateToFile(): start");
        TreePath path = this.dataModel.getTreePathForUpdateByGuid(guid);
        if (path != null) {
            Object path_obj = path.getLastPathComponent();
            if (path_obj instanceof DataTree.ItemUpdate) {
                Update u = ((DataTree.ItemUpdate)path_obj).getUpdate();
                try {
                    File f = new File(file);
                    if (f.getParent() != null) {
                        new File(f.getParent()).mkdirs();
                    }
                    f.createNewFile();
                    FileWriter fw = new FileWriter(file);
                    BufferedWriter out = new BufferedWriter(fw);
                    out.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
                    out.write("<ism>\n");
                    String rv = !retValue ? "FAIL" : "SUCCESS";
                    out.write("    <Status>" + rv + "</Status>\n");
                    out.write("    <Update>\n");
                    out.write("        <Id>" + u.getId() + "</Id>\n");
                    out.write("        <Title>" + u.getTitle() + "</Title>\n");
                    out.write("        <DownloadSize>" + u.getDownloadSizeStr() + "</DownloadSize>\n");
                    out.write("        <DownloadURL>" + u.getDownloadLink() + "</DownloadURL>\n");
                    out.write("        <IsNew>" + u.getIsNew() + "</IsNew>\n");
                    out.write("    </Update>\n");
                    out.write("</ism>\n");
                    out.close();
                    fw.close();
                }
                catch (IOException ex) {
                    ret = false;
                    SumLogger.logger.log(Level.INFO, "rmi_serializeUpdateToFile(): cannot create output file for product '{0}': {1}", new Object[]{file, ex.toString()});
                }
            } else {
                SumLogger.logger.log(Level.INFO, "rmi_serializeUpdateToFile(): internal error: last path object is not object of Update: {0}", path_obj.getClass().toString());
            }
        } else {
            SumLogger.logger.log(Level.INFO, "rmi_serializeUpdateToFile(): no such guid found in the data tree");
        }
        SumLogger.logger.log(Level.WARNING, "rmi_serializeUpdateToFile(): end");
        return ret;
    }

    private void selectionHandler() {
        Object tn = this.treeTable.getTree().getLastSelectedPathComponent();
        if (tn instanceof DataTree.ItemUpdate) {
            this.pane.getOutput().setDocument(this.pane.getOutput().getEditorKit().createDefaultDocument());
            this.pane.getOutput().setText(((DataTree.ItemUpdate)tn).getUpdate().getDescription());
            this.pane.getOutput().setCaretPosition(0);
            this.jlbMoreInfo.setVisible(true);
            String link = ((DataTree.ItemUpdate)tn).getUpdate().getAdditionalInfoLink();
            if (!link.isEmpty()) {
                this.url.delete(0, this.url.length());
                this.url.append(link);
            }
            this.jlbProductName.setText(((DataTree.ItemUpdate)tn).getUpdate().getTitle());
        } else {
            this.clearPane();
            this.jlbMoreInfo.setVisible(false);
        }
    }

    private void clearPane() {
        this.treeTable.getSelectionModel().clearSelection();
        this.pane.getOutput().setDocument(this.pane.getOutput().getEditorKit().createDefaultDocument());
        this.pane.clean();
        this.jlbProductName.setText("");
    }
}

