/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.UsageStatisticsManager;
import com.intel.ism.core.data.LicenseMessage;
import com.intel.ism.core.data.Product;
import com.intel.ism.core.objects.LicenseMessageData;
import com.intel.ism.gui.ActivationToolDialog;
import com.intel.ism.gui.Common;
import com.intel.ism.gui.OutputPane;
import com.intel.ism.gui.SumImages;
import com.intel.ism.gui.TabPanel;
import com.intel.ism.gui.controllers.FontManager;
import com.intel.ism.gui.treetable.DataTree;
import com.intel.ism.gui.treetable.TreeTable;
import com.intel.ism.gui.treetable.TreeTableLicenses;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public final class TabLicenses
extends JPanel {
    private static TabLicenses tabActivations;
    private TreeTable treeTable;
    private DataTree dataModel;
    private final JLabel jlbActivation = new JLabel(Resources.getInstance().getLabelTabActivations(), SumImages.imgInfo, 2);
    private final JLabel jlbSN = new JLabel();
    private final JLabel jlbProductName = new JLabel();
    private final OutputPane pane = new OutputPane();
    private final JLabel jlbMoreInfo = new JLabel(Resources.getInstance().getBundle().getString("tab_activation_more_info_label"));
    private StringBuilder url = new StringBuilder();
    private int selRow = -1;
    private static final int TABLE_PRODUCT_COLUMN_INDEX = 0;
    private static final int TABLE_STATUS_COLUMN_INDEX = 1;
    private static final int TABLE_ACTION_COLUMN_INDEX = 2;
    private static final int TABLE_ACTIVATE_COLUMN_INDEX = 3;
    private String statusCFU = Resources.getInstance().getBundle().getString("tab_activation_no_activation_text");

    private TabLicenses() {
        this.jlbMoreInfo.setVisible(false);
        this.jlbMoreInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Common.openBrowser(TabLicenses.this.url.toString());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TabLicenses.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TabLicenses.this.setCursor(new Cursor(0));
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tabNoLicenses();
    }

    public static synchronized TabLicenses getInstance() {
        if (tabActivations == null) {
            tabActivations = new TabLicenses();
        }
        return tabActivations;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void setCFUStatusStr(String status) {
        this.statusCFU = status;
    }

    public void refresh() {
        this.dataModel = new DataTree(LicenseMessageData.class);
        int msgCount = this.dataModel.getLeafCount();
        TabPanel.getInstance().setActivationsTabTitle(String.valueOf(msgCount));
        if (msgCount > 0) {
            this.tabFoundActivations();
        } else {
            this.tabNoLicenses();
        }
        this.updateUI();
    }

    private void tabNoLicenses() {
        this.removeAll();
        JLabel jlbImg = new JLabel(SumImages.imgInfo, 2);
        JEditorPane jepNoLicenses = new JEditorPane("text/html", this.statusCFU);
        jepNoLicenses.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jepNoLicenses.setEditable(false);
        jepNoLicenses.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent he) {
                if (Desktop.isDesktopSupported()) {
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(he.getEventType())) {
                        try {
                            Desktop.getDesktop().browse(he.getURL().toURI());
                        }
                        catch (Exception ex) {
                            SumLogger.logger.log(Level.WARNING, "tabNoLicenses(): exception during open default browser {0}", ex.getMessage());
                        }
                    }
                } else if (HyperlinkEvent.EventType.ACTIVATED.equals(he.getEventType())) {
                    Common.openBrowser(he.getURL().toString());
                }
            }
        });
        GridBagLayout gbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbag.setConstraints(jlbImg, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbag.setConstraints(jepNoLicenses, gbc);
        this.setLayout(gbag);
        this.add(jlbImg);
        this.add(jepNoLicenses);
    }

    private void tabFoundActivations() {
        TreeTableLicenses treeTableLicensesData = new TreeTableLicenses(this.dataModel.getRoot());
        this.treeTable = new TreeTable(treeTableLicensesData, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TabLicenses.this.selectionHandler();
                return null;
            }
        });
        this.treeTable.setRowHeight(SumImages.imgStatusLicense.getIconHeight() + 4);
        this.setTreeTableMouseListeners();
        int[] columnsToFit = new int[]{0, 1, 2, 3};
        Common.fitColumnsWidth(this.treeTable, columnsToFit);
        this.treeTable.getColumnModel().getColumn(2).setResizable(false);
        this.treeTable.getColumnModel().getColumn(3).setResizable(false);
        this.removeAll();
        this.jlbSN.setFont(FontManager.getBoldFont());
        this.jlbProductName.setFont(FontManager.getBoldFont());
        if (this.selRow < this.treeTable.getTree().getRowCount() && this.selRow >= 0) {
            LicenseMessageData lmdAtRow = ((DataTree.ItemLicense)this.treeTable.getTree().getPathForRow(this.selRow).getLastPathComponent()).getLicenseMessageData();
            this.jlbSN.setText(Resources.getInstance().getBundle().getString("tab_activation_lbl_serial_number") + " " + lmdAtRow.getSerialNumber() + " ");
            this.jlbProductName.setText(lmdAtRow.getTitle() + " ");
            this.pane.clean();
            this.pane.getOutput().setText(lmdAtRow.getDescription());
            this.pane.getOutput().setCaretPosition(0);
        } else {
            this.jlbSN.setText("");
            this.jlbProductName.setText("");
            this.pane.clean();
            this.jlbMoreInfo.setVisible(false);
        }
        this.jlbActivation.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JScrollPane scrollTable = new JScrollPane(this.treeTable, 20, 30);
        scrollTable.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        scrollTable.getViewport().setBackground(Color.WHITE);
        GridBagLayout gbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(10, 5, 5, 5);
        gbag.setConstraints(this.jlbProductName, gbc);
        gbc.anchor = 13;
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(5, 5, 5, 10);
        gbag.setConstraints(this.jlbSN, gbc);
        JPanel jpnSN = new JPanel(gbag);
        jpnSN.add(this.jlbProductName);
        jpnSN.add(this.jlbSN);
        JScrollPane scrollOutput = new JScrollPane(this.pane.getOutput()){

            @Override
            public Color getBackground() {
                return Color.WHITE;
            }
        };
        scrollOutput.setBorder(BorderFactory.createEmptyBorder(0, 12, 5, 5));
        JPanel jpnMoreInfo = new JPanel(new BorderLayout());
        jpnMoreInfo.add((Component)this.jlbMoreInfo, "East");
        jpnMoreInfo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JPanel jpnOutput = new JPanel(new BorderLayout());
        jpnOutput.add((Component)jpnSN, "North");
        jpnOutput.add((Component)scrollOutput, "Center");
        jpnOutput.add((Component)jpnMoreInfo, "South");
        jpnOutput.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        JSplitPane splitPane = new JSplitPane(0, (Component)scrollTable, (Component)jpnOutput){

            @Override
            public double getResizeWeight() {
                return 0.3;
            }

            @Override
            public Border getBorder() {
                return BorderFactory.createEmptyBorder();
            }
        };
        this.setLayout(new BorderLayout());
        this.add((Component)this.jlbActivation, "North");
        this.add((Component)splitPane, "Center");
    }

    private void setTreeTableMouseListeners() {
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = TabLicenses.this.treeTable.rowAtPoint(e.getPoint());
                if (row != -1) {
                    switch (TabLicenses.this.treeTable.getColumnModel().getColumnIndexAtX(e.getX())) {
                        case 2: {
                            boolean shouldDoAnything;
                            Object tn;
                            if (row >= TabLicenses.this.treeTable.getTree().getRowCount() || !((tn = TabLicenses.this.treeTable.getTree().getLastSelectedPathComponent()) instanceof DataTree.ItemLicense)) break;
                            LicenseMessageData lmd = ((DataTree.ItemLicense)tn).getLicenseMessageData();
                            LicenseMessage.EMessageStatus msgStatus = lmd.getMessageStatus();
                            boolean bl = shouldDoAnything = !msgStatus.equals((Object)LicenseMessage.EMessageStatus.OK) && !msgStatus.equals((Object)LicenseMessage.EMessageStatus.Unknown);
                            if (!shouldDoAnything) break;
                            UsageStatisticsManager.getInstance().increaseActionRenew();
                            String actionURL = Resources.getInstance().getLinkRenewDest();
                            if (lmd.getMessageType().equals((Object)LicenseMessage.EMessageType.Subscription) && !lmd.getSerialNumber().equals(Product.UndefinedProperty)) {
                                actionURL = String.format(Resources.getInstance().getLinkRenewbySNDest(), lmd.getSerialNumber());
                            }
                            Common.openBrowser(actionURL);
                            break;
                        }
                        case 3: {
                            boolean shouldDoAnything;
                            Object tn;
                            if (row >= TabLicenses.this.treeTable.getTree().getRowCount() || !((tn = TabLicenses.this.treeTable.getTree().getLastSelectedPathComponent()) instanceof DataTree.ItemLicense) || !(shouldDoAnything = true)) break;
                            UsageStatisticsManager.getInstance().increaseActionActivate();
                            ActivationToolDialog.getInstance().refresh(((DataTree.ItemLicense)tn).getLicenseMessageData());
                        }
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int row = TabLicenses.this.treeTable.rowAtPoint(e.getPoint());
                if (row < TabLicenses.this.treeTable.getTree().getRowCount() && row != -1) {
                    Object tn = TabLicenses.this.treeTable.getTree().getLastSelectedPathComponent();
                    if (tn instanceof DataTree.ItemLicense) {
                        TabLicenses.this.selRow = row;
                    }
                } else {
                    TabLicenses.this.pane.clean();
                    TabLicenses.this.treeTable.getSelectionModel().clearSelection();
                    TabLicenses.this.jlbSN.setText("");
                    TabLicenses.this.jlbProductName.setText("");
                    TabLicenses.this.selRow = -1;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TabLicenses.this.setCursor(new Cursor(0));
            }
        });
        this.treeTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Object tn;
                int row = TabLicenses.this.treeTable.rowAtPoint(e.getPoint());
                int column = TabLicenses.this.treeTable.columnAtPoint(e.getPoint());
                boolean isCursorInsideRightColumn = column == 2 || column == 3;
                boolean isCursorInsideData = row < TabLicenses.this.treeTable.getTree().getRowCount() && row != -1;
                boolean shouldChangeCursor = false;
                if (isCursorInsideData && (tn = TabLicenses.this.treeTable.getTree().getPathForRow(row).getLastPathComponent()) instanceof DataTree.ItemLicense) {
                    if (column == 3) {
                        shouldChangeCursor = true;
                    } else {
                        boolean bl = shouldChangeCursor = !((DataTree.ItemLicense)tn).getLicenseMessageData().getMessageStatus().equals((Object)LicenseMessage.EMessageStatus.OK);
                    }
                }
                if (isCursorInsideData && isCursorInsideRightColumn && shouldChangeCursor) {
                    TabLicenses.this.setCursor(new Cursor(12));
                } else {
                    TabLicenses.this.setCursor(new Cursor(0));
                }
            }
        });
    }

    public void selectionHandler() {
        Object tn = this.treeTable.getTree().getLastSelectedPathComponent();
        if (tn instanceof DataTree.ItemLicense) {
            this.jlbMoreInfo.setVisible(true);
            this.url.delete(0, this.url.length());
            this.url.append(((DataTree.ItemLicense)tn).getLicenseMessageData().getAdditionalInfoLink());
            this.pane.getOutput().setText(((DataTree.ItemLicense)tn).getLicenseMessageData().getDescription());
            this.pane.getOutput().setCaretPosition(0);
            this.jlbSN.setText(Resources.getInstance().getBundle().getString("tab_activation_lbl_serial_number") + " " + ((DataTree.ItemLicense)tn).getLicenseMessageData().getSerialNumber());
            this.jlbProductName.setText(((DataTree.ItemLicense)tn).getLicenseMessageData().getTitle());
        } else {
            this.clearPane();
            this.jlbMoreInfo.setVisible(false);
        }
    }

    private void clearPane() {
        this.treeTable.getSelectionModel().clearSelection();
        this.pane.getOutput().setDocument(this.pane.getOutput().getEditorKit().createDefaultDocument());
        this.pane.clean();
        this.jlbProductName.setText("");
    }
}

