/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.OutputPane;
import com.intel.ism.gui.controllers.FontManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TabHistoryItemDetails
extends JDialog {
    private static TabHistoryItemDetails dialog;
    private final JPanel panel = new JPanel();
    private final JLabel jlbTitle = new JLabel();
    private final JLabel jlbDate = new JLabel();
    private final JLabel jlbStatus = new JLabel();
    private final OutputPane paneOutput = new OutputPane();
    private final JButton btnClose = new JButton(Resources.getInstance().getBundle().getString("tab_history_item_details_btn_close"));
    private final String strDate = Resources.getInstance().getBundle().getString("tab_history_item_details_lbl_date");
    private final String strStatus = Resources.getInstance().getBundle().getString("tab_history_item_details_lbl_status");
    private static final int DIALOG_WIDTH = 500;
    private static final int DIALOG_HEIGHT = 500;

    private TabHistoryItemDetails() {
        super(Gui.getInstance(), Resources.getInstance().getProductName(), true);
        this.fillPanel();
        this.add((Component)this.panel, "Center");
        this.setSize(500, 500);
        this.setMinimumSize(new Dimension(500, 500));
    }

    public static synchronized TabHistoryItemDetails getInstance() {
        if (dialog == null) {
            dialog = new TabHistoryItemDetails();
        }
        return dialog;
    }

    public void refresh(String title, String date, String status, String content) {
        this.jlbTitle.setText("<html>" + title + "</html>");
        this.jlbDate.setText(this.strDate + " " + date);
        this.jlbStatus.setText(this.strStatus + " " + status);
        this.paneOutput.getOutput().setText(content);
        this.paneOutput.getOutput().setCaretPosition(0);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void fillPanel() {
        this.jlbTitle.setFont(FontManager.getBoldFont());
        this.jlbDate.setFont(FontManager.getBoldFont());
        this.jlbStatus.setFont(FontManager.getBoldFont());
        this.btnClose.setFocusPainted(false);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        JScrollPane scrollOutput = new JScrollPane(this.paneOutput.getOutput());
        scrollOutput.setBorder(BorderFactory.createEmptyBorder());
        scrollOutput.setVerticalScrollBarPolicy(20);
        GridBagLayout gbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 10, 15, 5);
        gbag.setConstraints(this.jlbTitle, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(5, 10, 0, 5);
        gbag.setConstraints(this.jlbDate, gbc);
        ++gbc.gridy;
        gbag.setConstraints(this.jlbStatus, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 20, 0, 5);
        gbag.setConstraints(scrollOutput, gbc);
        GridBagLayout gbagBottomPanel = new GridBagLayout();
        GridBagConstraints gbcBottomPanel = new GridBagConstraints();
        gbcBottomPanel.weightx = 1.0;
        gbcBottomPanel.weighty = 1.0;
        gbcBottomPanel.anchor = 13;
        gbcBottomPanel.insets = new Insets(5, 0, 5, 5);
        gbagBottomPanel.setConstraints(this.btnClose, gbcBottomPanel);
        JPanel panelBtnClose = new JPanel(gbagBottomPanel);
        panelBtnClose.add(this.btnClose);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 0, 0);
        gbag.setConstraints(panelBtnClose, gbc);
        this.panel.setLayout(gbag);
        this.panel.add(this.jlbTitle);
        this.panel.add(this.jlbDate);
        this.panel.add(this.jlbStatus);
        this.panel.add(scrollOutput);
        this.panel.add(panelBtnClose);
    }
}

