/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.core.data.LocalHistoryData;
import com.intel.ism.core.data.LocalHistoryItem;
import com.intel.ism.core.data.LocalStoreDataManager;
import com.intel.ism.gui.SumImages;
import com.intel.ism.gui.TabHistoryItemDetails;
import com.intel.ism.gui.TableModelHistory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public final class TabHistory
extends JPanel {
    private static TabHistory tabHistory;
    private final JTable table;
    private final JLabel jlbHistory = new JLabel(Resources.getInstance().getLabelTabHistory(), SumImages.imgInfo, 2);
    private LocalHistoryData listData = new LocalHistoryData();
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final JMenuItem itemViewDetails = new JMenuItem(Resources.getInstance().getBundle().getString("tab_history_popup_item_view_details"));
    private final JButton btnRemoveAll = new JButton(Resources.getInstance().getBundle().getString("tab_history_remove_all_btn"));
    private static final int TABLE_TITLE_COLUMN_INDEX = 0;
    private static final int TABLE_STATUS_COLUMN_INDEX = 1;
    private static final int TABLE_ACTION_DATE_COLUMN_INDEX = 2;
    private static final int TABLE_TYPE_COLUMN_INDEX = 3;

    public static synchronized TabHistory getInstance() {
        if (tabHistory == null) {
            tabHistory = new TabHistory();
        }
        return tabHistory;
    }

    private TabHistory() {
        this.table = new JTable(){

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int rowIdx = this.rowAtPoint(p);
                int columnIdx = this.columnAtPoint(p);
                if (columnIdx == 0 && rowIdx < TabHistory.this.table.getRowCount() && rowIdx != -1) {
                    tip = TabHistory.this.listData.getHistoryData().get(rowIdx).getTitle();
                }
                return tip;
            }
        };
        this.table.setShowGrid(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.table.setFillsViewportHeight(true);
        this.popupMenu.add(this.itemViewDetails);
        this.itemViewDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TabHistory.this.table.getSelectedRow();
                if (row != -1) {
                    TabHistory.this.showItemDetailsDialog(row);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = TabHistory.this.table.rowAtPoint(e.getPoint());
                if (e.getClickCount() == 2 && row != -1) {
                    TabHistory.this.showItemDetailsDialog(row);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int row = TabHistory.this.table.rowAtPoint(e.getPoint());
                TabHistory.this.table.changeSelection(row, 0, false, false);
                if (row < TabHistory.this.listData.getHistoryDataCount() && TabHistory.this.table.isCellSelected(row, 0)) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int row = TabHistory.this.table.rowAtPoint(e.getPoint());
                TabHistory.this.table.changeSelection(row, 0, false, false);
                if (row < TabHistory.this.listData.getHistoryDataCount() && TabHistory.this.table.isCellSelected(row, 0)) {
                    this.showPopup(e);
                }
            }

            public void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TabHistory.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.btnRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabHistory.this.listData.removeAll();
                LocalStoreDataManager.defaultLocalStoreDataManager.saveHistory();
                TabHistory.this.refresh();
            }
        });
        this.btnRemoveAll.setEnabled(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void refresh() {
        int[] columnsToFit;
        this.listData = LocalStoreDataManager.defaultLocalStoreDataManager.getHistory();
        this.table.setModel(new TableModelHistory(this.listData));
        int rowCount = this.listData.getHistoryDataCount();
        for (int col : columnsToFit = new int[]{1, 2, 3}) {
            int width = 10;
            int maxWidth = 50;
            for (int row = 0; row < rowCount; ++row) {
                TableCellRenderer r = this.table.getCellRenderer(row, col);
                Component c = r.getTableCellRendererComponent(this.table, this.table.getValueAt(row, col), false, false, row, col);
                width = c.getPreferredSize().width;
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            this.table.getColumnModel().getColumn(col).setMinWidth(maxWidth + 10);
            this.table.getColumnModel().getColumn(col).setMaxWidth(maxWidth + 10);
        }
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setResizable(false);
        }
        this.removeAll();
        this.jlbHistory.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.btnRemoveAll.setEnabled(rowCount != 0);
        JScrollPane scrollPaneTable = new JScrollPane(this.table);
        scrollPaneTable.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        scrollPaneTable.getViewport().setBackground(Color.WHITE);
        JPanel jpnRemoveAll = new JPanel(new BorderLayout());
        jpnRemoveAll.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        jpnRemoveAll.add((Component)this.btnRemoveAll, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)this.jlbHistory, "North");
        this.add((Component)scrollPaneTable, "Center");
        this.add((Component)jpnRemoveAll, "South");
        this.updateUI();
    }

    private void showItemDetailsDialog(int row) {
        LocalHistoryItem historyItem = this.listData.getHistoryData().get(row);
        TabHistoryItemDetails.getInstance().refresh(historyItem.getTitle(), historyItem.getDate(), historyItem.getStatus(), historyItem.getDescription());
    }
}

