/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.core.SumLogger;
import com.intel.ism.gui.AboutDialog;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.SumImages;
import com.intel.ism.gui.TabPanel;
import com.intel.ism.gui.controllers.ApplicationManager;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class SumTrayIcon {
    private static SumTrayIcon sumTrayIcon;
    private PopupMenu popupMenu = new PopupMenu();
    private MenuItem openItem = new MenuItem(Resources.getInstance().getBundle().getString("tray_menu_item_open"));
    private MenuItem settingsItem = new MenuItem(Resources.getInstance().getBundle().getString("tray_menu_item_settings"));
    private MenuItem aboutItem = new MenuItem(Resources.getInstance().getBundle().getString("tray_menu_item_about"));
    private MenuItem exitItem = new MenuItem(Resources.getInstance().getBundle().getString("tray_menu_item_exit"));
    private TrayIcon trayIcon;
    private boolean trayIconCreated = false;

    private SumTrayIcon() {
    }

    public static synchronized SumTrayIcon getInstance() {
        if (sumTrayIcon == null) {
            sumTrayIcon = new SumTrayIcon();
        }
        return sumTrayIcon;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public TrayIcon getTrayIcon() {
        return this.trayIcon;
    }

    public boolean createTrayIcon() {
        if (!this.trayIconCreated) {
            if (SystemTray.isSupported()) {
                SystemTray systemTray = SystemTray.getSystemTray();
                ActionListener exitListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!ApplicationManager.getInstance().getIsSomethingIsInstalling()) {
                            ApplicationManager.getInstance().exitAction(0);
                        } else {
                            SumLogger.logger.log(Level.INFO, "trayAction(): trying to exit during active installation ... skipping exit");
                            String msg = String.format(Resources.getInstance().getBundle().getString("install_progress_exit_during_install_warning"), ApplicationManager.getInstance().getInstallingUpdateTitle());
                            JFrame frame = new JFrame();
                            frame.setIconImage(SumImages.imgAppIcon32x32.getImage());
                            JOptionPane.showMessageDialog(frame, msg, Resources.getInstance().getProductName(), 2);
                        }
                    }
                };
                ActionListener openListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Gui.getInstance().setVisible(true);
                        if (AboutDialog.getInstance().isVisible()) {
                            AboutDialog.refresh();
                        }
                    }
                };
                ActionListener settingsListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Gui.getInstance().setVisible(true);
                        TabPanel.getInstance().setSelectedIndex(5);
                        if (AboutDialog.getInstance().isVisible()) {
                            AboutDialog.refresh();
                        }
                    }
                };
                ActionListener aboutListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int y;
                        int x;
                        Gui.getInstance().setVisible(true);
                        AboutDialog dialog = AboutDialog.getInstance();
                        if (Gui.getInstance().isVisible()) {
                            Point p = Gui.getInstance().getLocationOnScreen();
                            x = p.x + Gui.getInstance().getWidth() / 2 - dialog.getWidth() / 2;
                            y = p.y + Gui.getInstance().getHeight() / 2 - dialog.getHeight() / 2;
                        } else {
                            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                            x = d.width / 2 - dialog.getWidth() / 2;
                            y = d.height / 2 - dialog.getHeight() / 2;
                        }
                        dialog.setLocation(x, y);
                        dialog.setVisible(false);
                        dialog.setVisible(true);
                    }
                };
                this.openItem.addActionListener(openListener);
                this.popupMenu.add(this.openItem);
                this.popupMenu.addSeparator();
                this.settingsItem.addActionListener(settingsListener);
                this.popupMenu.add(this.settingsItem);
                this.popupMenu.addSeparator();
                this.aboutItem.addActionListener(aboutListener);
                this.popupMenu.add(this.aboutItem);
                this.popupMenu.addSeparator();
                this.exitItem.addActionListener(exitListener);
                this.popupMenu.add(this.exitItem);
                this.trayIcon = new TrayIcon(SumImages.imgAppIcon32x32.getImage(), Resources.getInstance().getProductName(), this.popupMenu);
                this.trayIcon.setImageAutoSize(true);
                this.trayIcon.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            Gui.getInstance().setVisible(true);
                            if (AboutDialog.getInstance().isVisible()) {
                                AboutDialog.refresh();
                            }
                        }
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }
                });
                this.trayIcon.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TabPanel.getInstance().setSelectedIndex(ApplicationManager.getInstance().getTrayNotificationManager().getTabToShowIndx());
                        Gui.getInstance().setVisible(true);
                    }
                });
                try {
                    systemTray.add(this.trayIcon);
                    this.trayIconCreated = true;
                }
                catch (AWTException ex) {
                    SumLogger.logger.log(Level.SEVERE, "Exception: {0}\nStacktrace:\n{1}", new Object[]{ex, Arrays.toString(ex.getStackTrace())});
                }
            } else {
                Gui.getInstance().setDefaultCloseOperation(3);
            }
        }
        return this.trayIconCreated;
    }

    public void disable() {
        this.aboutItem.setEnabled(false);
        this.exitItem.setEnabled(false);
        this.settingsItem.setEnabled(false);
    }

    public void enable() {
        this.aboutItem.setEnabled(true);
        this.exitItem.setEnabled(true);
        this.settingsItem.setEnabled(true);
    }
}

