/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.gui.Common;
import com.intel.ism.gui.PanelBottom;
import com.intel.ism.gui.controllers.ApplicationManager;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;

public final class SumTimer {
    private static SumTimer sumTimer;
    private Timer timer;
    private Calendar nextScheduledCFUDate = null;

    private SumTimer() {
    }

    public static synchronized SumTimer getInstance() {
        if (sumTimer == null) {
            sumTimer = new SumTimer();
        }
        return sumTimer;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void updateTimer() {
        Settings.ECFUMode CFUmode = Settings.defaultSettings.getCheckingForUpdateMode();
        if (CFUmode != Settings.ECFUMode.AUTO) {
            return;
        }
        if (null != this.timer) {
            this.timer.cancel();
        }
        this.nextScheduledCFUDate = this.getNextPlanningCFUDate();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new SumTimerTask(), this.nextScheduledCFUDate.getTime());
    }

    private Calendar getNextPlanningCFUDate() {
        return this.getNextPlanningCFUDate(Settings.defaultSettings.getCheckingForUpdateAutoMode());
    }

    public Calendar getNextPlanningCFUDate(Settings.ECFUAutoMode mode) {
        Calendar calNext = Calendar.getInstance();
        try {
            calNext.setTime(Common.getDateTimeFormat().parse(Settings.defaultSettings.getLastCheckForUpdateDate()));
        }
        catch (ParseException ex) {
            calNext.setTime(new Date());
            SumLogger.logger.log(Level.WARNING, "getNextPlanningCFUDate(): date ({0}) parse exception: {1}", new Object[]{Settings.defaultSettings.getLastCheckForUpdateDate(), ex.toString()});
        }
        switch (mode) {
            case EVERYDAY: {
                calNext.add(7, 1);
                SumLogger.logger.info("getNextCFUDate(): updating timer schedule: + 1 day from now");
                break;
            }
            case EVERYWEEK: {
                calNext.add(4, 1);
                SumLogger.logger.info("getNextCFUDate(): updating timer schedule: + 1 week from now");
                break;
            }
            default: {
                calNext.add(2, 1);
                SumLogger.logger.info("getNextCFUDate(): updating timer schedule: + 1 month from now");
            }
        }
        return calNext;
    }

    public Calendar getNextScheduledCFUDate() {
        return this.nextScheduledCFUDate;
    }

    public class SumTimerTask
    extends TimerTask {
        @Override
        public void run() {
            if (!ApplicationManager.getInstance().isCheckForUpdatesRunning()) {
                SumLogger.logger.info("sum timer task: running check-for-updates...");
                PanelBottom.getInstance().btnCheckForUpdatesClick();
            }
            if (SumTimer.this.timer != null) {
                SumTimer.this.timer.cancel();
            }
        }
    }
}

