/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.Tools;
import com.intel.ism.core.UsageStatisticsManager;
import com.intel.ism.core.data.ErrorNum;
import com.intel.ism.core.objects.LicenseMessages;
import com.intel.ism.core.objects.UpdatesAndDownloads;
import com.intel.ism.gui.Common;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.SumTimer;
import com.intel.ism.gui.SumTrayIcon;
import com.intel.ism.gui.TabHistory;
import com.intel.ism.gui.TabLicenses;
import com.intel.ism.gui.TabMessages;
import com.intel.ism.gui.TabPanel;
import com.intel.ism.gui.TabSettings;
import com.intel.ism.gui.TabUpdatesAndDownloads;
import com.intel.ism.gui.controllers.ApplicationManager;
import com.intel.ism.gui.controllers.TrayNotificationManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public final class PanelBottom
extends JPanel {
    private static PanelBottom bottomPanel;
    private JButton btnCheckForUpdates;
    private JLabel label = new JLabel();

    public static synchronized PanelBottom getInstance() {
        if (bottomPanel == null) {
            bottomPanel = new PanelBottom();
        }
        return bottomPanel;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private PanelBottom() {
        this.setBorder(BorderFactory.createEtchedBorder(null, Color.black));
        this.setBackground(Color.LIGHT_GRAY);
        this.btnCheckForUpdates = new JButton(Resources.getInstance().getBtnCheckForUpdates());
        this.btnCheckForUpdates.setFocusPainted(false);
        this.btnCheckForUpdates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsageStatisticsManager.getInstance().increaseActionRefresh();
                PanelBottom.this.btnCheckForUpdatesClick();
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLabel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "West");
        this.add((Component)this.btnCheckForUpdates, "East");
    }

    public final void setLabel() {
        String lastUpdateDate = Settings.defaultSettings.getLastCheckForUpdateDate();
        this.label.setText(Resources.getInstance().getBundle().getString("panel_bottom_most_recent_check_for_updates") + " " + lastUpdateDate);
    }

    public void disableRefreshButton() {
        this.btnCheckForUpdates.setEnabled(false);
    }

    public void enableRefreshButton() {
        this.btnCheckForUpdates.setEnabled(true);
    }

    public void btnCheckForUpdatesClick() {
        this.btnCheckForUpdatesClick("EMPTY", false);
    }

    public void btnCheckForUpdatesClick(final String guid, final boolean flagRemote) {
        SumLogger.logger.log(Level.INFO, "btnCheckForUpdatesClick(): check-for-updates button is clicked (guid = {0})", guid);
        Gui.getInstance().showFindingUpdatesPanel((JPanel)TabPanel.getInstance().getSelectedComponent());
        SumTrayIcon.getInstance().disable();
        this.btnCheckForUpdates.setEnabled(false);
        TabPanel.getInstance().setEnabled(false);
        SwingWorker w = new SwingWorker(){

            protected ErrorNum.EGetDataErrors doInBackground() throws Exception {
                ApplicationManager.getInstance().setAllTabsRefreshed(false);
                boolean skipCFU = false;
                if (flagRemote) {
                    SumLogger.logger.log(Level.INFO, "btnCheckForUpdatesClick(): check if we should skip CFU...");
                    skipCFU = !ApplicationManager.getInstance().checkActionFrequency(Settings.defaultSettings.getLastCheckForUpdateDate());
                    SumLogger.logger.log(Level.INFO, "btnCheckForUpdatesClick(): skipCFU = {0}", skipCFU);
                }
                PanelBottom.this.runRMASender();
                return ApplicationManager.getInstance().runGetAllData(skipCFU);
            }

            @Override
            public void done() {
                if (!this.isCancelled()) {
                    Date now = new Date();
                    Settings.defaultSettings.setLastCheckForUpdateDate(Common.getDateTimeFormat().format(now));
                    try {
                        switch ((ErrorNum.EGetDataErrors)((Object)this.get())) {
                            case NO_IRC_SERVER_CONNECTION: 
                            case NO_FNC_SERVER_CONNECTION: {
                                TabUpdatesAndDownloads.getInstance().setCFUStatusStr(Resources.getInstance().getBundle().getString("tab_downloads_lbl_no_connection"));
                                TabLicenses.getInstance().setCFUStatusStr(Resources.getInstance().getBundle().getString("tab_downloads_lbl_no_connection"));
                                TabMessages.getInstance().setCFUStatusStr(Resources.getInstance().getBundle().getString("tab_downloads_lbl_no_connection"));
                                break;
                            }
                            case UNKNOWN_ERROR: {
                                TabUpdatesAndDownloads.getInstance().setCFUStatusStr(Resources.getInstance().getBundle().getString("tab_downloads_lbl_unknown_error"));
                                TabLicenses.getInstance().setCFUStatusStr(Resources.getInstance().getBundle().getString("tab_downloads_lbl_unknown_error"));
                                TabMessages.getInstance().setCFUStatusStr(Resources.getInstance().getBundle().getString("tab_downloads_lbl_unknown_error"));
                                break;
                            }
                            case SUCCESS: {
                                TabUpdatesAndDownloads.getInstance().setCFUStatusStr(Resources.getInstance().getBundle().getString("tab_downloads_lbl_no_updates"));
                                TabLicenses.getInstance().setCFUStatusStr(Resources.getInstance().getBundle().getString("tab_activation_no_activation_text"));
                                TabMessages.getInstance().setCFUStatusStr(Resources.getInstance().getBundle().getString("label_tab_no_messages"));
                            }
                        }
                    }
                    catch (InterruptedException ex) {
                        SumLogger.logger.log(Level.WARNING, "CFU worker(): done(): exception during setting of the error status: {0}", ex.toString());
                    }
                    catch (ExecutionException ex) {
                        SumLogger.logger.log(Level.WARNING, "CFU worker(): done(): exception during setting of the error status: {0}", ex.toString());
                    }
                } else {
                    TabUpdatesAndDownloads.getInstance().setCFUStatusStr(Resources.getInstance().getBundle().getString("tab_downloads_lbl_no_updates"));
                    TabLicenses.getInstance().setCFUStatusStr(Resources.getInstance().getBundle().getString("tab_activation_no_activation_text"));
                    TabMessages.getInstance().setCFUStatusStr(Resources.getInstance().getBundle().getString("label_tab_no_messages"));
                }
                this.updateAllTabs();
                PanelBottom.this.setLabel();
                PanelBottom.this.btnCheckForUpdates.setEnabled(true);
                TabPanel.getInstance().setEnabled(true);
                SumTrayIcon.getInstance().enable();
                SumTimer.getInstance().updateTimer();
                if (!Gui.getInstance().isVisible()) {
                    TrayNotificationManager.TrayNotification ntf = ApplicationManager.getInstance().getTrayNotificationManager().getNewMessagesTrayNotification(guid, flagRemote);
                    if (ntf != null && !ApplicationManager.getInstance().getTrayNotificationManager().isSkipNotification(ntf)) {
                        SumLogger.logger.log(Level.INFO, "show notification: title = {0}; description = {1}", new Object[]{ntf.title, ntf.description});
                        SumTrayIcon.getInstance().getTrayIcon().displayMessage(ntf.title, ntf.description, TrayIcon.MessageType.INFO);
                    }
                } else {
                    new UpdatesAndDownloads().setAllUpdatesAsShown();
                    new LicenseMessages().setAllLicenseMessagesAsShown();
                }
            }

            private void updateAllTabs() {
                TabUpdatesAndDownloads.getInstance().refresh();
                TabMessages.getInstance().refresh();
                TabLicenses.getInstance().refresh();
                TabSettings.getInstance().refresh();
                TabHistory.getInstance().refresh();
                ApplicationManager.getInstance().setAllTabsRefreshed(true);
            }
        };
        ApplicationManager.getInstance().setWorker(w);
        w.execute();
    }

    private void runRMASender() {
        SumLogger.logger.info("runRMASender(): launching the RMA agent...");
        if (!ApplicationManager.getInstance().checkActionFrequency(Settings.defaultSettings.getLastRMALaunchDate())) {
            SumLogger.logger.info("runRMASender(): skipping...");
        }
        String remotemonagent = "";
        String path_to_jar = ApplicationManager.getInstance().getPathToJar();
        if (Common.isMac()) {
            remotemonagent = path_to_jar + "/bin/universal_mac10/intelremotemonagent";
        } else {
            switch (Tools.getArch()) {
                case IA32: {
                    remotemonagent = path_to_jar + "/bin/ia32/intelremotemonagent";
                    break;
                }
                case INTEL64: {
                    remotemonagent = path_to_jar + "/bin/intel64/intelremotemonagent";
                }
            }
        }
        if (!remotemonagent.isEmpty()) {
            try {
                String[] cmd = new String[]{remotemonagent};
                Runtime.getRuntime().exec(cmd);
                Date now = new Date();
                Settings.defaultSettings.setLastRMALaunchDate(Common.getDateTimeFormat().format(now));
                SumLogger.logger.info("runRMASender(): launched...");
            }
            catch (IOException ex) {
                SumLogger.logger.log(Level.WARNING, "runRMASender(): exception when launching the RMA sender {0}", ex.toString());
            }
        }
    }
}

