/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.SumLogger;
import com.intel.ism.gui.Common;
import java.awt.Desktop;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.logging.Level;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;

public final class OutputPane {
    private final JTextPane jtpOutput;
    private StyledDocument doc;
    private Dimension size = new Dimension(650, 270);

    public OutputPane() {
        this.jtpOutput = new JTextPane();
        this.jtpOutput.getAccessibleContext().setAccessibleName("outputPane");
        this.jtpOutput.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.jtpOutput.setPreferredSize(this.size);
        this.jtpOutput.setContentType("text/html;charset=UTF-8");
        this.doc = this.jtpOutput.getStyledDocument();
        this.jtpOutput.setEditable(false);
        this.jtpOutput.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent he) {
                if (Desktop.isDesktopSupported()) {
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(he.getEventType())) {
                        try {
                            Desktop.getDesktop().browse(he.getURL().toURI());
                        }
                        catch (Exception ex) {
                            SumLogger.logger.log(Level.WARNING, "tabNoLicenses(): exception during open default browser {0}", ex.getMessage());
                        }
                    }
                } else if (HyperlinkEvent.EventType.ACTIVATED.equals(he.getEventType())) {
                    Common.openBrowser(he.getURL().toString());
                }
            }
        });
    }

    public JTextPane getOutput() {
        return this.jtpOutput;
    }

    public void clean() {
        try {
            this.jtpOutput.setText("");
            this.jtpOutput.setCaretPosition(0);
            this.doc.remove(0, this.doc.getLength());
            this.jtpOutput.setDocument(this.jtpOutput.getEditorKit().createDefaultDocument());
        }
        catch (BadLocationException ex) {
            SumLogger.logger.log(Level.SEVERE, "Exception: {0}\nStacktrace:\n{1}", new Object[]{ex, Arrays.toString(ex.getStackTrace())});
        }
    }
}

