/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.data.Update;
import com.intel.ism.core.objects.UpdatesAndDownloads;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.treetable.DataTree;
import com.intel.ism.gui.treetable.TreeTable;
import com.intel.ism.gui.treetable.TreeTableInterface;
import java.io.File;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public final class Common {
    private static String osName = System.getProperty("os.name").toLowerCase();

    public static DateFormat getDateTimeFormat() {
        return Common.getDateTimeFormat(Locale.getDefault());
    }

    public static DateFormat getDateTimeFormat(Locale locale) {
        return DateFormat.getDateTimeInstance(2, 3, locale);
    }

    public static DateFormat getDateFormat() {
        return Common.getDateFormat(Locale.getDefault());
    }

    public static DateFormat getDateFormat(Locale locale) {
        return DateFormat.getDateInstance(2, locale);
    }

    private Common() {
        throw new AssertionError();
    }

    public static boolean isLinux() {
        return osName.contains("linux");
    }

    public static boolean isMac() {
        return osName.contains("mac");
    }

    public static void openBrowser(String url) {
        Runtime rt = Runtime.getRuntime();
        try {
            if (Common.isLinux()) {
                String[] browsers = new String[]{"firefox", "epiphany", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
                StringBuilder cmd = new StringBuilder();
                for (int i = 0; i < browsers.length; ++i) {
                    cmd.append(i == 0 ? "" : " || ").append(browsers[i]).append(" \"").append(url).append("\" ");
                }
                rt.exec(new String[]{"sh", "-c", cmd.toString()});
            } else if (Common.isMac()) {
                rt.exec("open " + url);
            }
        }
        catch (Exception ex) {
            SumLogger.logger.log(Level.SEVERE, "Exception in open browser: {0}\nStacktrace:\n{1}", new Object[]{ex, Arrays.toString(ex.getStackTrace())});
        }
    }

    public static EFileSystemError checkDownloadDirectory(float curUpdateSpace) {
        String location = Settings.defaultSettings.getDefaultDownloadLocation();
        File downloadLocation = new File(location);
        if (!downloadLocation.exists() && !downloadLocation.mkdirs()) {
            String msg = String.format(Resources.getInstance().getBundle().getString("message_cannot_create_dir"), Settings.defaultSettings.getDefaultDownloadLocation());
            JOptionPane.showMessageDialog(Gui.getInstance(), msg, Resources.getInstance().getProductName(), 0);
            return EFileSystemError.ERR_CANNOT_CREATE_DIR;
        }
        if (!downloadLocation.canWrite()) {
            String msg = String.format(Resources.getInstance().getBundle().getString("message_directory_is_not_writable_for_download"), Settings.defaultSettings.getDefaultDownloadLocation());
            JOptionPane.showMessageDialog(Gui.getInstance(), msg, Resources.getInstance().getProductName(), 0);
            return EFileSystemError.ERR_DIR_IS_NOT_WRITABLE;
        }
        float neededSpace = curUpdateSpace;
        List<Update> downloads = new UpdatesAndDownloads().getUpdatesAndDownloadsList();
        for (Update u : downloads) {
            if (u.getUpdateDownloadStatus() != Update.UpdateDownload.Downloading) continue;
            neededSpace += u.getDownloadSize();
        }
        float freeSpace = (float)new File(location).getUsableSpace() / 1024.0f;
        if (neededSpace > freeSpace) {
            String msg = String.format(Resources.getInstance().getNoEnoughSpaceMessage(), Settings.defaultSettings.getDefaultDownloadLocation());
            JOptionPane.showMessageDialog(Gui.getInstance(), msg, Resources.getInstance().getProductName(), 0);
            return EFileSystemError.ERR_NOT_ENOUGH_SPACE;
        }
        return EFileSystemError.ERR_OK;
    }

    public static void fitColumnsWidth(TreeTable treeTable, int[] columns) {
        int rowCount = treeTable.getTree().getRowCount();
        for (int col : columns) {
            int width = 10;
            int maxWidth = 50;
            for (int row = 0; row < rowCount; ++row) {
                Object node;
                if (treeTable.getColumnClass(col) == TreeTableInterface.class && (node = treeTable.getTree().getPathForRow(row).getLastPathComponent()) instanceof DataTree.Group || !(treeTable.getValueAt(row, col) instanceof JLabel) || (width = ((JLabel)treeTable.getValueAt((int)row, (int)col)).getPreferredSize().width) <= maxWidth) continue;
                maxWidth = width;
            }
            treeTable.getColumnModel().getColumn(col).setPreferredWidth(maxWidth + 30);
        }
    }

    public static enum EFileSystemError {
        ERR_OK,
        ERR_NOT_ENOUGH_SPACE,
        ERR_DIR_IS_NOT_WRITABLE,
        ERR_CANNOT_CREATE_DIR;

    }
}

