/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.gui;

import com.intel.ism.core.Resources;
import com.intel.ism.gui.Gui;
import com.intel.ism.gui.SumImages;
import com.intel.ism.gui.controllers.ApplicationManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class AboutDialog
extends JDialog {
    private static JPanel panel = new JPanel();
    private static AboutDialog dialog;
    private static String productName;

    public static synchronized AboutDialog getInstance() {
        if (dialog == null) {
            dialog = new AboutDialog();
        }
        return dialog;
    }

    private AboutDialog() {
        super(Gui.getInstance(), Resources.getInstance().getBundle().getString("about_dlg_about") + " " + productName, true);
        AboutDialog.createPanel();
        this.add((Component)panel, "Center");
        this.setSize(400, 175);
        this.setResizable(false);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static void refresh() {
        Point p = dialog.getLocationOnScreen();
        dialog.setVisible(false);
        dialog.setLocation(p);
        dialog.setVisible(true);
    }

    private static void createPanel() {
        JButton btn = new JButton(Resources.getInstance().getBtnOk());
        btn.setFocusPainted(false);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        JLabel jlbAppName = new JLabel(productName, SumImages.imgAppIcon32x32, 2);
        JLabel jlbAppVersion = new JLabel(String.format(Resources.getInstance().getBundle().getString("about_dlg_version"), ApplicationManager.getInstance().getAppVersion()));
        JLabel jlbCopyright = new JLabel(Resources.getInstance().getBundle().getString("about_dlg_copyright"));
        GridBagLayout gbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        int offset = SumImages.imgAppIcon32x32.getIconWidth() + 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbag.setConstraints(jlbAppName, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, offset, 0, 0);
        gbag.setConstraints(jlbAppVersion, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(10, offset, 0, 0);
        gbag.setConstraints(jlbCopyright, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 0, 5, 5);
        gbc.anchor = 14;
        gbc.fill = 0;
        gbag.setConstraints(btn, gbc);
        panel.setLayout(gbag);
        panel.add(jlbAppName);
        panel.add(jlbAppVersion);
        panel.add(jlbCopyright);
        panel.add(btn);
    }

    static {
        productName = Resources.getInstance().getProductName();
    }
}

