/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core.objects;

import com.intel.ism.core.SumLogger;
import com.intel.ism.core.data.DataManager;
import com.intel.ism.core.data.LocalStoreDataManager;
import com.intel.ism.core.data.Product;
import com.intel.ism.core.data.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class UpdatesAndDownloads {
    public List<Update> getUpdatesAndDownloadsList() {
        ArrayList<Update> listUpdatesAndDownloadData = new ArrayList<Update>();
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            if (p.getUpdateId().equals(Product.UndefinedProperty)) continue;
            for (Update u : p.getListUpdates()) {
                if (u.getIsRemoved()) continue;
                listUpdatesAndDownloadData.add(u);
            }
        }
        return listUpdatesAndDownloadData;
    }

    public boolean pauseAllDownloadsByApp() {
        SumLogger.logger.log(Level.INFO, "pauseAllDownloadsByApp(): pausing all active downloads");
        boolean needUpdateLocalStore = false;
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            for (Update u : p.getListUpdates()) {
                if (u.getUpdateDownloadStatus() != Update.UpdateDownload.Downloading && u.getUpdateDownloadStatus() != Update.UpdateDownload.DownloadingBegin) continue;
                u.pauseDownloadByApp();
                needUpdateLocalStore = true;
            }
        }
        if (needUpdateLocalStore) {
            LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
        }
        SumLogger.logger.log(Level.INFO, "pauseAllDownloadsByApp(): completed");
        return true;
    }

    public boolean setDownloadCompleteInHistory(String guid, String id) {
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            if (!p.getGuid().equals(guid)) continue;
            return p.setUpdateDownloadedInHistory(id);
        }
        return false;
    }

    public void setAllUpdatesAsShown() {
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            for (Update u : p.getListUpdates()) {
                u.setShowNotification(false);
            }
        }
    }

    public int getNewUpdatesAndDownloadsCount() {
        int count = 0;
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            for (Update u : p.getListUpdates()) {
                if (u.getIsRemoved() || !u.getShowNotification() || u.getUpdateDownloadStatus() != Update.UpdateDownload.None) continue;
                ++count;
            }
        }
        return count;
    }

    public Update getFirstNewUpdate() {
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            for (Update u : p.getListUpdates()) {
                if (u.getIsRemoved() || !u.getShowNotification() || u.getUpdateDownloadStatus() != Update.UpdateDownload.None) continue;
                return u;
            }
        }
        return null;
    }

    public Update getFirstNewUpdate(String guid) {
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            if (!p.getGuid().equals(guid)) continue;
            for (Update u : p.getListUpdates()) {
                if (u.getIsRemoved() || !u.getShowNotification() || u.getUpdateDownloadStatus() != Update.UpdateDownload.None) continue;
                return u;
            }
        }
        return null;
    }
}

