/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core.objects;

import com.intel.ism.core.SumLogger;
import com.intel.ism.core.data.DataManager;
import com.intel.ism.core.data.LocalStoreDataManager;
import com.intel.ism.core.data.MarketingMessage;
import com.intel.ism.core.data.Product;
import com.intel.ism.core.objects.MarketingMessageData;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class MarketingMessages {
    public List<MarketingMessageData> getMarketingMessagesList() {
        ArrayList<MarketingMessageData> listMarketingMessages = new ArrayList<MarketingMessageData>();
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            if (p.getIsISM()) continue;
            for (MarketingMessage m : p.getListMarketingMessages()) {
                if (m.getIsRemoved()) continue;
                MarketingMessageData marketingData = new MarketingMessageData();
                marketingData.setGuid(p.getGuid());
                marketingData.setId(m.getId());
                marketingData.setTitle(m.getTitle());
                marketingData.setDescription(m.getDescription());
                marketingData.setPublishedDate(m.getPublishedDateStr());
                marketingData.setAdditionalInfoLink(m.getAdditionalInfoLink());
                marketingData.setIsRead(m.getIsRead());
                marketingData.setPackageName(m.getPackageName());
                listMarketingMessages.add(marketingData);
            }
        }
        return listMarketingMessages;
    }

    public boolean setRemove(String guid, String id) {
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            if (!p.getGuid().equals(guid)) continue;
            return p.moveMarketingMessageToHistory(id);
        }
        return false;
    }

    public boolean setRead(String guid, String id, boolean isRead) {
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            if (!p.getGuid().equals(guid)) continue;
            for (MarketingMessage m : p.getListMarketingMessages()) {
                if (!m.getId().equals(id)) continue;
                SumLogger.logger.log(Level.INFO, "MarketingMessages - setRead(): setting message id={0} with the status \"{1}\"", new Object[]{m.getId(), isRead});
                m.setIsRead(isRead);
                LocalStoreDataManager.defaultLocalStoreDataManager.saveMessages();
                return true;
            }
        }
        return false;
    }

    public int getNewMarketingMessagesCount() {
        int count = 0;
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            for (MarketingMessage mm : p.getListMarketingMessages()) {
                if (mm.getIsRemoved() || !mm.getIsNew()) continue;
                ++count;
            }
        }
        return count;
    }

    public MarketingMessage getFirstNewMarketingMessage() {
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            for (MarketingMessage mm : p.getListMarketingMessages()) {
                if (mm.getIsRemoved() || !mm.getIsNew()) continue;
                return mm;
            }
        }
        return null;
    }

    public void setAllMarketingMessagesAsShown() {
        for (Product p : DataManager.defaultDataManager.getProductList()) {
            for (MarketingMessage mm : p.getListMarketingMessages()) {
                mm.setShowNotification(false);
            }
        }
    }
}

