/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core.data.providers;

import com.intel.ism.core.IRCWebService.AuthHeader;
import com.intel.ism.core.IRCWebService.WsRegCenter;
import com.intel.ism.core.Resources;
import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.data.ErrorNum;
import com.intel.ism.core.data.Product;
import java.math.BigInteger;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;

public class IRCDataProvider {
    WsRegCenter ircProxy;
    Mac mac;

    public IRCDataProvider() {
        try {
            this.ircProxy = new WsRegCenter(new URL(Settings.defaultSettings.getIRCWebServiceURL()), new QName("http://Intel.com/wsRegCenterTools/112004", "wsRegCenter"));
        }
        catch (Exception e) {
            SumLogger.logger.log(Level.SEVERE, "IRCDataProvider(): Internal error: malformed url: URL = {0}; Error message = {1}", new Object[]{Settings.defaultSettings.getIRCWebServiceURL(), e.toString()});
        }
        try {
            this.mac = Mac.getInstance("HmacSHA256");
            byte[] sk = new byte[]{58, -30, -60, -67, 71, 13, 45, -49, -27, 14, -94, -120, 76, 87, 115, 21, 22, 116, 48, -48, 14, 22, -105, 121, -110, 52, 78, 2, -3, 77, 0, -25, -115, -96, -22, -60, -26, -124, 71, 0, -115, -58, 95, 58, 65, -91, 87, -110, 67, 114, 78, 20, 19, -8, 25, 100, 91, -82, 0, 101, 95, 13, -114, -77};
            SecretKeySpec s = new SecretKeySpec(sk, "HmacSHA256");
            this.mac.init(s);
        }
        catch (NoSuchAlgorithmException e) {
            SumLogger.logger.log(Level.SEVERE, "IRCDataProvider(): Internal error: there is no HmacSHA256 support");
        }
        catch (InvalidKeyException e) {
            SumLogger.logger.log(Level.SEVERE, "IRCDataProvider(): Internal error: invalid key");
        }
    }

    public ErrorNum.EGetDataErrors getSubscriptionEndDate(List<Product> listProducts) {
        String request = "";
        String response = "";
        if (this.ircProxy == null) {
            return ErrorNum.EGetDataErrors.UNKNOWN_ERROR;
        }
        SumLogger.logger.info("Getting subscription end dates...");
        request = this.createRequest(listProducts);
        if (request.isEmpty()) {
            SumLogger.logger.warning("Request is empty");
            return ErrorNum.EGetDataErrors.SUCCESS;
        }
        SumLogger.logger.log(Level.INFO, "Sending request to IRC: {0}", request);
        response = this.getSubscriptionEndDateFromIRC(request);
        if (response.isEmpty()) {
            SumLogger.logger.warning("Response is empty");
            return ErrorNum.EGetDataErrors.NO_IRC_SERVER_CONNECTION;
        }
        for (Product p : listProducts) {
            if (p.getSerialNumber().equals(Product.UndefinedProperty) || response.contains(p.getSerialNumber())) continue;
            SumLogger.logger.log(Level.WARNING, "getSubscriptionEndDate(): product has bad sn: name = {0}; guid = {1}; sn = {2}", new Object[]{p.getName(), p.getGuid(), p.getSerialNumber()});
            p.setIsBadSn(true);
        }
        SumLogger.logger.log(Level.INFO, "IRC returned response: {0}", response);
        List<SerialNumberInfo> info = this.parseResponse(response);
        if (info.isEmpty()) {
            SumLogger.logger.warning("Response does not contain SN information");
            return ErrorNum.EGetDataErrors.UNKNOWN_ERROR;
        }
        for (SerialNumberInfo serialNumberInfo : info) {
            this.fillSubscriptionEndDateForSerialNumber(listProducts, serialNumberInfo);
        }
        return ErrorNum.EGetDataErrors.SUCCESS;
    }

    private String getSubscriptionEndDateFromIRC(String request) {
        byte[] h = this.mac.doFinal(request.getBytes());
        String hashedRequest = new BigInteger(1, h).toString(16);
        hashedRequest.toUpperCase();
        AuthHeader header = new AuthHeader();
        header.setLogin(request);
        header.setPassword(hashedRequest);
        String response = this.ircProxy.getWsRegCenterSoap().getSubscriptionEndDates(request, header);
        return response;
    }

    private void fillSubscriptionEndDateForSerialNumber(List<Product> products, SerialNumberInfo serialNumberInfo) {
        for (Product product : products) {
            if (!product.getSerialNumber().equals(serialNumberInfo.serialNumber)) continue;
            SumLogger.logger.log(Level.INFO, "Product is: {0}", product.getName());
            SumLogger.logger.log(Level.INFO, "Setting subscription end date for SN {0}", serialNumberInfo.serialNumber);
            product.setSupportType(Resources.getInstance().getBundle().getString(serialNumberInfo.supportType));
            if (serialNumberInfo.subscriptionEndDate.isEmpty()) {
                SumLogger.logger.warning("Empty subscription end date");
                if (serialNumberInfo.supportType.equals("EVAL")) {
                    SumLogger.logger.warning("EVAL SN with empty subscription end date - bad SN");
                    product.setIsBadSn(true);
                }
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
                try {
                    Date date = formatter.parse(serialNumberInfo.subscriptionEndDate);
                    Calendar c = Resources.getInstance().getMIN_DATE();
                    c.setTime(date);
                    product.setSubscriptionEndDate(c);
                    SumLogger.logger.log(Level.INFO, "Subscription end date is: {0}", serialNumberInfo.subscriptionEndDate);
                }
                catch (ParseException e) {
                    SumLogger.logger.log(Level.SEVERE, "Cannot parse date {0}", serialNumberInfo.subscriptionEndDate);
                }
            }
            if (serialNumberInfo.packageName.isEmpty()) {
                SumLogger.logger.warning("Empty package name in IRC response, setting the default one");
                product.setPackageName(product.getName());
                continue;
            }
            product.setPackageName(serialNumberInfo.packageName);
        }
    }

    private String createRequest(List<Product> products) {
        String request = "";
        StringBuilder buf = new StringBuilder();
        for (Product p : products) {
            if (p.getSerialNumber().equals(Product.UndefinedProperty) || buf.toString().contains(p.getSerialNumber())) continue;
            buf.append(p.getSerialNumber()).append(";");
        }
        if (buf.length() != 0) {
            request = buf.substring(0, buf.lastIndexOf(";"));
        }
        return request;
    }

    private List<SerialNumberInfo> parseResponse(String response) {
        String[] responseData;
        ArrayList<SerialNumberInfo> list = new ArrayList<SerialNumberInfo>();
        String r = response;
        if ((r = this.removeErrorCodeFromIRCResponse(r)).isEmpty()) {
            return list;
        }
        for (String serialNumberData : responseData = r.split(";")) {
            String[] serial = serialNumberData.split("=");
            if (serial.length < 2) {
                SumLogger.logger.log(Level.WARNING, "Wrong serial number data: {0}", serialNumberData);
                continue;
            }
            String[] serialNumberDataDetails = serial[1].split(",");
            if (serialNumberDataDetails.length < 3) {
                SumLogger.logger.log(Level.WARNING, "missing support expiration date, support type or packageNumber: {0}", serial[1]);
                continue;
            }
            list.add(new SerialNumberInfo(serial[0].trim(), serialNumberDataDetails[0].trim(), serialNumberDataDetails[1].trim(), serialNumberDataDetails[2].trim()));
        }
        return list;
    }

    private String removeErrorCodeFromIRCResponse(String response) {
        String r = response;
        int endOfErrorCodeIndex = (r = r.trim()).indexOf(93);
        if (endOfErrorCodeIndex >= r.length() + 1) {
            SumLogger.logger.log(Level.WARNING, "Cannot remove error code, code: {0}", r);
            return "";
        }
        r = r.substring(endOfErrorCodeIndex + 1);
        r = r.trim();
        return r;
    }

    private class SerialNumberInfo {
        public String serialNumber;
        public String subscriptionEndDate;
        public String supportType;
        public String packageName;

        public SerialNumberInfo(String sn, String snEndDate, String snSuppType, String snPackageName) {
            this.serialNumber = sn;
            this.subscriptionEndDate = snEndDate;
            this.supportType = snSuppType;
            this.packageName = snPackageName;
        }
    }
}

