/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core.data.providers;

import com.intel.ism.core.SumLogger;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FNCBundleInfo {
    private String updateId = "";
    private ArrayList<BundleComponent> components = new ArrayList();

    public String getUpdateId() {
        return this.updateId;
    }

    public ArrayList<BundleComponent> getComponents() {
        return this.components;
    }

    public void parseXMLBundleInfo(String xmlStr) {
        try {
            if (xmlStr.isEmpty()) {
                SumLogger.logger.log(Level.INFO, "parseXMLBundleInfo(): no bundle info in the update");
                return;
            }
            SumLogger.logger.log(Level.INFO, "parseXMLBundleInfo(): found bundle info = {0}", xmlStr);
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(xmlStr)));
            NodeList topLevelNodes = doc.getElementsByTagName("config");
            for (int i = 0; i < topLevelNodes.getLength(); ++i) {
                Element element = (Element)topLevelNodes.item(i);
                NodeList bundleId = element.getElementsByTagName("update_id");
                Element line = (Element)bundleId.item(0);
                this.updateId = this.getCharacterDataFromElement(line);
            }
            NodeList nodes = doc.getElementsByTagName("bundle_component_update");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                NodeList guid = element.getElementsByTagName("product_guid");
                Element line = (Element)guid.item(0);
                String compGuid = this.getCharacterDataFromElement(line);
                NodeList updateId = element.getElementsByTagName("update_id");
                line = (Element)updateId.item(0);
                String compUpdateId = this.getCharacterDataFromElement(line);
                this.components.add(new BundleComponent(compGuid, compUpdateId));
            }
        }
        catch (Exception ex) {
            SumLogger.logger.log(Level.WARNING, "parseXMLBundleInfo: error during parsing XML=[{0}]; descr={1}", new Object[]{xmlStr, ex.toString()});
        }
    }

    private String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            return ((CharacterData)child).getData();
        }
        return "NULL";
    }

    public class BundleComponent {
        public final String compGuid;
        public final String compUpdateId;

        public BundleComponent(String compGuid, String compUpdateId) {
            this.compGuid = compGuid;
            this.compUpdateId = compUpdateId;
        }
    }
}

