/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core.data.providers;

import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.data.Product;
import java.util.List;
import java.util.logging.Level;

public class EvalTrustedStorageDataProvider {
    private static EvalTrustedStorageDataProvider provider;
    private boolean issaLoaded = false;
    private static boolean issaActivated;

    native int issaSumInit();

    native int issaSumGetTrialDaysRemaining(String var1, String var2, int var3);

    native int issaGetLicenseFromIRC(String var1, String var2);

    private EvalTrustedStorageDataProvider() {
        try {
            SumLogger.logger.info(System.getProperty("java.library.path"));
            System.loadLibrary("issasum");
            this.issaLoaded = true;
            SumLogger.logger.info("ISSA library loaded");
        }
        catch (Throwable ex) {
            SumLogger.logger.severe("Cannot load ISSA library");
            SumLogger.logger.severe(ex.getMessage());
        }
    }

    public static EvalTrustedStorageDataProvider getDefaultProvider() {
        if (provider == null) {
            provider = new EvalTrustedStorageDataProvider();
        }
        return provider;
    }

    private boolean tryIssaInit() {
        int ret = 0;
        if (!issaActivated) {
            try {
                if (!this.issaLoaded) {
                    SumLogger.logger.severe("ISSA library is not loaded");
                    return false;
                }
                ret = this.issaSumInit();
                if (ret != 0) {
                    SumLogger.logger.severe("ISSA library initialization failed");
                    return false;
                }
                issaActivated = true;
            }
            catch (Exception ex) {
                SumLogger.logger.severe("ISSA library initialization failed with exception");
                return false;
            }
            SumLogger.logger.info("ISSA library initialized");
        }
        return true;
    }

    public boolean getEvalData(List<Product> listProducts) {
        if (!this.tryIssaInit()) {
            return true;
        }
        int days = 0;
        for (Product p : listProducts) {
            if (!p.getSerialNumber().equals(Product.UndefinedProperty) || p.getIsISM()) {
                SumLogger.logger.log(Level.INFO, "getEvalData(): Product {0} is not Eval", p.getGuid());
                continue;
            }
            try {
                SumLogger.logger.log(Level.INFO, "getEvalData(): Checking evaluation info for product {0} : {1} : {2}", new Object[]{p.getGuid(), p.getProductId(), p.getFulfillmentId()});
                if (!this.issaLoaded) {
                    SumLogger.logger.severe("getEvalData(): ISSA library is not loaded");
                    return true;
                }
                int ret = this.issaSumGetTrialDaysRemaining(p.getProductId(), p.getFulfillmentId(), days);
                if (ret >= 0) {
                    SumLogger.logger.log(Level.INFO, "getEvalData(): Remaining days: {0}", ret);
                    p.setEvalDaysLeft(ret);
                    continue;
                }
                SumLogger.logger.log(Level.INFO, "getEvalData(): No information about eval ({0})", ret);
            }
            catch (Exception ex) {
                SumLogger.logger.severe("Exception during issa call");
                return true;
            }
        }
        return true;
    }

    public int getLicenseFromIRC(String serialNumber) {
        int retvalue = -1;
        if (!this.tryIssaInit()) {
            return retvalue;
        }
        try {
            SumLogger.logger.log(Level.INFO, "getLicenseFromIRC(): getting license for serial number {0}", serialNumber);
            retvalue = this.issaGetLicenseFromIRC(serialNumber, Settings.defaultSettings.getIRCWebServiceURL());
            SumLogger.logger.log(Level.INFO, "getLicenseFromIRC(): ISSA returned {0}", retvalue);
        }
        catch (Exception ex) {
            SumLogger.logger.severe("Exception during issa call");
            return -1;
        }
        return retvalue;
    }

    static {
        issaActivated = false;
    }
}

