/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core.data;

import com.intel.ism.core.Resources;
import com.intel.ism.core.SumLogger;
import com.intel.ism.gui.Common;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Message
implements Serializable {
    private String id = "-1";
    @XmlTransient
    private String productName = "";
    @XmlTransient
    private String title = "";
    @XmlTransient
    private String description = "";
    @XmlTransient
    private String publishedDateStr = "";
    @XmlTransient
    private Calendar publishedDate = Resources.getInstance().getMIN_DATE();
    @XmlTransient
    private String category = "";
    @XmlTransient
    private String additionalInfoLink = "";
    @XmlTransient
    private String packageName = "";
    private boolean isRemoved = false;
    private boolean isNew = true;
    private boolean showNotification = true;

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPublishedDateStr() {
        return this.publishedDateStr;
    }

    public Calendar getPublishedDate() {
        return this.publishedDate;
    }

    public String getAdditionalInfoLink() {
        return this.additionalInfoLink;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean getIsNew() {
        return this.isNew;
    }

    public boolean getIsRemoved() {
        return this.isRemoved;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean getShowNotification() {
        return this.showNotification;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setPublishedDateStr(String dateStr) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date date = sdf.parse(dateStr);
            this.publishedDate.setTime(date);
            this.publishedDateStr = Common.getDateFormat().format(date);
        }
        catch (ParseException ex) {
            SumLogger.logger.log(Level.WARNING, "setPublishedDateStr(): error during parsing of date received from FNC Server: {0}", ex.getMessage());
        }
    }

    public void setAdditionalInfoLink(String additionalInfoLink) {
        this.additionalInfoLink = additionalInfoLink;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public void setIsRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setShowNotification(boolean showNotification) {
        this.showNotification = showNotification;
    }
}

