/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core.data;

import com.intel.ism.core.Settings;
import com.intel.ism.core.SumLogger;
import com.intel.ism.core.data.DataManager;
import com.intel.ism.core.data.LicenseMessage;
import com.intel.ism.core.data.LocalHistoryData;
import com.intel.ism.core.data.MarketingMessage;
import com.intel.ism.core.data.Message;
import com.intel.ism.core.data.Product;
import com.intel.ism.core.data.Update;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class LocalStoreDataManager {
    public static final LocalStoreDataManager defaultLocalStoreDataManager = new LocalStoreDataManager();
    private static String dbPrefix;
    public static final String productLocalStoreDB = "messages.dat";
    public static final String historyLocalStoreDB = "history.dat";
    private static boolean canWorkWithLocalStoreDb;
    private LocalHistoryData dsHistory;

    public LocalStoreDataManager() {
        dbPrefix = Settings.defaultSettings.getDefaultInstallLocation() + "/" + Settings.defaultSettings.getFNCLocalDBName();
        this.dsHistory = new LocalHistoryData();
        File dir = new File(dbPrefix);
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println("WARNING: cannot create directory for storing local db " + dir.getAbsolutePath());
            canWorkWithLocalStoreDb = false;
        }
    }

    public LocalHistoryData getHistory() {
        return this.dsHistory;
    }

    public boolean loadHistory() {
        boolean status = true;
        SumLogger.logger.log(Level.INFO, "loadHistory(): start...");
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{LocalHistoryData.class});
            Unmarshaller u = jc.createUnmarshaller();
            File f = new File(dbPrefix + "/" + historyLocalStoreDB);
            if (f.exists()) {
                SumLogger.logger.log(Level.INFO, "loadHistory(): trying to look through local store and find history messages...");
                LocalHistoryData localHistoryData = (LocalHistoryData)LocalHistoryData.class.cast(u.unmarshal(f));
                if (localHistoryData != null) {
                    SumLogger.logger.log(Level.INFO, "loadHistory(): history messages are loaded...");
                    this.dsHistory = localHistoryData;
                } else {
                    SumLogger.logger.log(Level.INFO, "loadHistory(): cannot load history messages...");
                }
            } else {
                SumLogger.logger.log(Level.INFO, "loadHistory(): file {0} with local history data does not exist... skipping loading history", f.getName());
            }
        }
        catch (JAXBException e) {
            SumLogger.logger.log(Level.WARNING, "loadHistory(): unmarshalling error {0}", e.getStackTrace());
        }
        SumLogger.logger.log(Level.INFO, "loadMessages(): end...");
        return status;
    }

    public boolean saveHistory() {
        SumLogger.logger.log(Level.INFO, "saveHistory(): trying to save history in local store...");
        if (canWorkWithLocalStoreDb) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{LocalHistoryData.class});
                Marshaller m = context.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)true);
                FileOutputStream fos = new FileOutputStream(dbPrefix + "/" + historyLocalStoreDB);
                m.marshal((Object)this.dsHistory, (OutputStream)fos);
                fos.close();
            }
            catch (IOException ex) {
                SumLogger.logger.log(Level.WARNING, "saveHistory(): IOException: {0}", ex.getStackTrace());
            }
            catch (JAXBException ex) {
                SumLogger.logger.log(Level.WARNING, "saveHistory(): error during marshalling: {0}", ex.getStackTrace());
            }
        } else {
            SumLogger.logger.log(Level.WARNING, "saveHistory(): skipping saving history (cannot write to the directory)");
        }
        SumLogger.logger.log(Level.INFO, "saveHistory(): end...");
        return true;
    }

    public boolean loadMessages() {
        boolean status = true;
        SumLogger.logger.log(Level.INFO, "loadMessages(): start...");
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{DataManager.class});
            Unmarshaller u = jc.createUnmarshaller();
            File f = new File(dbPrefix + "/" + productLocalStoreDB);
            if (f.exists()) {
                DataManager dm = (DataManager)DataManager.class.cast(u.unmarshal(f));
                SumLogger.logger.log(Level.INFO, "loadMessages(): products count in local store = {0}", dm.getProductList().size());
                for (Product prd : dm.getProductList()) {
                    this.updateMessagesFromLocalStore(prd);
                }
            } else {
                SumLogger.logger.log(Level.INFO, "loadMessages(): file {0} with local messages does not exist... skipping loading messages", f.getName());
            }
        }
        catch (JAXBException e) {
            SumLogger.logger.log(Level.WARNING, "loadMessages(): unmarshalling error {0}", e.getStackTrace());
        }
        SumLogger.logger.log(Level.INFO, "loadMessages(): end...");
        return status;
    }

    public boolean saveMessages() {
        SumLogger.logger.log(Level.INFO, "saveMessages(): trying to save messages in local store...");
        if (canWorkWithLocalStoreDb) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DataManager.class});
                Marshaller m = context.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)true);
                FileOutputStream fos = new FileOutputStream(dbPrefix + "/" + productLocalStoreDB);
                m.marshal((Object)DataManager.defaultDataManager, (OutputStream)fos);
                fos.close();
            }
            catch (IOException ex) {
                SumLogger.logger.log(Level.WARNING, "saveMessages(): IOException: {0}", ex.getStackTrace());
            }
            catch (JAXBException ex) {
                SumLogger.logger.log(Level.WARNING, "saveMessages(): error during marshalling: {0}", ex.getStackTrace());
            }
        } else {
            SumLogger.logger.log(Level.WARNING, "saveHistory(): skipping saving history (cannot write to the directory)");
        }
        SumLogger.logger.log(Level.INFO, "saveMessages(): end...");
        return true;
    }

    private boolean updateMessagesFromLocalStore(Product localPrd) {
        Message objTo;
        SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): trying to find local product {0} in server response...", localPrd.getGuid());
        Product serverPrd = DataManager.defaultDataManager.getProductByGuid(localPrd.getGuid());
        if (serverPrd == null) {
            SumLogger.logger.log(Level.WARNING, "updateMessagesFromLocalStore(): Cannot find product {0} from local store in server response (probably it was deleted on server)...", localPrd.getGuid());
            return false;
        }
        SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): Got it!...");
        SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): looking for messages of this product in local store...", serverPrd.getGuid());
        SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): looking for Updates...");
        if (localPrd.getListUpdates() != null) {
            for (Update localUpdate : localPrd.getListUpdates()) {
                SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): trying to find update (id={0}) in local store...", localUpdate.getId());
                objTo = serverPrd.getUpdateByID(localUpdate.getId());
                if (objTo != null) {
                    SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): such Update IS found in server response; syncing it with local stored object...");
                    this.syncUpdateObjects(localUpdate, (Update)objTo);
                    continue;
                }
                SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): such Update is NOT found in server response - skipping it");
            }
        } else {
            SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): no Updates to display (it can be expired, etc)");
        }
        SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): looking for ActivationMessages...");
        if (localPrd.getListLicenseMessages() != null) {
            for (LicenseMessage localActivationMessage : localPrd.getListLicenseMessages()) {
                SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): trying to find activation message (id={0}) in local store...", localActivationMessage.getId());
                objTo = serverPrd.getActivationMessageByID(localActivationMessage.getId());
                if (objTo != null) {
                    SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): such ActivationMessage IS found in server response; syncing it with local stored object...");
                    this.syncActivationMessageObjects(localActivationMessage, (LicenseMessage)objTo);
                    continue;
                }
                SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): such ActivationMessage is NOT found in server response - skipping it");
            }
        } else {
            SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): no Activation Messages to display");
        }
        SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): looking for MarketingMessages...");
        if (localPrd.getListMarketingMessages() != null) {
            for (MarketingMessage localMarketingMessage : localPrd.getListMarketingMessages()) {
                SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): trying to find marketing message (id={0}) in local store...", localMarketingMessage.getId());
                objTo = serverPrd.getMarketingMessageByID(localMarketingMessage.getId());
                if (objTo != null) {
                    SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): such MarketingMessage IS found in server response; syncing it with local stored object...");
                    this.syncMarketingMessageObjects(localMarketingMessage, (MarketingMessage)objTo);
                    continue;
                }
                SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): such MarketingMessage is NOT found in server response - skipping it");
            }
        } else {
            SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): no Marketing Messages to display");
        }
        SumLogger.logger.log(Level.INFO, "updateMessagesFromLocalStore(): finished merging messages from local store for this product...");
        return true;
    }

    private void syncUpdateObjects(Update objFrom, Update objTo) {
        objTo.setShowNotification(objFrom.getShowNotification());
        objTo.setIsNew(false);
        objTo.setProductGuid(objFrom.getProductGuid());
        objTo.setIsRemoved(objFrom.getIsRemoved());
        objTo.setUpdateDownloadStatus(objFrom.getUpdateDownloadStatus() != null ? objFrom.getUpdateDownloadStatus() : Update.UpdateDownload.None);
        objTo.setDownloadProgress(objFrom.getDownloadProgress());
        objTo.setDownloadFile(objFrom.getDownloadFile());
    }

    private void syncActivationMessageObjects(LicenseMessage objFrom, LicenseMessage objTo) {
        objTo.setShowNotification(objFrom.getShowNotification());
        objTo.setIsNew(false);
        objTo.setIsRemoved(objFrom.getIsRemoved());
    }

    private void syncMarketingMessageObjects(MarketingMessage objFrom, MarketingMessage objTo) {
        objTo.setShowNotification(objFrom.getShowNotification());
        objTo.setIsNew(false);
        objTo.setIsRemoved(objFrom.getIsRemoved());
        objTo.setIsRead(objFrom.getIsRead());
    }

    static {
        canWorkWithLocalStoreDb = true;
    }
}

