/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core.data;

import com.intel.ism.core.SumLogger;
import com.intel.ism.core.data.ErrorNum;
import com.intel.ism.core.data.Product;
import com.intel.ism.core.data.Update;
import com.intel.ism.core.data.providers.EvalTrustedStorageDataProvider;
import com.intel.ism.core.data.providers.FNCBundleInfo;
import com.intel.ism.core.data.providers.FNCLocalDataProvider;
import com.intel.ism.core.data.providers.IRCDataProvider;
import com.intel.ism.gui.controllers.ApplicationManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="products")
public class DataManager {
    @XmlTransient
    public static DataManager defaultDataManager = new DataManager();
    @XmlElement(name="product")
    List<Product> listProducts = new ArrayList<Product>();
    @XmlTransient
    ErrorNum.EGetDataErrors dataStatus = ErrorNum.EGetDataErrors.SUCCESS;

    public ErrorNum.EGetDataErrors getStatusofGetAllData() {
        return this.dataStatus;
    }

    public List<Product> getProductList() {
        return this.listProducts;
    }

    public Product getProductByGuid(String guid) {
        for (Product p : this.listProducts) {
            if (!p.getGuid().equals(guid)) continue;
            return p;
        }
        return null;
    }

    public void clearData() {
        this.listProducts.clear();
    }

    public boolean getAllData(boolean skipCFU) {
        SumLogger.logger.info("getAllData(): beginning requesting data from all data providers and merge it with locally stored data");
        this.clearData();
        this.dataStatus = ErrorNum.EGetDataErrors.UNKNOWN_ERROR;
        FNCLocalDataProvider fncLocalDbProvider = new FNCLocalDataProvider();
        if (!fncLocalDbProvider.getListOfProducts(this.listProducts)) {
            return false;
        }
        ArrayList<String> _orig = new ArrayList<String>();
        ArrayList<String> _new = new ArrayList<String>();
        for (Product p_orig : defaultDataManager.getProductList()) {
            _orig.add(p_orig.getGuid());
        }
        for (Product p_new : this.listProducts) {
            _new.add(p_new.getGuid());
        }
        if (((Object)_orig).equals(_new) && skipCFU) {
            SumLogger.logger.info("getAllData(): skipping CFU (local db is not changed from last CFU)");
            return false;
        }
        SumLogger.logger.info("getAllData(): CFU is allowed");
        if (this.listProducts.isEmpty()) {
            this.dataStatus = ErrorNum.EGetDataErrors.SUCCESS;
            return true;
        }
        if (ApplicationManager.getInstance().getWorker().isCancelled()) {
            SumLogger.logger.warning("getAllData(): INTERRUPTED -1 (user pressed cancel)");
            return false;
        }
        EvalTrustedStorageDataProvider fnc_eval_data_provider = EvalTrustedStorageDataProvider.getDefaultProvider();
        if (!fnc_eval_data_provider.getEvalData(this.listProducts)) {
            return false;
        }
        if (ApplicationManager.getInstance().getWorker().isCancelled()) {
            SumLogger.logger.warning("getAllData(): INTERRUPTED -2 (user pressed cancel)");
            return false;
        }
        IRCDataProvider irc_data_provider = new IRCDataProvider();
        this.dataStatus = irc_data_provider.getSubscriptionEndDate(this.listProducts);
        if (this.dataStatus != ErrorNum.EGetDataErrors.SUCCESS) {
            return false;
        }
        if (ApplicationManager.getInstance().getWorker().isCancelled()) {
            SumLogger.logger.warning("getAllData(): INTERRUPTED -3 (user pressed cancel)");
            return false;
        }
        for (Product prd : this.listProducts) {
            this.dataStatus = prd.getMessagesFromFNCServer();
            if (this.dataStatus != ErrorNum.EGetDataErrors.SUCCESS) {
                return false;
            }
            if (prd.getIsBadProduct()) {
                SumLogger.logger.log(Level.WARNING, "getAllData(): skip product not registered in FNC : {0}", prd.getGuid());
                prd.getListLicenseMessages().clear();
                prd.getListMarketingMessages().clear();
                prd.getListUpdates().clear();
                continue;
            }
            if (ApplicationManager.getInstance().getWorker().isCancelled()) {
                SumLogger.logger.warning("getAllData(): INTERRUPTED -4 (user pressed cancel)");
                return false;
            }
            if (!prd.getLicenseMessage()) {
                return false;
            }
            if (!ApplicationManager.getInstance().getWorker().isCancelled()) continue;
            SumLogger.logger.warning("getAllData(): INTERRUPTED -5 (user pressed cancel)");
            return false;
        }
        for (Product prd : this.listProducts) {
            for (Update u : prd.getListUpdates()) {
                if (!u.getIsBundle()) continue;
                u.setUpdateType(Update.EUpdateType.BUNDLE);
                for (FNCBundleInfo.BundleComponent bundleComp : u.getFNCBundleInfo().getComponents()) {
                    for (Product prd_inner : this.listProducts) {
                        if (!prd_inner.getGuid().equals(bundleComp.compGuid)) continue;
                        for (Update u_inner : prd_inner.getListUpdates()) {
                            if (!u_inner.getFNCBundleInfo().getUpdateId().equals(bundleComp.compUpdateId)) continue;
                            u_inner.setPackageName(u.getPackageName());
                            u_inner.setUpdateType(Update.EUpdateType.PART_OF_BUNDLE);
                        }
                    }
                }
            }
        }
        this.dataStatus = ErrorNum.EGetDataErrors.SUCCESS;
        return true;
    }
}

