/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core;

import com.intel.ism.core.SumLogger;
import com.intel.ism.core.Tools;
import com.intel.ism.gui.Common;
import com.intel.ism.gui.controllers.ApplicationManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;

public class UsageStatisticsManager {
    private static final UsageStatisticsManager defaultUsageStatistics = new UsageStatisticsManager();
    private int tabUpdates = 0;
    private int tabLicenses = 0;
    private int tabNews = 0;
    private int tabHistory = 0;
    private int tabSettings = 0;
    private int actionDownload = 0;
    private int actionPause = 0;
    private int actionResume = 0;
    private int actionCancelDownload = 0;
    private int actionInstall = 0;
    private int actionRenew = 0;
    private int actionActivate = 0;
    private int actionRefresh = 0;

    private UsageStatisticsManager() {
    }

    public static UsageStatisticsManager getInstance() {
        return defaultUsageStatistics;
    }

    public void increaseActionActivate() {
        ++this.actionActivate;
    }

    public void increaseActionCancelDownload() {
        ++this.actionCancelDownload;
    }

    public void increaseActionDownload() {
        ++this.actionDownload;
    }

    public void increaseActionInstall() {
        ++this.actionInstall;
    }

    public void increaseActionPause() {
        ++this.actionPause;
    }

    public void increaseActionRefresh() {
        ++this.actionRefresh;
    }

    public void increaseActionRenew() {
        ++this.actionRenew;
    }

    public void increaseActionResume() {
        ++this.actionResume;
    }

    public void increaseTabHistory() {
        ++this.tabHistory;
    }

    public void increaseTabLicenses() {
        ++this.tabLicenses;
    }

    public void increaseTabNews() {
        ++this.tabNews;
    }

    public void increaseTabSettings() {
        ++this.tabSettings;
    }

    public void increaseTabUpdates() {
        ++this.tabUpdates;
    }

    public void dumpCollectedStatistics() {
        String statFile = "/tmp/intel.ism.usagestat." + System.getProperty("user.name");
        File file = new File(statFile);
        try {
            if (file.getParent() != null) {
                new File(file.getParent()).mkdirs();
            }
            file.createNewFile();
            FileWriter fw = new FileWriter(statFile);
            BufferedWriter out = new BufferedWriter(fw);
            out.write("[features]\n");
            out.write("tab.updates=" + this.tabUpdates + "\n");
            out.write("tab.licenses=" + this.tabLicenses + "\n");
            out.write("tab.news=" + this.tabNews + "\n");
            out.write("tab.history=" + this.tabHistory + "\n");
            out.write("tab.settings=" + this.tabSettings + "\n");
            out.write("[actions]\n");
            out.write("update.download=" + this.actionDownload + "\n");
            out.write("update.pause=" + this.actionPause + "\n");
            out.write("update.resume=" + this.actionResume + "\n");
            out.write("update.cancel=" + this.actionCancelDownload + "\n");
            out.write("update.install=" + this.actionInstall + "\n");
            out.write("license.renew=" + this.actionRenew + "\n");
            out.write("license.activate=" + this.actionActivate + "\n");
            out.write("ism.refresh=" + this.actionRefresh + "\n");
            out.close();
            fw.close();
            String remotemon = "";
            String path_to_jar = ApplicationManager.getInstance().getPathToJar();
            if (Common.isMac()) {
                remotemon = path_to_jar + "/bin/universal_mac10/intelremotemon";
            } else {
                switch (Tools.getArch()) {
                    case IA32: {
                        remotemon = path_to_jar + "/bin/ia32/intelremotemon";
                        break;
                    }
                    case INTEL64: {
                        remotemon = path_to_jar + "/bin/intel64/intelremotemon";
                    }
                }
            }
            String[] cmd = new String[]{remotemon, "-p", "ism-" + ApplicationManager.getInstance().getAppVersion(), "-t", "i", "-e", "usage_info", "-m", statFile};
            if (!remotemon.isEmpty()) {
                try {
                    Runtime.getRuntime().exec(cmd);
                }
                catch (IOException ex) {
                    SumLogger.logger.log(Level.WARNING, "dumpCollectedStatistics(): {0}", ex.toString());
                }
            }
        }
        catch (IOException ex) {
            SumLogger.logger.log(Level.INFO, "dumpCollectedStatistics(): cannot create output file ({0})", statFile);
        }
    }
}

