/*
 * Decompiled with CFR 0.152.
 */
package com.intel.ism.core;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SumLogger {
    public static final Logger logger = Logger.getLogger("ism");
    private static boolean isEnabled = false;
    private static final String defaultLogFile = SumLogger.getLogFile();

    private static String getLogFile() {
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            System.err.println("Exception in getting hostname: " + ex + System.getProperty("line.separator") + "StackTrace: " + System.getProperty("line.separator") + Arrays.toString(ex.getStackTrace()));
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM.dd.HH.mm.ss.yyyy");
        Date date = new Date();
        String strDate = dateFormat.format(date);
        return "/tmp/intel.ism." + System.getProperty("user.name") + "." + hostname + "_" + strDate + ".log";
    }

    public static void enableLogging() {
        SumLogger.enableLogging(defaultLogFile);
    }

    private static void enableLogging(String file) {
        if (isEnabled) {
            logger.warning("logger already enabled");
            return;
        }
        if (!new File(new File(file).getParent()).exists() && !new File(new File(file).getParent()).mkdirs()) {
            System.err.println("cannot create path: " + new File(file).getParent());
            System.exit(1);
        }
        try {
            FileHandler handler = new FileHandler(file, true);
            Formatter formatter = new Formatter(){

                @Override
                public String format(LogRecord rec) {
                    String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
                    Calendar calendar = Calendar.getInstance();
                    int minInt = calendar.get(12);
                    String minStr = "";
                    minStr = minInt >= 0 && minInt <= 9 ? "0" + minInt : Integer.toString(minInt);
                    String date = calendar.get(5) + " " + months[calendar.get(2)] + " " + calendar.get(11) + ":" + minStr;
                    StringBuilder buf = new StringBuilder(1000);
                    buf.append("[").append(date).append("]");
                    buf.append(' ');
                    buf.append(rec.getLevel());
                    buf.append(' ');
                    buf.append(this.formatMessage(rec));
                    buf.append(System.getProperty("line.separator"));
                    return buf.toString();
                }
            };
            handler.setFormatter(formatter);
            handler.setLevel(Level.ALL);
            logger.addHandler(handler);
            logger.setLevel(Level.ALL);
            logger.setUseParentHandlers(false);
            isEnabled = true;
        }
        catch (Exception e) {
            System.err.println("Exception in enabling logging: " + e + System.getProperty("line.separator") + "StackTrace: " + System.getProperty("line.separator") + Arrays.toString(e.getStackTrace()));
            System.exit(1);
        }
    }

    static void disableLogging() {
        Handler[] handlers;
        for (Handler i : handlers = logger.getHandlers()) {
            i.close();
        }
        isEnabled = false;
    }
}

