/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ViewerFrame
extends JFrame {
    private String m_defaultTitle;
    private FuncProfileTableModel m_funcModel;
    private LoopProfileTableModel m_loopModel;
    private FuncProfileTable m_funcProfileTable = null;
    private LoopProfileTable m_loopProfileTable = null;
    private JMenuItem m_closeItem;
    private JMenuItem m_printFuncItem;
    private JMenuItem m_printLoopItem;
    private JMenuItem m_viewFunctionSourceItem;
    private JMenuItem m_viewLoopFunctionSourceItem;
    private JMenuItem m_viewLoopSourceItem;
    private JMenuItem m_columnsItem;
    private FloatFilterCheckBoxMenuItem m_functionTicksItem;
    private FloatFilterCheckBoxMenuItem m_functionSelfItem;
    private FloatFilterCheckBoxMenuItem m_loopTicksItem;
    private FloatFilterCheckBoxMenuItem m_loopSelfItem;
    private FilterCheckBoxMenuItem m_filterLoopsByFunctionNameItem;
    private JPopupMenu m_funcPopupMenu;
    private FloatFilterCheckBoxMenuItem m_functionTicksFilterPopupItem;
    private FloatFilterCheckBoxMenuItem m_functionSelfFilterPopupItem;
    private JMenuItem m_viewFunctionSourcePopupItem;
    private FilterCheckBoxMenuItem m_filterLoopsByFunctionNamePopupItem;
    private JPopupMenu m_loopPopupMenu;
    private FloatFilterCheckBoxMenuItem m_loopTicksFilterPopupItem;
    private FloatFilterCheckBoxMenuItem m_loopSelfFilterPopupItem;
    private JMenuItem m_viewLoopFunctionSourcePopupItem;
    private JMenuItem m_viewLoopSourcePopupItem;
    private ListSelectionModel m_funcSelectionModel;
    private ListSelectionModel m_loopSelectionModel;
    private JComponent m_view = null;
    private ThresholdDialog m_thresholdsDialog = null;
    String m_lastPath = null;
    private Filter<Float> m_functionTicksFilter = new Filter<Float>(new Float(0.01f));
    private Filter<Float> m_functionSelfFilter = new Filter<Float>(new Float(0.01f));
    private Filter<String> m_functionLoopNameFilter = new Filter();
    private Filter<Float> m_loopTicksFilter = new Filter<Float>(new Float(0.01f));
    private Filter<Float> m_loopSelfFilter = new Filter<Float>(new Float(0.01f));
    private Filter<String> m_functionNameFilter = new Filter();

    ViewerFrame() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        LoopProfileViewerStrings loopProfileViewerStrings = LoopProfileViewerStrings.getInstance();
        this.createFileMenu(jMenuBar, loopProfileViewerStrings);
        this.createViewMenu(jMenuBar, loopProfileViewerStrings);
        this.createFilterMenu(jMenuBar, loopProfileViewerStrings);
        this.createHelpMenu(jMenuBar, loopProfileViewerStrings);
        this.createPopupMenus(loopProfileViewerStrings);
        this.m_thresholdsDialog = new ThresholdDialog(this);
        this.m_defaultTitle = LoopProfileViewerStrings.getInstance().getString("app.title");
        this.setTitle(this.m_defaultTitle);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        this.setSize((int)(d * 0.85), (int)(d2 * 0.85));
        this.setDefaultCloseOperation(3);
    }

    private void createFileMenu(JMenuBar jMenuBar, LoopProfileViewerStrings loopProfileViewerStrings) {
        String string = loopProfileViewerStrings.getString("menu.file.label");
        String string2 = loopProfileViewerStrings.getString("menu.file.accelerator");
        String string3 = loopProfileViewerStrings.getString("menu.file.open.label");
        String string4 = loopProfileViewerStrings.getString("menu.file.open.accelerator");
        String string5 = loopProfileViewerStrings.getString("menu.file.close.label");
        String string6 = loopProfileViewerStrings.getString("menu.file.close.accelerator");
        String string7 = loopProfileViewerStrings.getString("menu.file.print_function_table.label");
        String string8 = loopProfileViewerStrings.getString("menu.file.print_loop_table.label");
        String string9 = loopProfileViewerStrings.getString("menu.file.exit.label");
        String string10 = loopProfileViewerStrings.getString("menu.file.exit.accelerator");
        final String string11 = loopProfileViewerStrings.getString("dialog.error.title");
        final String string12 = loopProfileViewerStrings.getString("error.print_error.label");
        JMenu jMenu = new JMenu(string);
        jMenu.setMnemonic(string2.charAt(0));
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(string3, string4.charAt(0));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                if (ViewerFrame.this.m_lastPath == null) {
                    jFileChooser.setCurrentDirectory(new File("."));
                } else {
                    jFileChooser.setCurrentDirectory(new File(ViewerFrame.this.m_lastPath));
                }
                FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("XML Files (*.xml)", "xml");
                jFileChooser.setFileFilter(fileNameExtensionFilter);
                int n = jFileChooser.showOpenDialog(ViewerFrame.this.getContentPane());
                if (n == 0) {
                    try {
                        ViewerFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                        String string = jFileChooser.getSelectedFile().getPath();
                        ViewerFrame.this.openFile(string);
                    }
                    finally {
                        ViewerFrame.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
        this.m_closeItem = new JMenuItem(string5, string6.charAt(0));
        jMenu.add(this.m_closeItem);
        this.m_closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.closeView();
            }
        });
        jMenu.insertSeparator(3);
        this.m_printFuncItem = new JMenuItem(string7);
        jMenu.add(this.m_printFuncItem);
        this.m_printFuncItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ViewerFrame.this.m_funcProfileTable.print();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(ViewerFrame.this.getRootPane(), string12 + ": " + exception.getMessage(), string11, 0);
                }
            }
        });
        this.m_printLoopItem = new JMenuItem(string8);
        jMenu.add(this.m_printLoopItem);
        this.m_printLoopItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ViewerFrame.this.m_loopProfileTable.print();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(ViewerFrame.this.getRootPane(), string12 + exception.getMessage(), string11, 0);
                }
            }
        });
        jMenu.insertSeparator(5);
        JMenuItem jMenuItem2 = new JMenuItem(string9, string10.charAt(0));
        jMenu.add(jMenuItem2);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.m_closeItem.setEnabled(false);
        this.m_printFuncItem.setEnabled(false);
        this.m_printLoopItem.setEnabled(false);
    }

    private void createViewMenu(JMenuBar jMenuBar, LoopProfileViewerStrings loopProfileViewerStrings) {
        String string = loopProfileViewerStrings.getString("menu.view.label");
        String string2 = loopProfileViewerStrings.getString("menu.view.accelerator");
        String string3 = loopProfileViewerStrings.getString("menu.view.selected_function_source.label");
        String string4 = loopProfileViewerStrings.getString("menu.view.selected_loop_function_source.label");
        String string5 = loopProfileViewerStrings.getString("menu.view.selected_loop_source.label");
        String string6 = loopProfileViewerStrings.getString("menu.view.columns.label");
        String string7 = loopProfileViewerStrings.getString("menu.view.columns.accelerator");
        JMenu jMenu = new JMenu(string);
        jMenu.setMnemonic(string2.charAt(0));
        jMenuBar.add(jMenu);
        this.m_viewFunctionSourceItem = new JMenuItem(string3);
        jMenu.add(this.m_viewFunctionSourceItem);
        this.m_viewFunctionSourceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.viewFunctionSourceAction();
            }
        });
        this.m_viewLoopFunctionSourceItem = new JMenuItem(string4);
        jMenu.add(this.m_viewLoopFunctionSourceItem);
        this.m_viewLoopFunctionSourceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.viewLoopFunctionSourceAction();
            }
        });
        this.m_viewLoopSourceItem = new JMenuItem(string5);
        jMenu.add(this.m_viewLoopSourceItem);
        this.m_viewLoopSourceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.viewLoopSourceAction();
            }
        });
        jMenu.insertSeparator(3);
        this.m_columnsItem = new JMenuItem(string6, string7.charAt(0));
        this.m_columnsItem.setDisplayedMnemonicIndex(7);
        jMenu.add(this.m_columnsItem);
        this.m_columnsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.showColumnsDialog();
            }
        });
        this.m_viewFunctionSourceItem.setEnabled(false);
        this.m_viewLoopFunctionSourceItem.setEnabled(false);
        this.m_viewLoopSourceItem.setEnabled(false);
        this.m_columnsItem.setEnabled(false);
    }

    private void createFilterMenu(JMenuBar jMenuBar, LoopProfileViewerStrings loopProfileViewerStrings) {
        String string = loopProfileViewerStrings.getString("menu.filter.label");
        String string2 = loopProfileViewerStrings.getString("menu.filter.accelerator");
        String string3 = loopProfileViewerStrings.getString("menu.filter.function.label");
        String string4 = loopProfileViewerStrings.getString("menu.filter.function.accelerator");
        String string5 = loopProfileViewerStrings.getString("menu.filter.loop.label");
        String string6 = loopProfileViewerStrings.getString("menu.filter.loop.accelerator");
        String string7 = loopProfileViewerStrings.getString("menu.filter.total_time.label");
        String string8 = loopProfileViewerStrings.getString("menu.filter.total_time.accelerator");
        String string9 = loopProfileViewerStrings.getString("menu.filter.self_time.label");
        String string10 = loopProfileViewerStrings.getString("menu.filter.self_time.accelerator");
        String string11 = loopProfileViewerStrings.getString("menu.filter.function_loops.label");
        String string12 = loopProfileViewerStrings.getString("menu.filter.function_loops.accelerator");
        String string13 = loopProfileViewerStrings.getString("menu.filter.thresholds.label");
        String string14 = loopProfileViewerStrings.getString("menu.filter.thresholds.accelerator");
        JMenu jMenu = new JMenu(string);
        jMenu.setMnemonic(string2.charAt(0));
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(string3);
        jMenu2.setMnemonic(string4.charAt(0));
        jMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu(string5);
        jMenu3.setMnemonic(string6.charAt(0));
        jMenu.add(jMenu3);
        this.m_functionTicksItem = new FloatFilterCheckBoxMenuItem(this.m_functionTicksFilter, string7);
        this.m_functionTicksItem.setMnemonic(string8.charAt(0));
        jMenu2.add(this.m_functionTicksItem);
        this.m_functionTicksFilter.addListener(this.m_functionTicksItem);
        this.m_functionSelfItem = new FloatFilterCheckBoxMenuItem(this.m_functionSelfFilter, string9);
        this.m_functionSelfItem.setMnemonic(string10.charAt(0));
        jMenu2.add(this.m_functionSelfItem);
        this.m_functionSelfFilter.addListener(this.m_functionSelfItem);
        this.m_loopTicksItem = new FloatFilterCheckBoxMenuItem(this.m_loopTicksFilter, string7);
        this.m_loopTicksItem.setMnemonic(string8.charAt(0));
        jMenu3.add(this.m_loopTicksItem);
        this.m_loopTicksFilter.addListener(this.m_loopTicksItem);
        this.m_loopSelfItem = new FloatFilterCheckBoxMenuItem(this.m_loopSelfFilter, string9);
        this.m_loopSelfItem.setMnemonic(string10.charAt(0));
        jMenu3.add(this.m_loopSelfItem);
        this.m_loopSelfFilter.addListener(this.m_loopSelfItem);
        this.m_filterLoopsByFunctionNameItem = new FilterCheckBoxMenuItem(this.m_functionNameFilter, string11);
        this.m_filterLoopsByFunctionNameItem.setMnemonic(string12.charAt(0));
        jMenu3.add(this.m_filterLoopsByFunctionNameItem);
        this.m_functionNameFilter.addListener(this.m_filterLoopsByFunctionNameItem);
        jMenu.insertSeparator(2);
        JMenuItem jMenuItem = new JMenuItem(string13, string14.charAt(0));
        jMenuItem.setDisplayedMnemonicIndex(4);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.showThresholdsDialog();
            }
        });
        this.m_functionTicksItem.setEnabled(false);
        this.m_functionSelfItem.setEnabled(false);
        this.m_loopTicksItem.setEnabled(false);
        this.m_loopSelfItem.setEnabled(false);
        this.m_filterLoopsByFunctionNameItem.setEnabled(false);
    }

    private void createHelpMenu(JMenuBar jMenuBar, LoopProfileViewerStrings loopProfileViewerStrings) {
        Serializable serializable;
        String string = loopProfileViewerStrings.getString("menu.help.label");
        String string2 = loopProfileViewerStrings.getString("menu.help.accelerator");
        String string3 = loopProfileViewerStrings.getString("menu.help.about.label");
        String string4 = loopProfileViewerStrings.getString("menu.help.about.accelerator");
        int n = Integer.parseInt(loopProfileViewerStrings.getString("dialog.about.content.lines"));
        final String string5 = loopProfileViewerStrings.getString("dialog.about.title");
        String string6 = "";
        for (int i = 0; i < n; ++i) {
            serializable = new Integer(i);
            String string7 = "dialog.about.line" + ((Integer)serializable).toString() + ".label";
            string6 = string6 + loopProfileViewerStrings.getString(string7) + "\n";
        }
        final String string8 = string6;
        JMenu jMenu = new JMenu(string);
        jMenu.setMnemonic(string2.charAt(0));
        jMenuBar.add(jMenu);
        serializable = new JMenuItem(string3, string4.charAt(0));
        jMenu.add((JMenuItem)serializable);
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(ViewerFrame.this.getRootPane(), string8, string5, 1);
            }
        });
    }

    private void createPopupMenus(LoopProfileViewerStrings loopProfileViewerStrings) {
        String string = loopProfileViewerStrings.getString("popup.function.filter_total_time.label");
        String string2 = loopProfileViewerStrings.getString("popup.function.filter_self_time.label");
        String string3 = loopProfileViewerStrings.getString("popup.function.filter_function_loops.label");
        String string4 = loopProfileViewerStrings.getString("popup.function.view_function.label");
        String string5 = loopProfileViewerStrings.getString("popup.loop.filter_total_time.label");
        String string6 = loopProfileViewerStrings.getString("popup.loop.filter_self_time.label");
        String string7 = loopProfileViewerStrings.getString("popup.loop.view_function.label");
        String string8 = loopProfileViewerStrings.getString("popup.loop.view_loop.label");
        this.m_funcPopupMenu = new JPopupMenu();
        this.m_functionTicksFilterPopupItem = new FloatFilterCheckBoxMenuItem(this.m_functionTicksFilter, string);
        this.m_funcPopupMenu.add(this.m_functionTicksFilterPopupItem);
        this.m_functionTicksFilter.addListener(this.m_functionTicksFilterPopupItem);
        this.m_functionSelfFilterPopupItem = new FloatFilterCheckBoxMenuItem(this.m_functionSelfFilter, string2);
        this.m_funcPopupMenu.add(this.m_functionSelfFilterPopupItem);
        this.m_functionSelfFilter.addListener(this.m_functionSelfFilterPopupItem);
        this.m_filterLoopsByFunctionNamePopupItem = new FilterCheckBoxMenuItem(this.m_functionNameFilter, string3);
        this.m_funcPopupMenu.add(this.m_filterLoopsByFunctionNamePopupItem);
        this.m_functionNameFilter.addListener(this.m_filterLoopsByFunctionNamePopupItem);
        this.m_viewFunctionSourcePopupItem = new JMenuItem(string4);
        this.m_funcPopupMenu.add(this.m_viewFunctionSourcePopupItem);
        this.m_viewFunctionSourcePopupItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.viewFunctionSourceAction();
            }
        });
        this.m_loopPopupMenu = new JPopupMenu();
        this.m_loopTicksFilterPopupItem = new FloatFilterCheckBoxMenuItem(this.m_loopTicksFilter, string5);
        this.m_loopPopupMenu.add(this.m_loopTicksFilterPopupItem);
        this.m_loopTicksFilter.addListener(this.m_loopTicksFilterPopupItem);
        this.m_loopSelfFilterPopupItem = new FloatFilterCheckBoxMenuItem(this.m_loopSelfFilter, string6);
        this.m_loopPopupMenu.add(this.m_loopSelfFilterPopupItem);
        this.m_loopSelfFilter.addListener(this.m_loopSelfFilterPopupItem);
        this.m_viewLoopFunctionSourcePopupItem = new JMenuItem(string7);
        this.m_loopPopupMenu.add(this.m_viewLoopFunctionSourcePopupItem);
        this.m_viewLoopFunctionSourcePopupItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.viewLoopFunctionSourceAction();
            }
        });
        this.m_viewLoopSourcePopupItem = new JMenuItem(string8);
        this.m_loopPopupMenu.add(this.m_viewLoopSourcePopupItem);
        this.m_viewLoopSourcePopupItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewerFrame.this.viewLoopSourceAction();
            }
        });
        this.m_viewLoopFunctionSourcePopupItem.setEnabled(false);
        this.m_viewLoopSourcePopupItem.setEnabled(false);
        this.m_filterLoopsByFunctionNamePopupItem.setEnabled(false);
        this.m_viewFunctionSourcePopupItem.setEnabled(false);
    }

    private void showThresholdsDialog() {
        this.m_thresholdsDialog.setFuncTicksThreshold(this.m_functionTicksFilter.getValue().floatValue());
        this.m_thresholdsDialog.setFuncSelfThreshold(this.m_functionSelfFilter.getValue().floatValue());
        this.m_thresholdsDialog.setLoopTicksThreshold(this.m_loopTicksFilter.getValue().floatValue());
        this.m_thresholdsDialog.setLoopSelfThreshold(this.m_loopSelfFilter.getValue().floatValue());
        this.m_thresholdsDialog.setLocationRelativeTo(this);
        this.m_thresholdsDialog.setVisible(true);
        if (this.m_thresholdsDialog.getOkSelected().booleanValue()) {
            this.m_functionTicksFilter.setValue(new Float(this.m_thresholdsDialog.getFuncTicksThreshold()));
            this.m_functionSelfFilter.setValue(new Float(this.m_thresholdsDialog.getFuncSelfThreshold()));
            this.m_loopTicksFilter.setValue(new Float(this.m_thresholdsDialog.getLoopTicksThreshold()));
            this.m_loopSelfFilter.setValue(new Float(this.m_thresholdsDialog.getLoopSelfThreshold()));
        }
    }

    private void showColumnsDialog() {
        ColumnsDialog columnsDialog = new ColumnsDialog(this, this.m_funcProfileTable, this.m_funcModel, this.m_loopProfileTable, this.m_loopModel);
        columnsDialog.setLocationRelativeTo(this);
        columnsDialog.setVisible(true);
        if (columnsDialog.getOkSelected().booleanValue()) {
            int n;
            if (this.m_funcModel != null) {
                for (n = 0; n < this.m_funcModel.getColumnCount(); ++n) {
                    if (!this.m_funcProfileTable.getColumnViewable(n).booleanValue()) continue;
                    if (columnsDialog.getFuncColumnSelected(n).booleanValue()) {
                        this.m_funcProfileTable.showColumn(n);
                        continue;
                    }
                    this.m_funcProfileTable.hideColumn(n);
                }
            }
            if (this.m_loopModel != null) {
                for (n = 0; n < this.m_loopModel.getColumnCount(); ++n) {
                    if (!this.m_loopProfileTable.getColumnViewable(n).booleanValue()) continue;
                    if (columnsDialog.getLoopColumnSelected(n).booleanValue()) {
                        this.m_loopProfileTable.showColumn(n);
                        continue;
                    }
                    this.m_loopProfileTable.hideColumn(n);
                }
            }
        }
    }

    private void showSource(SourceLocation sourceLocation) {
        String string = sourceLocation.getFullPath();
        File file = new File(string);
        if (file.exists()) {
            try {
                SourceView sourceView = new SourceView(this, string, sourceLocation.getLine());
                sourceView.setLocationRelativeTo(this);
                sourceView.setVisible(true);
            }
            catch (IOException iOException) {
                LoopProfileViewerStrings loopProfileViewerStrings = LoopProfileViewerStrings.getInstance();
                String string2 = loopProfileViewerStrings.getString("error.file_read_error.label");
                String string3 = loopProfileViewerStrings.getString("dialog.error.title");
                JOptionPane.showMessageDialog(this.getRootPane(), string2 + string + ": " + iOException.getMessage(), string3, 0);
                return;
            }
        } else {
            string = this.m_lastPath + File.separator + sourceLocation.getName();
            file = new File(string);
            if (file.exists()) {
                try {
                    SourceView sourceView = new SourceView(this, string, sourceLocation.getLine());
                    sourceView.setLocationRelativeTo(this);
                    sourceView.setVisible(true);
                }
                catch (IOException iOException) {
                    LoopProfileViewerStrings loopProfileViewerStrings = LoopProfileViewerStrings.getInstance();
                    String string4 = loopProfileViewerStrings.getString("error.file_read_error.label");
                    String string5 = loopProfileViewerStrings.getString("dialog.error.title");
                    JOptionPane.showMessageDialog(this.getRootPane(), string4 + string + ": " + iOException.getMessage(), string5, 0);
                    return;
                }
            } else {
                LoopProfileViewerStrings loopProfileViewerStrings = LoopProfileViewerStrings.getInstance();
                String string6 = loopProfileViewerStrings.getString("error.open_error.label");
                String string7 = loopProfileViewerStrings.getString("dialog.error.title");
                JOptionPane.showMessageDialog(this.getRootPane(), string6 + ": " + sourceLocation.getFullPath(), string7, 0);
            }
        }
    }

    private void viewFunctionSourceAction() {
        if (!this.m_funcSelectionModel.isSelectionEmpty()) {
            int n = this.m_funcSelectionModel.getMinSelectionIndex();
            SourceLocation sourceLocation = this.m_funcModel.getSourceLocation(this.m_funcProfileTable.convertRowIndexToModel(n));
            this.showSource(sourceLocation);
        }
    }

    private void viewLoopFunctionSourceAction() {
        if (!this.m_loopSelectionModel.isSelectionEmpty()) {
            int n = this.m_loopSelectionModel.getMinSelectionIndex();
            SourceLocation sourceLocation = this.m_loopModel.getFuncSourceLocation(this.m_loopProfileTable.convertRowIndexToModel(n));
            this.showSource(sourceLocation);
        }
    }

    private void viewLoopSourceAction() {
        if (!this.m_loopSelectionModel.isSelectionEmpty()) {
            int n = this.m_loopSelectionModel.getMinSelectionIndex();
            SourceLocation sourceLocation = this.m_loopModel.getLoopSourceLocation(this.m_loopProfileTable.convertRowIndexToModel(n));
            this.showSource(sourceLocation);
        }
    }

    private void closeView() {
        if (this.m_view != null) {
            this.disableView();
            this.m_closeItem.setEnabled(false);
            this.m_funcProfileTable = null;
            this.m_loopProfileTable = null;
            this.m_view = null;
            this.setTitle(this.m_defaultTitle);
        }
        this.repaint();
    }

    private void disableView() {
        if (this.m_view != null) {
            this.getContentPane().remove(this.m_view);
            this.m_view = null;
            this.m_printFuncItem.setEnabled(false);
            this.m_printLoopItem.setEnabled(false);
            this.m_columnsItem.setEnabled(false);
            this.m_viewFunctionSourceItem.setEnabled(false);
            this.m_viewLoopFunctionSourceItem.setEnabled(false);
            this.m_viewLoopSourceItem.setEnabled(false);
            this.m_functionTicksItem.setEnabled(false);
            this.m_functionSelfItem.setEnabled(false);
            this.m_loopTicksItem.setEnabled(false);
            this.m_loopSelfItem.setEnabled(false);
            this.m_filterLoopsByFunctionNameItem.setEnabled(false);
            if (this.m_funcProfileTable != null) {
                this.m_functionTicksFilter.removeListener(this.m_funcProfileTable);
                this.m_functionSelfFilter.removeListener(this.m_funcProfileTable);
                this.m_functionLoopNameFilter.removeListener(this.m_funcProfileTable);
            }
            if (this.m_loopProfileTable != null) {
                this.m_loopTicksFilter.removeListener(this.m_loopProfileTable);
                this.m_loopSelfFilter.removeListener(this.m_loopProfileTable);
                this.m_functionNameFilter.removeListener(this.m_loopProfileTable);
            }
        }
    }

    private void enableView(JComponent jComponent) {
        this.disableView();
        this.m_view = jComponent;
        if (this.m_view != null) {
            this.getContentPane().add(this.m_view);
            this.m_closeItem.setEnabled(true);
            if (this.m_funcProfileTable != null) {
                this.m_functionTicksFilter.addListener(this.m_funcProfileTable);
                this.m_functionSelfFilter.addListener(this.m_funcProfileTable);
                this.m_functionLoopNameFilter.addListener(this.m_funcProfileTable);
                this.m_printFuncItem.setEnabled(true);
                this.m_columnsItem.setEnabled(true);
                this.m_functionTicksItem.setEnabled(true);
                this.m_functionSelfItem.setEnabled(true);
            }
            if (this.m_loopProfileTable != null) {
                this.m_printLoopItem.setEnabled(true);
                this.m_loopTicksItem.setEnabled(true);
                this.m_loopSelfItem.setEnabled(true);
                this.m_filterLoopsByFunctionNameItem.setEnabled(true);
                this.m_filterLoopsByFunctionNamePopupItem.setEnabled(true);
                this.m_loopTicksFilter.addListener(this.m_loopProfileTable);
                this.m_loopSelfFilter.addListener(this.m_loopProfileTable);
                this.m_functionNameFilter.addListener(this.m_loopProfileTable);
            }
        } else {
            this.closeView();
        }
        this.setVisible(true);
        this.getContentPane().repaint();
    }

    private JComponent createView(FuncProfileTableModel funcProfileTableModel, LoopProfileTableModel loopProfileTableModel) {
        JComponent jComponent;
        JPanel jPanel = null;
        JPanel jPanel2 = null;
        this.m_funcProfileTable = null;
        this.m_loopProfileTable = null;
        this.m_funcModel = funcProfileTableModel;
        this.m_loopModel = loopProfileTableModel;
        LoopProfileViewerStrings loopProfileViewerStrings = LoopProfileViewerStrings.getInstance();
        String string = loopProfileViewerStrings.getString("app.function_profile_border.label");
        String string2 = loopProfileViewerStrings.getString("app.loop_profile_border.label");
        if (funcProfileTableModel != null) {
            this.m_funcProfileTable = new FuncProfileTable(funcProfileTableModel, this.m_functionTicksFilter, this.m_functionSelfFilter, this.m_functionLoopNameFilter);
            jComponent = new JScrollPane(this.m_funcProfileTable);
            jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
            jPanel.add((Component)jComponent, "Center");
            this.m_funcProfileTable.setFillsViewportHeight(true);
            this.m_funcProfileTable.setComponentPopupMenu(this.m_funcPopupMenu);
            if (loopProfileTableModel == null) {
                this.m_funcProfileTable.setLoopPercColumnUnviewable();
            }
        }
        if (loopProfileTableModel != null) {
            this.m_loopProfileTable = new LoopProfileTable(loopProfileTableModel, this.m_loopTicksFilter, this.m_loopSelfFilter, this.m_functionNameFilter);
            jComponent = new JScrollPane(this.m_loopProfileTable);
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createTitledBorder(string2));
            jPanel2.add((Component)jComponent, "Center");
            this.m_loopProfileTable.setFillsViewportHeight(true);
            this.m_loopProfileTable.setComponentPopupMenu(this.m_loopPopupMenu);
        }
        if (jPanel != null) {
            this.m_funcSelectionModel = this.m_funcProfileTable.getSelectionModel();
            this.m_funcSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!ViewerFrame.this.m_funcSelectionModel.isSelectionEmpty()) {
                        int n = ViewerFrame.this.m_funcSelectionModel.getMinSelectionIndex();
                        String string = (String)ViewerFrame.this.m_funcModel.getValueAt(ViewerFrame.this.m_funcProfileTable.convertRowIndexToModel(n), 0);
                        ViewerFrame.this.m_functionNameFilter.setValue(string);
                        ViewerFrame.this.m_viewFunctionSourceItem.setEnabled(true);
                        ViewerFrame.this.m_viewFunctionSourcePopupItem.setEnabled(true);
                    } else {
                        ViewerFrame.this.m_functionNameFilter.setValue(null);
                        ViewerFrame.this.m_viewFunctionSourceItem.setEnabled(false);
                        ViewerFrame.this.m_viewFunctionSourcePopupItem.setEnabled(false);
                    }
                }
            });
        }
        if (jPanel2 != null) {
            this.m_loopSelectionModel = this.m_loopProfileTable.getSelectionModel();
            this.m_loopSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!ViewerFrame.this.m_loopSelectionModel.isSelectionEmpty()) {
                        int n = ViewerFrame.this.m_loopSelectionModel.getMinSelectionIndex();
                        String string = (String)ViewerFrame.this.m_loopModel.getValueAt(ViewerFrame.this.m_loopProfileTable.convertRowIndexToModel(n), 0);
                        ViewerFrame.this.m_functionLoopNameFilter.setValue(string);
                        ViewerFrame.this.m_viewLoopFunctionSourceItem.setEnabled(true);
                        ViewerFrame.this.m_viewLoopSourceItem.setEnabled(true);
                        ViewerFrame.this.m_viewLoopFunctionSourcePopupItem.setEnabled(true);
                        ViewerFrame.this.m_viewLoopSourcePopupItem.setEnabled(true);
                    } else {
                        ViewerFrame.this.m_functionLoopNameFilter.setValue(null);
                        ViewerFrame.this.m_viewLoopFunctionSourceItem.setEnabled(false);
                        ViewerFrame.this.m_viewLoopSourceItem.setEnabled(false);
                        ViewerFrame.this.m_viewLoopFunctionSourcePopupItem.setEnabled(false);
                        ViewerFrame.this.m_viewLoopSourcePopupItem.setEnabled(false);
                    }
                }
            });
        }
        if (jPanel != null && jPanel2 != null) {
            jComponent = new JSplitPane(0, jPanel, jPanel2);
            ((JSplitPane)jComponent).setOneTouchExpandable(true);
            ((JSplitPane)jComponent).setResizeWeight(0.5);
            return jComponent;
        }
        if (jPanel != null) {
            return jPanel;
        }
        return null;
    }

    public Boolean openFile(String string) {
        File file = new File(string);
        FuncProfileTableModel funcProfileTableModel = null;
        LoopProfileTableModel loopProfileTableModel = null;
        int n = 1;
        if (file.exists()) {
            String string2 = file.getAbsolutePath();
            int n2 = string2.lastIndexOf(File.separator);
            if (n2 != -1) {
                this.m_lastPath = string2.substring(0, n2);
            }
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                Element element = document.getDocumentElement();
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element)) continue;
                    Element element2 = (Element)node;
                    if (element2.getTagName().equals("functions")) {
                        funcProfileTableModel = new FuncProfileTableModel(element2.getChildNodes());
                        continue;
                    }
                    if (!element2.getTagName().equals("loops")) continue;
                    NamedNodeMap namedNodeMap = element2.getAttributes();
                    for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                        if (!namedNodeMap.item(j).getNodeName().equals("reportlevel")) continue;
                        n = Integer.valueOf(namedNodeMap.item(j).getNodeValue());
                    }
                    loopProfileTableModel = new LoopProfileTableModel(element2.getChildNodes(), n);
                }
                JComponent jComponent = this.createView(funcProfileTableModel, loopProfileTableModel);
                this.enableView(jComponent);
                this.setTitle(this.m_defaultTitle + ": " + string);
                return true;
            }
            catch (Exception exception) {
                LoopProfileViewerStrings loopProfileViewerStrings = LoopProfileViewerStrings.getInstance();
                String string3 = loopProfileViewerStrings.getString("error.xml_parse_error.label");
                String string4 = loopProfileViewerStrings.getString("dialog.error.title");
                JOptionPane.showMessageDialog(this.getRootPane(), string3, string4, 0);
                return false;
            }
        }
        LoopProfileViewerStrings loopProfileViewerStrings = LoopProfileViewerStrings.getInstance();
        String string5 = loopProfileViewerStrings.getString("error.open_error.label");
        String string6 = loopProfileViewerStrings.getString("dialog.error.title");
        JOptionPane.showMessageDialog(this.getRootPane(), string5 + ": " + string, string6, 0);
        return false;
    }
}

