/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class LoopProfileTableModel
extends AbstractTableModel {
    public static final int FUNCTION_NAME_COLUMN = 0;
    public static final int FUNC_FILE_COLUMN = 1;
    public static final int LOOP_FILE_COLUMN = 2;
    public static final int TICKS_ABS_COLUMN = 3;
    public static final int TICKS_PERC_COLUMN = 4;
    public static final int SELF_ABS_COLUMN = 5;
    public static final int SELF_PERC_COLUMN = 6;
    public static final int LOOP_ENTRIES_COLUMN = 7;
    public static final int LOOP_EXITS_COLUMN = 8;
    public static final int MIN_ITERATIONS_COLUMN = 9;
    public static final int AVERAGE_ITERATIONS_COLUMN = 10;
    public static final int MAX_ITERATIONS_COLUMN = 11;
    public static final int MAX_COLUMN_CNT = 12;
    private static String[] m_columnNames = new String[12];
    private static String[] m_columnTips = new String[12];
    private ArrayList<LoopProfileRecord> m_data = new ArrayList();
    private int m_modelLevel;

    public LoopProfileTableModel(NodeList nodeList, int n) {
        Object object;
        Object object2;
        int n2;
        this.m_modelLevel = n;
        LoopProfileViewerStrings loopProfileViewerStrings = LoopProfileViewerStrings.getInstance();
        for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
            String string;
            String string2;
            object2 = new Integer(n2);
            object = "loop_table.column" + ((Integer)object2).toString() + ".label";
            LoopProfileTableModel.m_columnNames[n2] = string2 = loopProfileViewerStrings.getString((String)object);
            String string3 = "loop_table.column" + ((Integer)object2).toString() + ".tip";
            LoopProfileTableModel.m_columnTips[n2] = string = loopProfileViewerStrings.getString(string3);
        }
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            object2 = nodeList.item(n2);
            if (!(object2 instanceof Element) || !(object = (Element)object2).getTagName().equals("loop")) continue;
            this.parseLoop(object.getChildNodes());
        }
    }

    private void parseLoop(NodeList nodeList) {
        String string = "<unknown>";
        SourceLocation sourceLocation = null;
        SourceLocation sourceLocation2 = null;
        float f = 0.0f;
        long l = 0L;
        float f2 = 0.0f;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            String string2 = "";
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (element.getFirstChild().getNodeType() == 3) {
                object = (Text)element.getFirstChild();
                string2 = object.getData();
            }
            if (element.getTagName().equals("ticks_perc")) {
                f = Float.valueOf(string2).floatValue();
                continue;
            }
            if (element.getTagName().equals("ticks_abs")) {
                l = Long.valueOf(string2);
                continue;
            }
            if (element.getTagName().equals("self_perc")) {
                f2 = Float.valueOf(string2).floatValue();
                continue;
            }
            if (element.getTagName().equals("self_abs")) {
                l2 = Long.valueOf(string2);
                continue;
            }
            if (element.getTagName().equals("entry_cnt")) {
                l3 = Long.valueOf(string2);
                continue;
            }
            if (element.getTagName().equals("exit_cnt")) {
                l4 = Long.valueOf(string2);
                continue;
            }
            if (element.getTagName().equals("avg_trip_cnt")) {
                l5 = Long.valueOf(string2);
                continue;
            }
            if (element.getTagName().equals("min_trip_cnt")) {
                l6 = Long.valueOf(string2);
                continue;
            }
            if (element.getTagName().equals("max_trip_cnt")) {
                l7 = Long.valueOf(string2);
                continue;
            }
            if (element.getTagName().equals("function")) {
                object = (Text)element.getFirstChild();
                string = object.getData().trim();
                continue;
            }
            if (element.getTagName().equals("src_file")) {
                object = element.getChildNodes();
                sourceLocation2 = this.parseFileNode((NodeList)object);
                continue;
            }
            if (!element.getTagName().equals("comp_file")) continue;
            object = element.getChildNodes();
            sourceLocation = this.parseFileNode((NodeList)object);
        }
        LoopProfileRecord loopProfileRecord = new LoopProfileRecord(string, sourceLocation, sourceLocation2, f, l, f2, l2, l3, l4, l5, l6, l7);
        this.m_data.add(loopProfileRecord);
    }

    private SourceLocation parseFileNode(NodeList nodeList) {
        String string = "<unknown>";
        String string2 = null;
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            Text text = (Text)node.getFirstChild();
            if (element.getTagName().equals("name")) {
                string = text.getData().trim();
                continue;
            }
            if (element.getTagName().equals("path")) {
                string2 = text.getData().trim();
                continue;
            }
            if (!element.getTagName().equals("line")) continue;
            n = Integer.valueOf(text.getData());
        }
        return new SourceLocation(string, string2, n);
    }

    @Override
    public int getColumnCount() {
        return 12;
    }

    @Override
    public int getRowCount() {
        return this.m_data.size();
    }

    @Override
    public String getColumnName(int n) {
        return m_columnNames[n];
    }

    public String getColumnTip(int n) {
        return m_columnTips[n];
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        LoopProfileRecord loopProfileRecord = this.m_data.get(n);
        switch (n2) {
            case 4: {
                return Float.valueOf(loopProfileRecord.m_ticksPerc);
            }
            case 3: {
                return loopProfileRecord.m_ticksAbs;
            }
            case 6: {
                return Float.valueOf(loopProfileRecord.m_selfPerc);
            }
            case 5: {
                return loopProfileRecord.m_selfAbs;
            }
            case 7: {
                return loopProfileRecord.m_calls;
            }
            case 8: {
                return loopProfileRecord.m_exits;
            }
            case 10: {
                return loopProfileRecord.m_avgTripCnt;
            }
            case 9: {
                return loopProfileRecord.m_minTripCnt;
            }
            case 11: {
                return loopProfileRecord.m_maxTripCnt;
            }
            case 0: {
                return loopProfileRecord.m_name;
            }
            case 2: {
                return loopProfileRecord.m_loopLocation;
            }
            case 1: {
                return loopProfileRecord.m_funcLocation;
            }
        }
        return 0;
    }

    public int getModelLevel() {
        return this.m_modelLevel;
    }

    public SourceLocation getFuncSourceLocation(int n) {
        return this.m_data.get((int)n).m_funcLocation;
    }

    public SourceLocation getLoopSourceLocation(int n) {
        return this.m_data.get((int)n).m_loopLocation;
    }

    private class LoopProfileRecord {
        public String m_name;
        public SourceLocation m_funcLocation;
        public SourceLocation m_loopLocation;
        public float m_ticksPerc;
        public long m_ticksAbs;
        public float m_selfPerc;
        public long m_selfAbs;
        public long m_calls;
        public long m_exits;
        public long m_avgTripCnt;
        public long m_minTripCnt;
        public long m_maxTripCnt;

        public LoopProfileRecord(String string, SourceLocation sourceLocation, SourceLocation sourceLocation2, float f, long l, float f2, long l2, long l3, long l4, long l5, long l6, long l7) {
            this.m_name = string;
            this.m_funcLocation = sourceLocation;
            this.m_loopLocation = sourceLocation2;
            this.m_ticksPerc = f;
            this.m_ticksAbs = l;
            this.m_selfPerc = f2;
            this.m_selfAbs = l2;
            this.m_calls = l3;
            this.m_exits = l4;
            this.m_avgTripCnt = l5;
            this.m_minTripCnt = l6;
            this.m_maxTripCnt = l7;
        }
    }
}

