/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

class LoopProfileTable
extends JTable
implements filter_listener {
    private LoopProfileTableModel m_loopProfileTableModel;
    private Filter<Float> m_ticksFilter;
    private Filter<Float> m_selfFilter;
    private Filter<String> m_functionFilter;
    private TableRowSorter<LoopProfileTableModel> m_filterSorter;
    private Boolean[] m_viewableColumns;
    private Boolean[] m_visibleColumns;
    private TableColumn[] m_columns;

    public LoopProfileTable(LoopProfileTableModel loopProfileTableModel, Filter<Float> filter, Filter<Float> filter2, Filter<String> filter3) {
        super(loopProfileTableModel);
        this.m_loopProfileTableModel = loopProfileTableModel;
        this.m_viewableColumns = new Boolean[loopProfileTableModel.getColumnCount()];
        this.m_visibleColumns = new Boolean[loopProfileTableModel.getColumnCount()];
        this.m_columns = new TableColumn[loopProfileTableModel.getColumnCount()];
        this.m_ticksFilter = filter;
        this.m_selfFilter = filter2;
        this.m_functionFilter = filter3;
        this.getSelectionModel().setSelectionMode(0);
        this.setDefaultRenderer(Float.class, new PercentTableCellRenderer());
        this.setDefaultRenderer(Long.class, new LongTableCellRenderer());
        this.m_filterSorter = new TableRowSorter<LoopProfileTableModel>(loopProfileTableModel);
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
        arrayList.add(new RowSorter.SortKey(5, SortOrder.DESCENDING));
        this.m_filterSorter.setSortKeys(arrayList);
        this.setRowSorter(this.m_filterSorter);
        for (int i = 0; i < loopProfileTableModel.getColumnCount(); ++i) {
            this.m_viewableColumns[i] = true;
            this.m_visibleColumns[i] = true;
            this.m_columns[i] = this.columnModel.getColumn(i);
            Class clazz = loopProfileTableModel.getColumnClass(i);
            if (clazz == String.class || clazz == SourceLocation.class) {
                this.columnModel.getColumn(i).setPreferredWidth(80);
                continue;
            }
            if (clazz == Long.class) {
                this.columnModel.getColumn(i).setPreferredWidth(40);
                continue;
            }
            this.columnModel.getColumn(i).setPreferredWidth(8);
        }
        if (loopProfileTableModel.getModelLevel() == 1) {
            this.m_viewableColumns[10] = false;
            this.m_viewableColumns[9] = false;
            this.m_viewableColumns[11] = false;
            this.m_visibleColumns[10] = false;
            this.m_visibleColumns[9] = false;
            this.m_visibleColumns[11] = false;
            this.removeColumn(this.columnModel.getColumn(this.convertColumnIndexToView(10)));
            this.removeColumn(this.columnModel.getColumn(this.convertColumnIndexToView(9)));
            this.removeColumn(this.columnModel.getColumn(this.convertColumnIndexToView(11)));
            this.m_viewableColumns[8] = false;
            this.m_visibleColumns[8] = false;
            this.removeColumn(this.columnModel.getColumn(this.convertColumnIndexToView(8)));
        } else {
            this.removeColumn(this.columnModel.getColumn(this.convertColumnIndexToView(8)));
            this.m_visibleColumns[8] = false;
        }
        this.m_viewableColumns[0] = false;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.columnModel.getColumnIndexAtX(point.x);
                int n2 = this.columnModel.getColumn(n).getModelIndex();
                return LoopProfileTable.this.m_loopProfileTableModel.getColumnTip(n2);
            }
        };
    }

    public Boolean getColumnViewable(int n) {
        return this.m_viewableColumns[n];
    }

    public Boolean getColumnVisible(int n) {
        return this.m_visibleColumns[n];
    }

    public void showColumn(int n) {
        if (!this.m_visibleColumns[n].booleanValue()) {
            this.addColumn(this.m_columns[n]);
            this.m_visibleColumns[n] = true;
        }
    }

    public void hideColumn(int n) {
        if (this.m_visibleColumns[n].booleanValue()) {
            this.removeColumn(this.m_columns[n]);
            this.m_visibleColumns[n] = false;
        }
    }

    @Override
    public void filterChanged() {
        RowFilter<LoopProfileTableModel, Integer> rowFilter;
        ArrayList<2> arrayList = new ArrayList<2>();
        if (this.m_ticksFilter.isSelected().booleanValue()) {
            rowFilter = new RowFilter<LoopProfileTableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends LoopProfileTableModel, ? extends Integer> entry) {
                    Integer n;
                    LoopProfileTableModel loopProfileTableModel = entry.getModel();
                    Float f = (Float)loopProfileTableModel.getValueAt(n = entry.getIdentifier(), 4);
                    float f2 = f.floatValue();
                    return f2 > ((Float)LoopProfileTable.this.m_ticksFilter.getValue()).floatValue() * 100.0f;
                }
            };
            arrayList.add(rowFilter);
        }
        if (this.m_selfFilter.isSelected().booleanValue()) {
            rowFilter = new RowFilter<LoopProfileTableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends LoopProfileTableModel, ? extends Integer> entry) {
                    Integer n;
                    LoopProfileTableModel loopProfileTableModel = entry.getModel();
                    Float f = (Float)loopProfileTableModel.getValueAt(n = entry.getIdentifier(), 6);
                    float f2 = f.floatValue();
                    return f2 > ((Float)LoopProfileTable.this.m_selfFilter.getValue()).floatValue() * 100.0f;
                }
            };
            arrayList.add(rowFilter);
        }
        if (this.m_functionFilter.isSelected().booleanValue() && this.m_functionFilter.getValue() != null) {
            rowFilter = new RowFilter<LoopProfileTableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends LoopProfileTableModel, ? extends Integer> entry) {
                    Integer n;
                    LoopProfileTableModel loopProfileTableModel = entry.getModel();
                    String string = (String)loopProfileTableModel.getValueAt(n = entry.getIdentifier(), 0);
                    return string.equals(LoopProfileTable.this.m_functionFilter.getValue());
                }
            };
            arrayList.add(rowFilter);
        }
        if (arrayList.size() >= 1) {
            this.m_filterSorter.setRowFilter(RowFilter.andFilter(arrayList));
        } else {
            this.m_filterSorter.setRowFilter(null);
        }
    }
}

