/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

class FuncProfileTable
extends JTable
implements filter_listener {
    private FuncProfileTableModel m_funcProfileTableModel;
    private Boolean[] m_viewableColumns;
    private Boolean[] m_visibleColumns;
    private TableColumn[] m_columns;
    private Filter<Float> m_ticksFilter;
    private Filter<Float> m_selfFilter;
    private Filter<String> m_functionFilter;
    private TableRowSorter<FuncProfileTableModel> m_filterSorter;

    public FuncProfileTable(FuncProfileTableModel funcProfileTableModel, Filter<Float> filter, Filter<Float> filter2, Filter<String> filter3) {
        super(funcProfileTableModel);
        this.m_funcProfileTableModel = funcProfileTableModel;
        this.m_viewableColumns = new Boolean[funcProfileTableModel.getColumnCount()];
        this.m_visibleColumns = new Boolean[funcProfileTableModel.getColumnCount()];
        this.m_columns = new TableColumn[funcProfileTableModel.getColumnCount()];
        this.m_ticksFilter = filter;
        this.m_selfFilter = filter2;
        this.m_functionFilter = filter3;
        this.getSelectionModel().setSelectionMode(0);
        this.setDefaultRenderer(Float.class, new PercentTableCellRenderer());
        this.setDefaultRenderer(Long.class, new LongTableCellRenderer());
        this.m_filterSorter = new TableRowSorter<FuncProfileTableModel>(funcProfileTableModel);
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
        arrayList.add(new RowSorter.SortKey(4, SortOrder.DESCENDING));
        this.m_filterSorter.setSortKeys(arrayList);
        this.setRowSorter(this.m_filterSorter);
        for (int i = 0; i < funcProfileTableModel.getColumnCount(); ++i) {
            this.m_viewableColumns[i] = true;
            this.m_visibleColumns[i] = true;
            this.m_columns[i] = this.columnModel.getColumn(i);
            Class clazz = funcProfileTableModel.getColumnClass(i);
            if (clazz == String.class || clazz == SourceLocation.class) {
                this.columnModel.getColumn(i).setPreferredWidth(80);
                continue;
            }
            if (clazz == Long.class) {
                this.columnModel.getColumn(i).setPreferredWidth(40);
                continue;
            }
            this.columnModel.getColumn(i).setPreferredWidth(8);
        }
        this.m_viewableColumns[0] = false;
        this.removeColumn(this.columnModel.getColumn(this.convertColumnIndexToView(7)));
        this.m_visibleColumns[7] = false;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.columnModel.getColumnIndexAtX(point.x);
                int n2 = this.columnModel.getColumn(n).getModelIndex();
                return FuncProfileTable.this.m_funcProfileTableModel.getColumnTip(n2);
            }
        };
    }

    public void setLoopPercColumnUnviewable() {
        this.m_viewableColumns[8] = false;
        this.removeColumn(this.m_columns[8]);
    }

    public Boolean getColumnViewable(int n) {
        return this.m_viewableColumns[n];
    }

    public Boolean getColumnVisible(int n) {
        return this.m_visibleColumns[n];
    }

    public void showColumn(int n) {
        if (this.m_viewableColumns[n].booleanValue() && !this.m_visibleColumns[n].booleanValue()) {
            this.addColumn(this.m_columns[n]);
            this.m_visibleColumns[n] = true;
        }
    }

    public void hideColumn(int n) {
        if (this.m_visibleColumns[n].booleanValue()) {
            this.removeColumn(this.m_columns[n]);
            this.m_visibleColumns[n] = false;
        }
    }

    @Override
    public void filterChanged() {
        RowFilter<FuncProfileTableModel, Integer> rowFilter;
        ArrayList<2> arrayList = new ArrayList<2>();
        if (this.m_ticksFilter.isSelected().booleanValue()) {
            rowFilter = new RowFilter<FuncProfileTableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends FuncProfileTableModel, ? extends Integer> entry) {
                    Integer n;
                    FuncProfileTableModel funcProfileTableModel = entry.getModel();
                    Float f = (Float)funcProfileTableModel.getValueAt(n = entry.getIdentifier(), 3);
                    float f2 = f.floatValue();
                    return f2 > ((Float)FuncProfileTable.this.m_ticksFilter.getValue()).floatValue() * 100.0f;
                }
            };
            arrayList.add(rowFilter);
        }
        if (this.m_selfFilter.isSelected().booleanValue()) {
            rowFilter = new RowFilter<FuncProfileTableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends FuncProfileTableModel, ? extends Integer> entry) {
                    Integer n;
                    FuncProfileTableModel funcProfileTableModel = entry.getModel();
                    Float f = (Float)funcProfileTableModel.getValueAt(n = entry.getIdentifier(), 5);
                    float f2 = f.floatValue();
                    return f2 > ((Float)FuncProfileTable.this.m_selfFilter.getValue()).floatValue() * 100.0f;
                }
            };
            arrayList.add(rowFilter);
        }
        if (this.m_functionFilter.isSelected().booleanValue() && this.m_functionFilter.getValue() != null) {
            rowFilter = new RowFilter<FuncProfileTableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends FuncProfileTableModel, ? extends Integer> entry) {
                    Integer n;
                    FuncProfileTableModel funcProfileTableModel = entry.getModel();
                    String string = (String)funcProfileTableModel.getValueAt(n = entry.getIdentifier(), 0);
                    return string.equals(FuncProfileTable.this.m_functionFilter.getValue());
                }
            };
            arrayList.add(rowFilter);
        }
        if (arrayList.size() >= 1) {
            this.m_filterSorter.setRowFilter(RowFilter.andFilter(arrayList));
        } else {
            this.m_filterSorter.setRowFilter(null);
        }
    }
}

