#include "v_func.hh"
#include <iostream>
#include <iomanip>

using namespace std;
using namespace GSL;

double delta_x[3] = {1e-3, 1e-3, 1e-3};

class ExampleVectorFunction : public VectorFunction
{
public:
      ExampleVectorFunction () : VectorFunction (2, 3) {}

      virtual void Value (double * f, const double * x)
      {
            f[0] = x[0] * x[0] - x[0] * x[1] + 2 * x[1] * x[1] - 1.0 + x[2] * x[2] * x[2];
            f[1] = x[1] * x[1] * x[1] - 2 * x[0] + 5 * x[0] * x[1] + 3 - x[1] * x[2];
      }
};

ExampleVectorFunction evf;

class ExampleJacobiFunction : public JacobiFunction
{
public:
      ExampleJacobiFunction () : JacobiFunction (evf) {}

      virtual void Value (double * J, const double * x)
      {
            J[0] = 2 * x[0] - x[1];
            J[1] = - x[0] + 4 * x[1];
            J[2] = 3 * x[2] * x[2];

            J[3] = - 2. + 5. * x[1];
            J[4] = 3. * x[1] * x[1] + 5. * x[0] - x[2];
            J[5] = - x[1];
      }
};

ExampleJacobiFunction ejf;

NumericalJacobiFunction njf (evf, delta_x, 2);

int main ()
{
      int i, j;

      double nJ[6], eJ[6];

      double x[3] = {1.0, 2.0, 3.0};

      ejf.Value (eJ, x);
      njf.Value (nJ, x);
      
      cout << setprecision(15);
      cout << "Exact:" << endl;
      for (i = 0; i < 6; i ++) cout << eJ[i] << "\t";
      cout << endl << "Numerical:" << endl;
      for (i = 0; i < 6; i ++) cout << nJ[i] << "\t";
      cout << endl;

      return 0;
}
