#ifndef ls_
#define ls_

#include "v_func.hh"
#include <gsl/gsl_multifit_nlin.h>

namespace GSL {

extern const gsl_multifit_fdfsolver_type * const LMSDER;
extern const gsl_multifit_fdfsolver_type * const LMDER;

int f (const gsl_vector * x, void * data, gsl_vector * res);
int df (const gsl_vector * x, void * data, gsl_matrix * J);
int fdf (const gsl_vector * x, void * data, gsl_vector * res, gsl_matrix * J);

class LSVectorFunction : public VectorFunction
{
private:

      double * y;

public:

      LSVectorFunction (int n, int p); 
      virtual ~LSVectorFunction () { delete [] y; }
      
      void SetY (double * y_);
      void GetY (double * y_);

      virtual void RealFunction (double * f, const double * x) = 0;

      virtual void Value (double * f, const double * x);
};

class LSAllFunction 
{
private:

      VectorFunction & vf;
      JacobiFunction & jf;
      JacobiVectorFunction & jvf;

public:

      LSAllFunction (VectorFunction & vf_, JacobiFunction & jf_, JacobiVectorFunction & jvf_);

      void Value (double * f, const double * x) { vf.Value(f, x); }
      void Jacobi (double * J, const double * x) { jf.Value(J, x); }
      void JacobiValue (double * f, double * J, const double * x) { jvf.Value(f, J, x); }

      int GetN () { return vf.GetN(); }
      int GetP () { return vf.GetP(); }
};

class LSSolver
{
private:

      LSAllFunction & laf;

      int n, p;
      gsl_multifit_fdfsolver * solver;
      gsl_multifit_function_fdf func;

      bool after_iter;

public:

      LSSolver (LSAllFunction & laf_, const gsl_multifit_fdfsolver_type * s_type, double * x_init);
      virtual ~LSSolver ();
      
      int Iterate ();
      bool TestDelta (double epsabs, double epsrel);
      bool TestGradient (double epsabs);

      void SetX (double * x);

      void GetX (double * x);
      void GetF (double * f);
      void GetGradient (double * gx);
      double GetResidual ();
      void GetCovariance (double epsrel, double * covar);
};

}

#endif
